/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.gen.CandiEnhancedBean;
import com.caucho.config.gen.CandiUtil;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.ejb.cfg.EjbLazyGenerator;
import com.caucho.ejb.gen.SingletonGenerator;
import com.caucho.ejb.inject.SessionBeanImpl;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.server.AbstractContext;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.ejb.session.AbstractSessionManager;
import com.caucho.ejb.session.SingletonContext;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEJBException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.SessionBeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonManager<X>
extends AbstractSessionManager<X> {
    private static final L10N L = new L10N(SingletonManager.class);
    private static final Logger log = Logger.getLogger(SingletonManager.class.getName());
    private X _instance;
    private Object _decoratorClass;
    private List<Decorator<?>> _decoratorBeans;

    public SingletonManager(EjbManager ejbContainer, String moduleName, AnnotatedType<X> rawAnnType, AnnotatedType<X> annotatedType, EjbLazyGenerator<X> lazyGenerator) {
        super(ejbContainer, moduleName, rawAnnType, annotatedType, lazyGenerator);
    }

    @Override
    protected String getType() {
        return "singleton:";
    }

    @Override
    protected SessionBeanType getSessionBeanType() {
        return SessionBeanType.SINGLETON;
    }

    @Override
    protected <T> SingletonContext<X, T> getSessionContext(Class<T> api) {
        return (SingletonContext)super.getSessionContext(api);
    }

    @Override
    public <T> Object getLocalJndiProxy(Class<T> api) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind() {
        super.bind();
        Class<?> instanceClass = this.getProxyImplClass();
        if (instanceClass != null && CandiEnhancedBean.class.isAssignableFrom(instanceClass)) {
            try {
                Method method = instanceClass.getMethod("__caucho_decorator_init", new Class[0]);
                this._decoratorClass = method.invoke(null, new Object[0]);
                Annotation[] qualifiers = new Annotation[this.getBean().getQualifiers().size()];
                this.getBean().getQualifiers().toArray(qualifiers);
                InjectManager moduleBeanManager = InjectManager.create();
                this._decoratorBeans = moduleBeanManager.resolveDecorators(this.getBean().getTypes(), qualifiers);
                method = instanceClass.getMethod("__caucho_init_decorators", List.class);
                method.invoke(null, this._decoratorBeans);
            }
            catch (InvocationTargetException e) {
                throw ConfigException.create(e.getCause());
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    @Override
    public X newInstance(CreationalContextImpl<X> env) {
        if (this._instance == null) {
            this._instance = super.newInstance(env);
        }
        return this._instance;
    }

    @Override
    protected void postStart() {
        OwnerCreationalContext env = new OwnerCreationalContext(this.getBean());
        this.newInstance(env);
    }

    public <T> T initProxy(T proxy, CreationalContextImpl<T> env) {
        if (proxy instanceof CandiEnhancedBean) {
            try {
                CandiEnhancedBean bean = (CandiEnhancedBean)proxy;
                Object[] delegates = this.createDelegates(env);
                bean.__caucho_inject(delegates, env);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return proxy;
    }

    private Object[] createDelegates(CreationalContextImpl<?> env) {
        if (this._decoratorBeans != null) {
            return CandiUtil.generateProxyDelegate(this.getInjectManager(), this._decoratorBeans, this._decoratorClass, env);
        }
        return null;
    }

    @Override
    public void destroy(Object instance, CreationalContextImpl env) {
    }

    @Override
    public void destroyInstance(X instance) {
    }

    @Override
    protected <T> Bean<T> createBean(ManagedBeanImpl<X> mBean, Class<T> api, Set<Type> apiList, AnnotatedType<X> extAnnType) {
        AbstractSessionContext context = this.getSessionContext((Class)api);
        if (context == null) {
            throw new NullPointerException(L.l("'{0}' is an unknown api for {1}", api, this));
        }
        SessionBeanImpl statefulBean = new SessionBeanImpl(context, mBean, apiList, extAnnType);
        InjectManager manager = this.getModuleInjectManager();
        if (manager.isNormalScope(statefulBean.getScope()) && ApplicationScoped.class != statefulBean.getScope()) {
            throw new ConfigException(L.l("{0} is an invalid @Singleton EJB because it has @{1} scope.", (Object)api.getName(), statefulBean.getScope()));
        }
        return statefulBean;
    }

    @Override
    protected <T> SingletonContext<X, T> createSessionContext(Class<T> api) {
        return new SingletonContext(this, api);
    }

    @Override
    protected Class<?> getContextClass() {
        return SingletonContext.class;
    }

    @Override
    protected BeanGenerator<X> createBeanGenerator() {
        EjbLazyGenerator lazyGen = this.getLazyGenerator();
        return new SingletonGenerator(this.getEJBName(), this.getAnnotatedType(), lazyGen.getLocalApi(), lazyGen.getLocalBean(), lazyGen.getRemoteApi());
    }

    @Override
    public AbstractContext getContext(Object key, boolean forceLoad) throws FinderException {
        throw new NoSuchEJBException("no matching object:" + key);
    }

    @Override
    public void destroy() {
        super.destroy();
        log.fine(this + " closed");
    }

    @Override
    public <T> T getRemoteObject(Class<T> api, String protocol) {
        return null;
    }
}

