/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.ejb.session.StatelessContext;
import com.caucho.ejb.session.StatelessManager;
import com.caucho.inject.Module;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.SessionBean;
import javax.enterprise.inject.spi.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class StatelessPool<X, T> {
    private static final Logger log = Logger.getLogger(StatelessPool.class.getName());
    private static final L10N L = new L10N(StatelessPool.class);
    private final StatelessManager<X> _manager;
    private final StatelessContext<X, T> _context;
    private final List<Interceptor<?>> _interceptorBeans;
    private final FreeList<Item<X>> _freeList;
    private final Semaphore _concurrentSemaphore;
    private final long _concurrentTimeout;

    StatelessPool(StatelessManager<X> manager, StatelessContext<X, T> context, List<Interceptor<?>> interceptorBeans) {
        this._manager = manager;
        this._context = context;
        this._interceptorBeans = interceptorBeans;
        int idleMax = manager.getSessionIdleMax();
        int concurrentMax = manager.getSessionConcurrentMax();
        if (idleMax < 0) {
            idleMax = concurrentMax;
        }
        if (idleMax < 0) {
            idleMax = 16;
        }
        this._freeList = new FreeList(idleMax);
        if (concurrentMax == 0) {
            throw new IllegalArgumentException(L.l("maxConcurrent may not be zero"));
        }
        long concurrentTimeout = manager.getSessionConcurrentTimeout();
        if (concurrentTimeout < 0L) {
            concurrentTimeout = 0x3FFFFFFFFFFFFFFFL;
        }
        this._concurrentTimeout = concurrentTimeout;
        this._concurrentSemaphore = concurrentMax > 0 ? new Semaphore(concurrentMax) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item<X> allocate() {
        Semaphore semaphore = this._concurrentSemaphore;
        if (semaphore != null) {
            try {
                Thread.interrupted();
                if (!semaphore.tryAcquire(this._concurrentTimeout, TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException(L.l("{0} concurrent max exceeded", this));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        boolean isValid = false;
        try {
            Item<X> beanItem = this._freeList.allocate();
            if (beanItem == null) {
                OwnerCreationalContext env = new OwnerCreationalContext(this._manager.getBean());
                Object[] bindings = this._manager.getInterceptorBindings(this._interceptorBeans, env);
                Object instance = this._context.newInstance(env);
                if (instance instanceof SessionBean) {
                    try {
                        ((SessionBean)instance).setSessionContext(this._context);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
                beanItem = new Item(instance, bindings);
            }
            isValid = true;
            Item<X> item = beanItem;
            Object var9_9 = null;
            if (!isValid && semaphore != null) {
                semaphore.release();
            }
            return item;
        }
        catch (Throwable throwable) {
            block11: {
                Object var9_10 = null;
                if (isValid || semaphore == null) break block11;
                semaphore.release();
            }
            throw throwable;
        }
    }

    public void free(Item<X> beanItem) {
        Semaphore semaphore = this._concurrentSemaphore;
        if (semaphore != null) {
            semaphore.release();
        }
        if (!this._freeList.free(beanItem)) {
            this.destroyImpl(beanItem);
        }
    }

    public void destroy(Item<X> beanItem) {
        if (beanItem == null) {
            return;
        }
        Semaphore semaphore = this._concurrentSemaphore;
        if (semaphore != null) {
            semaphore.release();
        }
        this.destroyImpl(beanItem);
    }

    public void discard(Item<X> beanItem) {
        if (beanItem == null) {
            return;
        }
        Semaphore semaphore = this._concurrentSemaphore;
        if (semaphore != null) {
            semaphore.release();
        }
    }

    private void destroyImpl(Item<X> beanItem) {
        this._manager.destroyInstance(beanItem.getValue());
    }

    public void destroy() {
        Item<X> beanItem;
        while ((beanItem = this._freeList.allocate()) != null) {
            this.destroyImpl(beanItem);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._manager + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Item<X> {
        private X _value;
        private Object[] _interceptorObjects;

        Item(X value, Object[] interceptorObjects) {
            this._value = value;
            this._interceptorObjects = interceptorObjects;
        }

        public X getValue() {
            return this._value;
        }

        public Object[] _caucho_getInterceptorObjects() {
            return this._interceptorObjects;
        }
    }
}

