/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.timer;

import com.caucho.config.timer.CronExpression;
import com.caucho.config.timer.CronTrigger;
import com.caucho.config.timer.EjbTimer;
import com.caucho.config.timer.TimeoutInvoker;
import com.caucho.config.timer.TimerTask;
import com.caucho.config.types.Trigger;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.ejb.timer.EjbTimerInvocation;
import com.caucho.resources.TimerTrigger;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbTimerService
implements TimerService {
    private static final L10N L = new L10N(EjbTimerService.class);
    private static final Logger log = Logger.getLogger(EjbTimerService.class.getName());
    private final AbstractEjbBeanManager _server;
    private final TimeoutInvoker _timeout;
    private final LinkedList<TimerTask> _timers = new LinkedList();

    public EjbTimerService(AbstractEjbBeanManager server) {
        this._server = server;
        this._timeout = new EjbTimerInvocation(server);
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("Timer duration must not be negative.");
        }
        long expiration = Alarm.getCurrentTime() + duration;
        return this.createOneTimeTimer(expiration, info);
    }

    public Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException(L.l("Timer duration must not be negative."));
        }
        long expiration = Alarm.getCurrentTime() + duration;
        Serializable info = null;
        if (timerConfig != null) {
            info = timerConfig.getInfo();
        }
        return this.createOneTimeTimer(expiration, info);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException(L.l("Timer initial duration must not be negative."));
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException(L.l("Timer interval duration must not be negative."));
        }
        Date expiration = new Date(Alarm.getCurrentTime() + initialDuration);
        return this.createRepeatingTimer(expiration, intervalDuration, info);
    }

    public Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException(L.l("Timer initial duration must not be negative."));
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException(L.l("Timer interval duration must not be negative."));
        }
        Date expiration = new Date(Alarm.getCurrentTime() + initialDuration);
        Serializable info = null;
        if (timerConfig != null) {
            info = timerConfig.getInfo();
        }
        return this.createRepeatingTimer(expiration, intervalDuration, info);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException(L.l("Timer expiration must not be null."));
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException(L.l("Timer expiration must not be negative."));
        }
        return this.createOneTimeTimer(expiration.getTime(), info);
    }

    public Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException(L.l("Timer expiration must not be null."));
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException(L.l("Timer expiration must not be negative."));
        }
        Serializable info = null;
        if (timerConfig != null) {
            info = timerConfig.getInfo();
        }
        return this.createOneTimeTimer(expiration.getTime(), info);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException(L.l("Timer initial expiration must not be null."));
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException(L.l("Timer initial expiration must not be negative."));
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException(L.l("Timer interval duration must not be negative."));
        }
        return this.createRepeatingTimer(initialExpiration, intervalDuration, info);
    }

    public Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException(L.l("Timer initial expiration must not be null."));
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException(L.l("Timer initial expiration must not be negative."));
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException(L.l("Timer interval duration must not be negative."));
        }
        Serializable info = null;
        if (timerConfig != null) {
            info = timerConfig.getInfo();
        }
        return this.createRepeatingTimer(initialExpiration, intervalDuration, info);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createScheduledTimer(schedule, info);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        Serializable info = null;
        if (timerConfig != null) {
            info = timerConfig.getInfo();
        }
        return this.createScheduledTimer(schedule, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
        LinkedList<Timer> timers = new LinkedList<Timer>();
        LinkedList<TimerTask> linkedList = this._timers;
        synchronized (linkedList) {
            for (TimerTask task : this._timers) {
                timers.add(new EjbTimer(task));
            }
        }
        return timers;
    }

    private Timer createOneTimeTimer(long expiration, Serializable info) {
        TimerTrigger trigger = new TimerTrigger(expiration);
        return this.createTimer(trigger, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer createTimer(Trigger trigger, Serializable info) {
        EjbTimer timer = new EjbTimer();
        TimerTask scheduledTask = new TimerTask(this._timeout, timer, null, trigger, info);
        timer.setScheduledTask(scheduledTask);
        LinkedList<TimerTask> linkedList = this._timers;
        synchronized (linkedList) {
            this._timers.add(scheduledTask);
        }
        scheduledTask.start();
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer createRepeatingTimer(Date expiration, long interval, Serializable info) {
        TimerTrigger trigger = new TimerTrigger(expiration.getTime(), interval);
        EjbTimer timer = new EjbTimer();
        TimerTask scheduledTask = new TimerTask(this._timeout, timer, null, trigger, info);
        timer.setScheduledTask(scheduledTask);
        LinkedList<TimerTask> linkedList = this._timers;
        synchronized (linkedList) {
            this._timers.add(scheduledTask);
        }
        scheduledTask.start();
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer createScheduledTimer(ScheduleExpression schedule, Serializable info) {
        CronExpression cronExpression = new CronExpression(schedule.getSecond(), schedule.getMinute(), schedule.getHour(), schedule.getDayOfWeek(), schedule.getDayOfMonth(), schedule.getMonth(), schedule.getYear());
        TimeZone timezone = null;
        if (!schedule.getTimezone().trim().equals("")) {
            timezone = TimeZone.getTimeZone(schedule.getTimezone());
        }
        long start = -1L;
        long end = -1L;
        if (schedule.getStart() != null) {
            start = schedule.getStart().getTime();
        }
        if (schedule.getEnd() != null) {
            end = schedule.getEnd().getTime();
        }
        CronTrigger trigger = new CronTrigger(cronExpression, start, end, timezone);
        EjbTimer timer = new EjbTimer();
        TimerTask scheduledTask = new TimerTask(this._timeout, timer, cronExpression, trigger, info);
        timer.setScheduledTask(scheduledTask);
        LinkedList<TimerTask> linkedList = this._timers;
        synchronized (linkedList) {
            this._timers.add(scheduledTask);
        }
        scheduledTask.start();
        return timer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._server + "]";
    }
}

