/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.el.Marshall;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.el.ELContext;
import javax.el.ELException;

public class MethodExpr
extends Expr {
    private Expr _expr;
    private String _methodName;
    private Expr[] _args;

    public MethodExpr(Expr expr, String methodName, Expr[] args) {
        this._expr = expr;
        this._methodName = methodName;
        this._args = args;
    }

    public Object getValue(ELContext env) throws ELException {
        Object aObj = this._expr.getValue(env);
        if (aObj == null) {
            return null;
        }
        Object[] objs = new Object[this._args.length];
        try {
            Method method = this.findMethod(aObj.getClass());
            if (method != null) {
                Class<?>[] params = method.getParameterTypes();
                for (int j = 0; j < params.length; ++j) {
                    objs[j] = MethodExpr.evalArg(params[j], this._args[j], env);
                }
                try {
                    method.setAccessible(true);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                return method.invoke(aObj, objs);
            }
            return null;
        }
        catch (Exception e) {
            return MethodExpr.invocationError(e);
        }
    }

    private Method findMethod(Class type) {
        Method method;
        int i;
        if (type == null) {
            return null;
        }
        if (Modifier.isPublic(type.getModifiers())) {
            Method[] methods = type.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                method = methods[i];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                Class<?>[] params = method.getParameterTypes();
                if (!method.getName().equals(this._methodName) || params.length != this._args.length) continue;
                return method;
            }
        }
        Class<?>[] interfaces = type.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            method = this.findMethod(interfaces[i]);
            if (method == null) continue;
            return method;
        }
        return this.findMethod(type.getSuperclass());
    }

    static Object evalArg(Class cl, Expr expr, ELContext env) throws ELException {
        Marshall marshall = Marshall.create(cl);
        return marshall.marshall(expr, env);
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.MethodExpr(");
        this._expr.printCreate(os);
        os.print(", \"");
        os.print(this._methodName);
        os.print("\", new com.caucho.el.Expr[] {");
        for (int i = 0; i < this._args.length; ++i) {
            if (i != 0) {
                os.print(", ");
            }
            this._args[i].printCreate(os);
        }
        os.println("})");
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodExpr)) {
            return false;
        }
        MethodExpr expr = (MethodExpr)((Object)o);
        if (!this._expr.equals((Object)expr._expr)) {
            return false;
        }
        if (!this._methodName.equals(expr._methodName)) {
            return false;
        }
        if (this._args.length != expr._args.length) {
            return false;
        }
        for (int i = 0; i < this._args.length; ++i) {
            if (this._args[i].equals((Object)expr._args[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MethodExpr[" + (Object)((Object)this._expr) + "," + this._methodName + "]";
    }
}

