/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyValueProgram;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.PathBuilder;
import com.caucho.config.types.Period;
import com.caucho.config.types.RawString;
import com.caucho.env.deploy.DeployMode;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployConfig {
    private static final Logger log = Logger.getLogger(DeployConfig.class.getName());
    private String _id;
    private String _rootDirectory;
    private String _archivePath;
    private FileSetType _expandCleanupFileset;
    private int _startupPriority;
    private DeployMode _startupMode;
    private DeployMode _redeployMode;
    private Period _redeployCheckInterval;
    private boolean _isSkipDefaultConfig;
    private ContainerProgram _program = new ContainerProgram();

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setRootDirectory(RawString rootDirectory) {
        this._rootDirectory = rootDirectory.getValue();
    }

    public String getRootDirectory() {
        return this._rootDirectory;
    }

    public void setArchivePath(RawString path) {
        this._archivePath = path.getValue();
    }

    public String getArchivePath() {
        return this._archivePath;
    }

    public boolean isSkipDefaultConfig() {
        return this._isSkipDefaultConfig;
    }

    public void setExpandCleanupFileset(FileSetType fileset) {
        this._expandCleanupFileset = fileset;
    }

    public FileSetType getExpandCleanupFileset() {
        return this._expandCleanupFileset;
    }

    public void setSkipDefaultConfig(boolean isDefault) {
        this._isSkipDefaultConfig = isDefault;
    }

    public void setStartupMode(DeployMode mode) throws ConfigException {
        this._startupMode = mode;
    }

    public DeployMode getStartupMode() {
        return this._startupMode;
    }

    public void setStartupPriority(int priority) throws ConfigException {
        this._startupPriority = priority;
    }

    public int getStartupPriority() {
        return this._startupPriority;
    }

    public void setRedeployCheckInterval(Period period) {
        this._redeployCheckInterval = period;
    }

    public Period getRedeployCheckInterval() {
        return this._redeployCheckInterval;
    }

    public void setRedeployMode(DeployMode mode) throws ConfigException {
        this._redeployMode = mode;
    }

    public DeployMode getRedeployMode() {
        return this._redeployMode;
    }

    public DeployConfig getPrologue() {
        return null;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    public ConfigProgram getBuilderProgram() {
        return this._program;
    }

    public void addPropertyProgram(String name, Object value) {
        this._program.addProgram(new PropertyValueProgram(name, value));
    }

    public Path calculateRootDirectory() {
        return this.calculateRootDirectory(null);
    }

    public Path calculateRootDirectory(Map<String, Object> varMap) {
        try {
            String rawPath = this.getRootDirectory();
            Path rootDir = null;
            if (rawPath != null) {
                rootDir = PathBuilder.lookupPath(rawPath, varMap);
            }
            if (rootDir != null) {
                return rootDir;
            }
            return Vfs.lookup();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }
}

