/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.env.deploy.DeployContainerApi;
import com.caucho.env.deploy.DeployControllerApi;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.env.deploy.DeployListGenerator;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.make.CachedDependency;
import com.caucho.server.host.HostController;
import com.caucho.util.ConcurrentArrayList;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployContainer<C extends DeployControllerApi<?>>
extends CachedDependency
implements DeployContainerApi<C>,
Dependency {
    private final DeployListGenerator<C> _deployListGenerator = new DeployListGenerator(this);
    private final ConcurrentArrayList<C> _controllerList;
    private final Lifecycle _lifecycle = new Lifecycle();

    public DeployContainer(Class<C> type) {
        this._controllerList = new ConcurrentArrayList<C>(type);
        this.setCheckInterval(Environment.getDependencyCheckInterval());
    }

    @Override
    public void add(DeployGenerator<C> generator) {
        TreeSet<String> names = new TreeSet<String>();
        generator.fillDeployedNames(names);
        this._deployListGenerator.add(generator);
        if (this._lifecycle.isActive()) {
            this.update(names);
        }
    }

    @Override
    public void remove(DeployGenerator<C> generator) {
        TreeSet<String> names = new TreeSet<String>();
        generator.fillDeployedNames(names);
        this._deployListGenerator.remove(generator);
        if (this._lifecycle.isActive()) {
            this.update(names);
        }
    }

    @Override
    public boolean isModifiedImpl() {
        return this._deployListGenerator.isModified();
    }

    @Override
    public boolean logModified(Logger log) {
        return this._deployListGenerator.logModified(log);
    }

    @Override
    public void update() {
        this._deployListGenerator.update();
    }

    @PostConstruct
    public void init() {
        if (!this._lifecycle.toInit()) {
            return;
        }
    }

    @Override
    public void start() {
        this.init();
        if (!this._lifecycle.toActive()) {
            return;
        }
        this._deployListGenerator.start();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        this._deployListGenerator.fillDeployedNames(keys);
        for (String key : keys) {
            this.updateImpl(key);
        }
        ArrayList<C> controllerList = new ArrayList<C>(this._controllerList);
        Collections.sort(controllerList, new StartupPriorityComparator());
        for (int i = 0; i < controllerList.size(); ++i) {
            DeployControllerApi controller = (DeployControllerApi)controllerList.get(i);
            controller.startOnInit();
        }
    }

    @Override
    public C findController(String name) {
        C controller = this.findDeployedController(name);
        if (controller != null) {
            return controller;
        }
        controller = this.generateController(name);
        if (controller == null) {
            return null;
        }
        if (controller.isNameMatch(name)) {
            return controller;
        }
        return null;
    }

    @Override
    public C[] getControllers() {
        return (DeployControllerApi[])this._controllerList.toArray();
    }

    private void update(Set<String> names) {
        for (String name : names) {
            this.update(name);
        }
    }

    @Override
    public C update(String name) {
        C newController = this.updateImpl(name);
        if (this._lifecycle.isActive() && newController != null) {
            newController.startOnInit();
        }
        return newController;
    }

    public C updateNoStart(String name) {
        C newController = this.updateImpl(name);
        return newController;
    }

    C updateImpl(String name) {
        this.remove(name);
        C newController = this.generateController(name);
        return newController;
    }

    @Override
    public void remove(String name) {
        DeployControllerApi oldController = (DeployControllerApi)this._controllerList.remove(name, this.getControllerNameMatch());
        if (oldController != null) {
            oldController.close();
        }
    }

    private C generateController(String name) {
        ArrayList controllerList = new ArrayList();
        this._deployListGenerator.generateController(name, controllerList);
        DeployControllerApi bestController = null;
        for (DeployControllerApi controller : controllerList) {
            if (bestController == null) {
                bestController = controller;
                continue;
            }
            if (controller.getControllerType().ordinal() >= bestController.getControllerType().ordinal()) continue;
            bestController = controller;
        }
        if (bestController == null) {
            return null;
        }
        for (DeployControllerApi controller : controllerList) {
            bestController.merge(controller);
        }
        bestController = this._deployListGenerator.mergeController(bestController, name);
        return (C)this.addController(bestController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C addController(C newController) {
        if (newController == null) {
            return null;
        }
        DeployControllerApi oldController = null;
        Object object = this._controllerList;
        synchronized (object) {
            oldController = (DeployControllerApi)this.findDeployedControllerById(newController.getId());
            if (oldController == null) {
                this._controllerList.add(newController);
            }
        }
        if (oldController != null) {
            oldController.update();
            return (C)oldController;
        }
        this.init(newController);
        if (newController instanceof HostController) {
            object = (HostController)newController;
        }
        return newController;
    }

    private void init(C controller) {
        controller.init();
    }

    private C findDeployedController(String name) {
        return (C)((DeployControllerApi)this._controllerList.find(name, this.getControllerNameMatch()));
    }

    private C findDeployedControllerById(String id) {
        return (C)((DeployControllerApi)this._controllerList.find(id, this.getControllerIdMatch()));
    }

    @Override
    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        ArrayList<C> controllers = new ArrayList<C>(this._controllerList);
        Collections.sort(controllers, new StartupPriorityComparator());
        for (int i = controllers.size() - 1; i >= 0; --i) {
            ((DeployControllerApi)controllers.get(i)).stop();
        }
    }

    @Override
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._deployListGenerator.destroy();
        ArrayList<C> controllerList = new ArrayList<C>(this._controllerList);
        this._controllerList.clear();
        Collections.sort(controllerList, new StartupPriorityComparator());
        for (int i = controllerList.size() - 1; i >= 0; --i) {
            DeployControllerApi controller = (DeployControllerApi)controllerList.get(i);
            controller.close();
        }
    }

    private ConcurrentArrayList.Match<C, String> getControllerNameMatch() {
        return ControllerNameMatch.MATCH;
    }

    private ConcurrentArrayList.Match<C, String> getControllerIdMatch() {
        return ControllerIdMatch.MATCH;
    }

    public String toString() {
        return "DeployContainer$" + System.identityHashCode(this) + "[]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ControllerIdMatch<C extends DeployControllerApi<?>>
    implements ConcurrentArrayList.Match<C, String> {
        static final ControllerIdMatch<DeployControllerApi<?>> MATCH = new ControllerIdMatch();

        ControllerIdMatch() {
        }

        @Override
        public boolean isMatch(C controller, String id) {
            return controller.getId().equals(id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ControllerNameMatch<C extends DeployControllerApi<?>>
    implements ConcurrentArrayList.Match<C, String> {
        static final ControllerNameMatch<DeployControllerApi<?>> MATCH = new ControllerNameMatch();

        ControllerNameMatch() {
        }

        @Override
        public boolean isMatch(C controller, String name) {
            return controller.isNameMatch(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StartupPriorityComparator
    implements Comparator<C> {
        @Override
        public int compare(C a, C b) {
            if (a.getStartupPriority() == b.getStartupPriority()) {
                return 0;
            }
            if (a.getStartupPriority() < b.getStartupPriority()) {
                return -1;
            }
            return 1;
        }
    }
}

