/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.config.ConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.Period;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployController;
import com.caucho.env.deploy.DeployControllerService;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.env.deploy.DeployMode;
import com.caucho.env.deploy.DeployUpdateListener;
import com.caucho.env.deploy.ExpandArchiveManager;
import com.caucho.env.deploy.ExpandDeployController;
import com.caucho.env.deploy.ExpandDirectoryManager;
import com.caucho.env.deploy.ExpandManager;
import com.caucho.env.deploy.ExpandRepositoryManager;
import com.caucho.env.deploy.ExpandVersion;
import com.caucho.env.repository.Repository;
import com.caucho.env.repository.RepositoryService;
import com.caucho.env.repository.RepositoryTagListener;
import com.caucho.loader.Environment;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpandDeployGenerator<E extends ExpandDeployController<?>>
extends DeployGenerator<E>
implements AlarmListener,
DeployUpdateListener,
RepositoryTagListener {
    private static final Logger log = Logger.getLogger(ExpandDeployGenerator.class.getName());
    private static final L10N L = new L10N(ExpandDeployGenerator.class);
    private static final long MIN_CRON_INTERVAL = 5000L;
    private final String _id;
    private Path _path;
    private ClassLoader _loader;
    private Path _containerRootDirectory;
    private Path _archiveDirectory;
    private Path _expandDirectory;
    private final Repository _repository;
    private final DeployControllerService _deployService;
    private String _entryNamePrefix = "";
    private String _extension = ".jar";
    private String _expandPrefix = "";
    private String _expandSuffix = "";
    private boolean _isVersioning;
    private ArrayList<String> _requireFiles = new ArrayList();
    private FileSetType _expandCleanupFileSet;
    private ExpandDirectoryManager _directoryManager;
    private ExpandArchiveManager _archiveManager;
    private ExpandRepositoryManager _repositoryManager;
    private Alarm _alarm;
    private long _cronInterval;
    private ExpandManager _expandManager;
    private Set<String> _deployedKeys = new TreeSet<String>();
    private Set<String> _versionKeys = new TreeSet<String>();
    private long _lastCheckTime;
    private AtomicBoolean _isChecking = new AtomicBoolean();
    private long _checkInterval = 1000L;
    private long _digest;
    private volatile boolean _isModified;
    private AtomicBoolean _isDeploying = new AtomicBoolean();

    public ExpandDeployGenerator(String id, DeployContainer<E> container, Path containerRootDirectory) {
        super(container);
        this._id = id;
        this._containerRootDirectory = containerRootDirectory;
        this._alarm = new WeakAlarm(this);
        this._cronInterval = Environment.getDependencyCheckInterval();
        if (this._cronInterval < 5000L) {
            this._cronInterval = 5000L;
        }
        this._loader = Thread.currentThread().getContextClassLoader();
        this._deployService = DeployControllerService.create();
        this._deployService.addUpdateListener(this);
        this._repository = RepositoryService.getCurrentRepository();
        this._repository.addListener(id, this);
    }

    public String getId() {
        return this._id;
    }

    Path getContainerRootDirectory() {
        return this._containerRootDirectory;
    }

    public void setArchiveDirectory(Path path) {
        this._archiveDirectory = path;
    }

    public Path getArchiveDirectory() {
        if (this._archiveDirectory != null) {
            return this._archiveDirectory;
        }
        return this._path;
    }

    public Path getArchivePath(String name) {
        return this.getArchiveDirectory().lookup(name + this.getExtension());
    }

    public void setExpandPath(Path path) {
        log.config("Use <expand-directory> instead of <expand-path>.  <expand-path> is deprecated.");
        this.setExpandDirectory(path);
    }

    public void setExpandDirectory(Path path) {
        this._expandDirectory = path;
    }

    public Path getExpandDirectory() {
        if (this._expandDirectory != null) {
            return this._expandDirectory;
        }
        return this._path;
    }

    public void setDependencyCheckInterval(Period period) {
        this._cronInterval = period.getPeriod();
        if (this._cronInterval < 0L) {
            this._cronInterval = 4611686018427387000L;
        } else if (this._cronInterval < 5000L) {
            this._cronInterval = 5000L;
        }
    }

    public long getDependencyCheckInterval() {
        return this._cronInterval;
    }

    public void setExpandCleanupFileset(FileSetType fileSet) {
        this._expandCleanupFileSet = fileSet;
    }

    public void setExtension(String extension) throws ConfigException {
        if (!extension.startsWith(".")) {
            throw new ConfigException(L.l("deployment extension '{0}' must begin with '.'", extension));
        }
        this._extension = extension;
    }

    public String getExtension() {
        return this._extension;
    }

    public void setExpandPrefix(String prefix) throws ConfigException {
        if (!(prefix.equals("") || prefix.startsWith("_") || prefix.startsWith("."))) {
            throw new ConfigException(L.l("expand-prefix '{0}' must start with '.' or '_'.", prefix));
        }
        this._expandPrefix = prefix;
    }

    public String getExpandPrefix() {
        return this._expandPrefix;
    }

    public void setExpandSuffix(String suffix) throws ConfigException {
        this._expandSuffix = suffix;
    }

    public String getExpandSuffix() {
        return this._expandSuffix;
    }

    public Repository getRepository() {
        return this._repository;
    }

    public void setEntryNamePrefix(String entryNamePrefix) {
        this._entryNamePrefix = entryNamePrefix;
    }

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public void addRequireFile(String file) throws ConfigException {
        this._requireFiles.add(file);
    }

    public void setVersioning(boolean isVersioning) {
        this._isVersioning = isVersioning;
    }

    public boolean isVersioning() {
        return this._isVersioning;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    protected void initImpl() throws ConfigException {
        super.initImpl();
        if (this.getExpandDirectory() == null) {
            throw new ConfigException(L.l("<expand-directory> must be specified for deployment of archive expansion."));
        }
        if (this.getArchiveDirectory() == null) {
            throw new ConfigException(L.l("<archive-directory> must be specified for deployment of archive expansion."));
        }
        String id = this.getId();
        this._directoryManager = new ExpandDirectoryManager(id, this.getExpandDirectory(), this.getExpandPrefix(), this.getExpandSuffix(), this._requireFiles);
        this._archiveManager = new ExpandArchiveManager(id, this.getArchiveDirectory(), this.getExtension());
        this._repositoryManager = new ExpandRepositoryManager(id);
    }

    @Override
    protected void startImpl() {
        super.startImpl();
        this.deploy();
        this.handleAlarm(this._alarm);
    }

    public Path getExpandPath(String key) {
        if (!this.isDeployedKey(key)) {
            return null;
        }
        return this._directoryManager.getExpandPath(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModified() {
        block8: {
            if (!this._isChecking.compareAndSet(false, true)) {
                return this._isModified;
            }
            long now = Alarm.getCurrentTime();
            if (now >= this._lastCheckTime + this._checkInterval) break block8;
            boolean bl = this._isModified;
            Object var5_5 = null;
            this._isChecking.set(false);
            return bl;
        }
        try {
            this._lastCheckTime = Alarm.getCurrentTime();
            if (this._expandManager != null) {
                this._isModified = this._expandManager.isModified();
                this._digest = this._expandManager.getDigest();
            } else {
                this._isModified = true;
            }
            boolean bl = this._isModified;
            Object var5_6 = null;
            this._isChecking.set(false);
            return bl;
        }
        catch (Exception e) {
            try {
                log.log(Level.FINE, e.toString(), e);
                boolean bl = false;
                Object var5_7 = null;
                this._isChecking.set(false);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this._isChecking.set(false);
                throw throwable;
            }
        }
    }

    @Override
    public boolean logModified(Logger log) {
        return this._expandManager.logModified(log);
    }

    @Override
    protected void fillDeployedNames(Set<String> names) {
        this.updateIfModified();
        for (String key : this._deployedKeys) {
            String name = this.keyToName(key);
            if (name == null) continue;
            names.add(name);
        }
    }

    protected boolean isDeployedKey(String key) {
        if (key == null) {
            return false;
        }
        if (this._deployedKeys.contains(key)) {
            return true;
        }
        return this._expandManager.getKeySet().contains(key);
    }

    protected abstract E createController(ExpandVersion var1);

    protected String keyToName(String key) {
        return key;
    }

    protected String nameToKey(String name) {
        return name;
    }

    @Override
    public void updateIfModified() {
        if (this.isModified()) {
            this.update();
        }
    }

    public void updateIfModifiedNow() {
        this._lastCheckTime = 0L;
        if (this.isModified()) {
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void update() {
        if (!this._isDeploying.compareAndSet(false, true)) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            Set<String> oldKeys = this._deployedKeys;
            Set<String> oldVersion = this._versionKeys;
            this.deploy();
            Set<String> newKeys = this._deployedKeys;
            Set<String> newVersion = this._versionKeys;
            if (!((Object)oldKeys).equals(newKeys)) {
                ArrayList<String> updatedKeys = new ArrayList<String>();
                for (String key : oldKeys) {
                    if (newKeys.contains(key)) continue;
                    updatedKeys.add(key);
                }
                for (String key : newKeys) {
                    if (oldKeys.contains(key)) continue;
                    updatedKeys.add(key);
                }
                for (String key : updatedKeys) {
                    this.getDeployContainer().update(this.keyToName(key));
                }
            }
            if (!((Object)oldVersion).equals(newVersion)) {
                this.afterUpdate();
            }
            Object var11_10 = null;
            thread.setContextClassLoader(oldLoader);
            this._isDeploying.set(false);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            thread.setContextClassLoader(oldLoader);
            this._isDeploying.set(false);
            throw throwable;
        }
    }

    protected void afterUpdate() {
    }

    private void deploy() {
        try {
            this._expandManager = new ExpandManager(this.getId(), this._directoryManager, this._archiveManager, this._repositoryManager, this._isVersioning);
            this._deployedKeys = this._expandManager.getBaseKeySet();
            this._versionKeys = this._expandManager.getKeySet();
            this._isModified = false;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public ExpandVersion getPrimaryVersion(String key) {
        return this._expandManager.getPrimaryVersion(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void generateController(String name, ArrayList<E> controllerList) {
        this.updateIfModifiedNow();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            String key = this.nameToKey(name);
            ExpandVersion version = this._expandManager.getPrimaryVersion(key);
            if (version == null) {
                version = this._expandManager.getVersion(key);
            }
            if (version == null) {
                Object var9_7 = null;
                thread.setContextClassLoader(oldLoader);
                return;
            }
            E controller = this.createController(version);
            if (controller != null) {
                ((ExpandDeployController)controller).setExpandCleanupFileSet(this._expandCleanupFileSet);
                controllerList.add(controller);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        Object var9_8 = null;
        thread.setContextClassLoader(oldLoader);
    }

    @Override
    public void onUpdate(String tag) {
        this.update();
    }

    public String[] getNames() {
        Set<String> deployedKeys = this._deployedKeys;
        String[] names = new String[deployedKeys.size()];
        int i = 0;
        for (String key : deployedKeys) {
            names[i++] = key;
        }
        return names;
    }

    private String getNamesAsString() {
        StringBuilder builder = new StringBuilder();
        for (String name : this._deployedKeys) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(name);
        }
        builder.insert(0, '[');
        builder.append(']');
        return builder.toString();
    }

    public boolean deploy(String key) {
        this.update();
        DeployController controller = (DeployController)this.getDeployContainer().findController(this.keyToName(key));
        if (controller == null) {
            if (log.isLoggable(Level.FINE)) {
                log.finer(L.l("{0} can't deploy '{1}' because it's not a known controller: {2}", this, key, this.getNamesAsString()));
            }
            return false;
        }
        return true;
    }

    public boolean start(String name) {
        DeployController controller = (DeployController)this.getDeployContainer().findController(this.keyToName(name));
        if (controller == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("{0} unknown name '{1}' in start", (Object)this, name));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("{0} known names are {1} in start", (Object)this, this.getNamesAsString()));
            }
            return false;
        }
        controller.start();
        return true;
    }

    public Throwable getConfigException(String name) {
        ExpandDeployController controller = (ExpandDeployController)this.getDeployContainer().findController(this.keyToName(name));
        if (controller == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("unknown name '{0}'", name));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("known names are {0}", this.getNamesAsString()));
            }
            return new ConfigException(L.l("unknown name '{0}'", name));
        }
        return controller.getConfigException();
    }

    public boolean stop(String name) {
        DeployController controller = (DeployController)this.getDeployContainer().findController(this.keyToName(name));
        if (controller == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("unknown name '{0}'", name));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("known names are {0}", this.getNamesAsString()));
            }
            return false;
        }
        controller.stop();
        return true;
    }

    public boolean undeploy(String name) {
        block11: {
            Path expandPath;
            block10: {
                DeployController controller = (DeployController)this.getDeployContainer().findController(this.keyToName(name));
                if (controller == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, L.l("unknown name '{0}'", name));
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, L.l("known names are {0}", this.getNamesAsString()));
                    }
                    return false;
                }
                Path archivePath = this.getArchivePath(name);
                expandPath = this.getExpandPath(name);
                controller.stop();
                try {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, L.l("deleting {0}", archivePath));
                    }
                    archivePath.removeAll();
                }
                catch (IOException ex) {
                    if (!log.isLoggable(Level.FINE)) break block10;
                    log.log(Level.FINE, ex.toString(), ex);
                }
            }
            try {
                if (expandPath != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, L.l("deleting {0}", expandPath));
                    }
                    expandPath.removeAll();
                }
            }
            catch (IOException ex) {
                if (!log.isLoggable(Level.FINE)) break block11;
                log.log(Level.FINE, ex.toString(), ex);
            }
        }
        this.getDeployContainer().update(this.keyToName(name));
        return true;
    }

    @Override
    public void onTagChange(String tag) {
        this._lastCheckTime = 0L;
        this.alarm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        if (this.isDestroyed()) {
            return;
        }
        try {
            try {
                this.alarm();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                Object var4_3 = null;
                this._alarm.queue(this._cronInterval);
            }
            Object var4_2 = null;
            this._alarm.queue(this._cronInterval);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._alarm.queue(this._cronInterval);
            throw throwable;
        }
    }

    private void alarm() {
        if (DeployMode.AUTOMATIC.equals((Object)this.getRedeployMode()) && this.isActive()) {
            this.updateIfModified();
        }
    }

    @Override
    protected void stopImpl() {
        this._alarm.dequeue();
        if (this._deployService != null) {
            this._deployService.removeUpdateListener(this);
        }
        super.stopImpl();
    }

    public boolean equals(Object o) {
        Path deployExpandDirectory;
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ExpandDeployGenerator deploy = (ExpandDeployGenerator)o;
        Path expandDirectory = this.getExpandDirectory();
        return expandDirectory == (deployExpandDirectory = deploy.getExpandDirectory()) || expandDirectory != null && expandDirectory.equals(deployExpandDirectory);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getExpandDirectory() + "]";
    }

    class VersionDependency
    implements Dependency {
        private Set<String> _oldVersionKeys;

        VersionDependency() {
            ExpandDeployGenerator.this._versionKeys = this._oldVersionKeys;
        }

        public boolean isModified() {
            return !((Object)ExpandDeployGenerator.this._versionKeys).equals(this._oldVersionKeys);
        }

        public boolean logModified(Logger log) {
            if (!((Object)ExpandDeployGenerator.this._versionKeys).equals(this._oldVersionKeys)) {
                log.info(ExpandDeployGenerator.this + " version is modified");
                return true;
            }
            return false;
        }
    }
}

