/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.git;

import com.caucho.env.git.GitCommitTree;
import com.caucho.env.git.GitWorkingTree;
import com.caucho.java.WorkDir;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitCommitJar {
    private static final Logger log = Logger.getLogger(GitCommitJar.class.getName());
    private GitCommitTree _commit = new GitCommitTree();
    private Path _jar;
    private Path _tempJar;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitCommitJar(Path jar) throws IOException {
        if (jar.getScheme().equals("memory")) {
            ReadStream is = jar.openRead();
            try {
                this.init(is);
            }
            finally {
                ((InputStream)is).close();
            }
        } else {
            this.init(jar);
        }
    }

    public GitCommitJar(InputStream is) throws IOException {
        this.init(is);
    }

    private void init(InputStream is) throws IOException {
        Path dir = WorkDir.getLocalWorkDir();
        dir.mkdirs();
        Path path = dir.createTempFile("git", "tmp");
        try {
            WriteStream os = path.openWrite();
            os.writeStream(is);
            os.close();
            this.init(path);
            this._tempJar = path;
        }
        catch (IOException e) {
            path.remove();
        }
    }

    private void init(Path jar) throws IOException {
        this._jar = jar;
        HashMap<String, Long> lengthMap = new HashMap<String, Long>();
        this.fillLengthMap(lengthMap, jar);
        ReadStream is = jar.openRead();
        this.fillCommit(lengthMap, is);
        this._commit.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCommit(HashMap<String, Long> lengthMap, InputStream is) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(is);
            while ((entry = zin.getNextEntry()) != null) {
                String path = entry.getName();
                long length = entry.getSize();
                if (entry.isDirectory()) continue;
                Long lengthValue = lengthMap.get(path);
                if (lengthValue != null) {
                    length = lengthValue;
                }
                this._commit.addFile(path, 436, zin, length);
            }
        }
        finally {
            is.close();
        }
    }

    public String[] getCommitList() {
        return this._commit.getCommitList();
    }

    public String getDigest() {
        return this._commit.getDigest();
    }

    public String findPath(String sha1) {
        return this._commit.findPath(sha1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillLengthMap(HashMap<String, Long> lengthMap, Path jar) throws IOException {
        ReadStream is = jar.openRead();
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(is);
            while ((entry = zin.getNextEntry()) != null) {
                String path = entry.getName();
                long length = entry.getSize();
                if (entry.isDirectory()) continue;
                if (length < 0L) {
                    length = 0L;
                    while (zin.read() >= 0) {
                        ++length;
                    }
                }
                lengthMap.put(path, length);
            }
        }
        finally {
            is.close();
        }
    }

    public long getLength(String sha1) throws IOException {
        InputStream is = this.openFile(sha1);
        long length = 0L;
        while (is.read() >= 0) {
            ++length;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openFile(String sha1) throws IOException {
        String path = this._commit.findPath(sha1);
        if (path.endsWith("/")) {
            GitWorkingTree tree = this._commit.findTree(path);
            return tree.openFile();
        }
        ZipFile file = new ZipFile(this._jar.getNativePath());
        try {
            InputStream inputStream;
            ZipEntry entry = file.getEntry(path);
            InputStream is = file.getInputStream(entry);
            try {
                inputStream = GitCommitTree.writeBlob(is, entry.getSize());
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return inputStream;
        }
        finally {
            file.close();
        }
    }

    public void close() {
        if (this._tempJar != null) {
            try {
                this._tempJar.remove();
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

