/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.git;

import com.caucho.env.git.GitCommitTree;
import com.caucho.env.git.GitInputStream;
import com.caucho.util.Hex;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitWorkingTree {
    private Map<String, Entry> _treeMap = new TreeMap<String, Entry>();
    private String _digest;

    public Map<String, Entry> getMap() {
        return this._treeMap;
    }

    public String getDigest() {
        return this._digest;
    }

    public void addBlobPath(String path, int mode, String sha1) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ("".equals(path)) {
            return;
        }
        int p = path.indexOf(47);
        if (p > 0) {
            String head = path.substring(0, p);
            String tail = path.substring(p + 1);
            GitWorkingTree tree = this.getTree(head);
            tree.addBlobPath(tail, mode, sha1);
        } else {
            this.addBlob(path, mode, sha1);
        }
    }

    public GitWorkingTree findTreeRec(String path) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ("".equals(path)) {
            return this;
        }
        int p = path.indexOf(47);
        if (p > 0) {
            String head = path.substring(0, p);
            String tail = path.substring(p + 1);
            GitWorkingTree tree = this.getTree(head);
            return tree.findTreeRec(tail);
        }
        return this.getTree(path);
    }

    public InputStream openFile() throws IOException {
        int len;
        TempOutputStream out = new TempOutputStream();
        this.writeTree(out);
        GitInputStream is = new GitInputStream("tree", out.getLength(), out.openRead());
        out = new TempOutputStream();
        DeflaterOutputStream zipOut = new DeflaterOutputStream(out);
        TempBuffer tBuf = TempBuffer.allocate();
        byte[] buffer = tBuf.getBuffer();
        while ((len = is.read(buffer, 0, buffer.length)) > 0) {
            zipOut.write(buffer, 0, len);
        }
        zipOut.close();
        return out.openRead();
    }

    String commit(GitCommitTree commit, String path) {
        for (Entry entry : this._treeMap.values()) {
            GitWorkingTree subTree = entry.getSubTree();
            if (subTree == null) continue;
            String subPath = !"".equals(path) ? path + "/" + entry.getName() : entry.getName();
            entry.setSha1(subTree.commit(commit, subPath));
        }
        this._digest = this.calculateHash();
        commit.addCommitDir(this._digest, path);
        return this._digest;
    }

    private String calculateHash() {
        try {
            int len;
            TempOutputStream out = new TempOutputStream();
            this.writeTree(out);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            this.updateString(md, "tree " + out.getLength());
            md.update((byte)0);
            TempBuffer tBuf = TempBuffer.allocate();
            byte[] buffer = tBuf.getBuffer();
            ReadStream is = out.openRead();
            while ((len = ((InputStream)is).read(buffer, 0, buffer.length)) > 0) {
                md.update(buffer, 0, len);
            }
            ((InputStream)is).close();
            TempBuffer.free(tBuf);
            return Hex.toHex(md.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTree(OutputStream out) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(this._treeMap.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            int i;
            Entry entry = this._treeMap.get(key);
            String mode = String.format("%o", entry.getMode());
            int len = mode.length();
            for (i = 0; i < len; ++i) {
                out.write(mode.charAt(i));
            }
            out.write(32);
            len = key.length();
            for (i = 0; i < len; ++i) {
                out.write(key.charAt(i));
            }
            out.write(0);
            String sha1 = entry.getSha1();
            byte[] hash = Hex.toBytes(sha1);
            out.write(hash, 0, hash.length);
        }
    }

    private void updateString(MessageDigest md, String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            md.update((byte)s.charAt(i));
        }
    }

    private void addBlob(String name, int mode, String sha1) {
        Entry entry = new Entry(name, 0x8000 | mode & 0x1FF, sha1);
        this._treeMap.put(name, entry);
    }

    private GitWorkingTree getTree(String name) {
        Entry entry = this._treeMap.get(name);
        if (entry != null) {
            return entry.getSubTree();
        }
        GitWorkingTree subTree = new GitWorkingTree();
        entry = new Entry(name, subTree);
        this._treeMap.put(name, entry);
        return subTree;
    }

    public void toData(OutputStream out) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(this._treeMap.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            int i;
            Entry entry = this._treeMap.get(key);
            String mode = String.format("%o", entry.getMode());
            int len = mode.length();
            for (i = 0; i < len; ++i) {
                out.write(mode.charAt(i));
            }
            out.write(32);
            len = key.length();
            for (i = 0; i < len; ++i) {
                out.write(key.charAt(i));
            }
            out.write(0);
            String sha1 = entry.getSha1();
            byte[] hash = Hex.toBytes(sha1);
            out.write(hash, 0, hash.length);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    public class Entry {
        private final String _name;
        private final int _mode;
        private String _sha1;
        private GitWorkingTree _subTree;

        Entry(String name, int mode, String sha1) {
            this._name = name;
            this._mode = mode;
            this._sha1 = sha1;
        }

        Entry(String name, GitWorkingTree subTree) {
            this._name = name;
            this._mode = 16384;
            this._subTree = subTree;
        }

        public String getName() {
            return this._name;
        }

        public int getMode() {
            return this._mode;
        }

        public String getSha1() {
            return this._sha1;
        }

        public void setSha1(String sha1) {
            this._sha1 = sha1;
        }

        public GitWorkingTree getSubTree() {
            return this._subTree;
        }

        public String toString() {
            return "GitTree.Entry[" + this._name + "," + String.format("%o", this._mode) + "," + this._sha1 + "]";
        }
    }
}

