/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.config.ConfigException;
import com.caucho.env.meter.AbstractMeter;
import com.caucho.jmx.Jmx;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class JmxAttributeMeter
extends AbstractMeter {
    private static final Logger log = Logger.getLogger(JmxAttributeMeter.class.getName());
    private MBeanServer _server;
    private ObjectName _objectName;
    private String _attribute;

    public JmxAttributeMeter(String name, String objectName, String attribute) {
        super(name);
        try {
            this._objectName = new ObjectName(objectName);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        this._attribute = attribute;
        this._server = Jmx.getGlobalMBeanServer();
    }

    public double sample() {
        try {
            Object value = this._server.getAttribute(this._objectName, this._attribute);
            if (value == null) {
                return 0.0;
            }
            return ((Number)value).doubleValue();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return 0.0;
        }
    }
}

