/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.ActiveMeter;
import com.caucho.env.meter.ActiveTimeMeter;
import com.caucho.env.meter.AverageMeter;
import com.caucho.env.meter.AverageTimeMeter;
import com.caucho.env.meter.CountMeter;
import com.caucho.env.meter.JmxAttributeMeter;
import com.caucho.env.meter.JmxDeltaMeter;
import com.caucho.env.meter.SampleCountMeter;
import com.caucho.env.meter.SemaphoreMeter;
import com.caucho.env.meter.TimeMeter;
import com.caucho.env.meter.TimeRangeMeter;
import com.caucho.env.service.AbstractResinService;
import java.util.concurrent.ConcurrentHashMap;

public class MeterService
extends AbstractResinService {
    private static MeterService _manager = new MeterService();
    private final ConcurrentHashMap<String, AbstractMeter> _meterMap = new ConcurrentHashMap();

    protected MeterService() {
    }

    protected void setManager(MeterService manager) {
        if (manager == null) {
            manager = new MeterService();
        } else {
            manager._meterMap.putAll(this._meterMap);
        }
        _manager = manager;
    }

    public static MeterService getCurrent() {
        return _manager;
    }

    public static MeterService create() {
        return _manager;
    }

    public static AbstractMeter getMeter(String name) {
        return MeterService.create().getMeterImpl(name);
    }

    private AbstractMeter getMeterImpl(String name) {
        return this._meterMap.get(name);
    }

    public static AverageTimeMeter createAverageTimeMeter(String name) {
        return MeterService.create().createAverageTimeMeterImpl(name);
    }

    private AverageTimeMeter createAverageTimeMeterImpl(String name) {
        AbstractMeter meter = this._meterMap.get(name);
        if (meter == null) {
            meter = this.createMeter(new AverageTimeMeter(name));
        }
        return (AverageTimeMeter)meter;
    }

    public static SampleCountMeter createSampleCountMeter(String name) {
        return MeterService.create().createSampleCountMeterImpl(name);
    }

    private SampleCountMeter createSampleCountMeterImpl(String name) {
        AbstractMeter meter = this._meterMap.get(name);
        if (meter == null) {
            meter = this.createMeter(new SampleCountMeter(name));
        }
        return (SampleCountMeter)meter;
    }

    public static CountMeter createCountMeter(String name) {
        return MeterService.create().createCountMeterImpl(name);
    }

    private CountMeter createCountMeterImpl(String name) {
        AbstractMeter meter = this._meterMap.get(name);
        if (meter == null) {
            meter = this.createMeter(new CountMeter(name));
        }
        return (CountMeter)meter;
    }

    public static AbstractMeter createJmx(String name, String objectName, String attribute) {
        return MeterService.create().createJmxImpl(name, objectName, attribute);
    }

    private AbstractMeter createJmxImpl(String name, String objectName, String attribute) {
        AbstractMeter meter = this._meterMap.get(name);
        if (meter == null) {
            meter = this.createMeter(new JmxAttributeMeter(name, objectName, attribute));
        }
        return meter;
    }

    public static AbstractMeter createJmxDelta(String name, String objectName, String attribute) {
        return MeterService.create().createJmxDeltaImpl(name, objectName, attribute);
    }

    private AbstractMeter createJmxDeltaImpl(String name, String objectName, String attribute) {
        AbstractMeter meter = this._meterMap.get(name);
        if (meter == null) {
            meter = this.createMeter(new JmxDeltaMeter(name, objectName, attribute));
        }
        return meter;
    }

    public static TimeMeter createTimeMeter(String name) {
        return MeterService.create().createTimeMeterImpl(name);
    }

    private TimeMeter createTimeMeterImpl(String name) {
        AbstractMeter meter = this._meterMap.get(name);
        if (meter == null) {
            meter = this.createMeter(new TimeMeter(name));
        }
        return (TimeMeter)meter;
    }

    public static TimeRangeMeter createTimeRangeMeter(String baseName) {
        return MeterService.create().createTimeRangeMeterImpl(baseName);
    }

    private TimeRangeMeter createTimeRangeMeterImpl(String baseName) {
        String timeName = baseName + " Time";
        AbstractMeter meter = this._meterMap.get(timeName);
        if (meter == null) {
            meter = this.createMeter(new TimeRangeMeter(timeName));
            TimeRangeMeter timeRangeMeter = (TimeRangeMeter)meter;
            String countName = baseName + " Count";
            this.createMeter(timeRangeMeter.createCount(countName));
            String maxName = baseName + " Max";
            this.createMeter(timeRangeMeter.createMax(maxName));
        }
        return (TimeRangeMeter)meter;
    }

    public static AverageMeter createAverageMeter(String name, String type) {
        return MeterService.create().createAverageMeterImpl(name, type);
    }

    private AverageMeter createAverageMeterImpl(String baseName, String type) {
        String name = !"".equals(type) ? baseName + " " + type : baseName;
        AbstractMeter meter = this._meterMap.get(name);
        if (meter == null) {
            meter = this.createMeter(new AverageMeter(name));
            AverageMeter averageMeter = (AverageMeter)meter;
            String countName = baseName + " Count";
            this.createMeter(averageMeter.createCount(countName));
            String sigmaName = name + " 95%";
            this.createMeter(averageMeter.createSigma(sigmaName, 3));
            String maxName = name + " Max";
            this.createMeter(averageMeter.createMax(maxName));
        }
        return (AverageMeter)meter;
    }

    public static ActiveTimeMeter createActiveTimeMeter(String name) {
        return MeterService.create().createActiveTimeMeterImpl(name, "Time", null);
    }

    public static ActiveTimeMeter createActiveTimeMeter(String name, String type, String subName) {
        return MeterService.create().createActiveTimeMeterImpl(name, type, subName);
    }

    private ActiveTimeMeter createActiveTimeMeterImpl(String baseName, String type, String subName) {
        if (subName == null || subName.equals("")) {
            subName = "";
        } else if (!subName.startsWith("|")) {
            subName = "|" + subName;
        }
        String name = baseName + " " + type + subName;
        AbstractMeter meter = this._meterMap.get(name);
        if (meter == null) {
            meter = this.createMeter(new ActiveTimeMeter(name));
            ActiveTimeMeter activeTimeMeter = (ActiveTimeMeter)meter;
            String sigmaName = baseName + " " + type + " 95%" + subName;
            this.createMeter(activeTimeMeter.createSigma(sigmaName, 3));
            String maxName = baseName + " " + type + " Max" + subName;
            this.createMeter(activeTimeMeter.createMax(maxName));
            String activeMaxName = baseName + " Active" + subName;
            this.createMeter(activeTimeMeter.createActiveCountMax(activeMaxName));
            String totalCountName = baseName + " Count" + subName;
            this.createMeter(activeTimeMeter.createTotalCount(totalCountName));
        }
        return (ActiveTimeMeter)meter;
    }

    public static ActiveMeter createActiveMeter(String name) {
        return MeterService.create().createActiveMeterImpl(name, null);
    }

    public static ActiveMeter createActiveMeter(String name, String subName) {
        return _manager.createActiveMeterImpl(name, subName);
    }

    private ActiveMeter createActiveMeterImpl(String baseName, String subName) {
        if (subName == null || subName.equals("")) {
            subName = "";
        } else if (!subName.startsWith("|")) {
            subName = "|" + subName;
        }
        String name = baseName + " Count" + subName;
        AbstractMeter meter = this._meterMap.get(name);
        if (meter == null) {
            meter = this.createMeter(new ActiveMeter(name));
            ActiveMeter activeMeter = (ActiveMeter)meter;
            String maxName = baseName + " Active" + subName;
            this.createMeter(activeMeter.createMax(maxName));
        }
        return (ActiveMeter)meter;
    }

    public static SemaphoreMeter createSimpleSemaphoreMeter(String name) {
        return MeterService.create().createSemaphoreMeterImpl(name, false);
    }

    public static SemaphoreMeter createSemaphoreMeter(String name) {
        return MeterService.create().createSemaphoreMeterImpl(name, true);
    }

    private SemaphoreMeter createSemaphoreMeterImpl(String baseName, boolean isExtended) {
        String name = baseName;
        AbstractMeter meter = this._meterMap.get(name);
        if (meter == null) {
            meter = this.createMeter(new SemaphoreMeter(name));
        }
        SemaphoreMeter semaphoreMeter = (SemaphoreMeter)meter;
        if (!isExtended) {
            return semaphoreMeter;
        }
        String countName = baseName + " Acquire";
        this.createMeter(semaphoreMeter.createCount(countName));
        String maxName = name + " Max";
        this.createMeter(semaphoreMeter.createMax(maxName));
        String minName = name + " Min";
        this.createMeter(semaphoreMeter.createMin(minName));
        return (SemaphoreMeter)meter;
    }

    public AbstractMeter createMeter(AbstractMeter newMeter) {
        AbstractMeter meter = this._meterMap.putIfAbsent(newMeter.getName(), newMeter);
        if (meter != null) {
            return meter;
        }
        this.registerMeter(newMeter);
        return newMeter;
    }

    protected void registerMeter(AbstractMeter meter) {
    }
}

