/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.service;

import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.java.WorkDir;
import com.caucho.util.L10N;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import java.io.IOException;

public class RootDirectoryService
extends AbstractResinService {
    private static final L10N L = new L10N(RootDirectoryService.class);
    public static final int START_PRIORITY_ROOT_DIRECTORY = 20;
    private final Path _rootDirectory;
    private final Path _dataDirectory;

    public RootDirectoryService(Path rootDirectory) throws IOException {
        this(rootDirectory, rootDirectory.lookup("resin-data"));
    }

    public RootDirectoryService(Path rootDirectory, Path dataDirectory) throws IOException {
        if (rootDirectory == null) {
            throw new NullPointerException();
        }
        if (dataDirectory == null) {
            throw new NullPointerException();
        }
        if (dataDirectory instanceof MemoryPath) {
            dataDirectory = WorkDir.getTmpWorkDir().lookup("qa/" + dataDirectory.getFullPath());
        }
        this._rootDirectory = rootDirectory;
        this._dataDirectory = dataDirectory;
        rootDirectory.mkdirs();
        dataDirectory.mkdirs();
    }

    public static RootDirectoryService getCurrent() {
        return ResinSystem.getCurrentService(RootDirectoryService.class);
    }

    public static Path getCurrentDataDirectory() {
        RootDirectoryService rootService = RootDirectoryService.getCurrent();
        if (rootService == null) {
            throw new IllegalStateException(L.l("{0} must be active for getCurrentDataDirectory().", RootDirectoryService.class.getSimpleName()));
        }
        return rootService.getDataDirectory();
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    public Path getDataDirectory() {
        return this._dataDirectory;
    }

    public int getStartPriority() {
        return 20;
    }
}

