/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread;

import com.caucho.env.thread.ThreadPool;
import com.caucho.env.thread.ThreadTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ResinThread
extends Thread {
    private static final Logger log = Logger.getLogger(ResinThread.class.getName());
    private final ThreadPool _pool;
    private final int _id;
    private final String _name;
    private volatile ResinThread _next;
    private boolean _isClose;
    private volatile ClassLoader _taskLoader;
    private final AtomicReference<Runnable> _taskRef = new AtomicReference();

    ResinThread(ThreadPool pool, int id) {
        this._pool = pool;
        this._id = id;
        this._name = "resin-" + this._id;
        this.setDaemon(true);
    }

    public String getDebugName() {
        return this._name;
    }

    public long getThreadId() {
        return this.getId();
    }

    final ResinThread getNext() {
        return this._next;
    }

    final void setNext(ResinThread thread) {
        this._next = thread;
    }

    final boolean scheduleTask(Runnable task, ClassLoader loader) {
        if (this._isClose) {
            return false;
        }
        this._taskLoader = loader;
        if (this._taskRef.getAndSet(task) != null) {
            System.out.println("BAD: getandset");
        }
        LockSupport.unpark(this);
        return true;
    }

    final void close() {
        this._isClose = true;
        LockSupport.unpark(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this._pool.onThreadStart();
            this.runTasks();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._pool.onThreadEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() {
        boolean isFirst = true;
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        ResinThread thread = this;
        this.setName(this._name);
        while (!this._isClose) {
            Runnable task = null;
            ClassLoader classLoader = null;
            ThreadTask taskItem = this._pool.nextTask(this);
            if (taskItem != null) {
                if (isFirst) {
                    this._pool.onThreadFirstTask();
                }
                this._pool.startIdleThread();
                task = taskItem.getRunnable();
                classLoader = taskItem.getLoader();
                taskItem.wake();
            } else {
                if (this._pool.isIdleExpire()) {
                    if (isFirst) {
                        this._pool.onThreadFirstTask();
                    }
                    return;
                }
                task = this.waitForTask(isFirst);
                if (task != null) {
                    classLoader = this._taskLoader;
                    this._taskLoader = null;
                } else {
                    return;
                }
            }
            isFirst = false;
            try {
                thread.setContextClassLoader(classLoader);
                task.run();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                thread.setContextClassLoader(systemClassLoader);
            }
        }
        if (isFirst) {
            // empty if block
        }
    }

    private Runnable waitForTask(boolean isFirst) {
        this._pool.pushIdleThread(this);
        if (isFirst) {
            this._pool.onThreadFirstTask();
        }
        while (!this._isClose) {
            Runnable task = this._taskRef.getAndSet(null);
            if (task != null) {
                return task;
            }
            this.setName(this._name);
            Thread.interrupted();
            LockSupport.park();
        }
        return null;
    }
}

