/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread;

import com.caucho.env.thread.ThreadPool;
import com.caucho.util.Alarm;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public abstract class TaskWorker
implements Runnable {
    private static final int TASK_PARK = 0;
    private static final int TASK_SLEEP = 1;
    private static final int TASK_READY = 2;
    private static final AtomicLong _idGen = new AtomicLong();
    private final AtomicInteger _taskState = new AtomicInteger();
    private final AtomicBoolean _isActive = new AtomicBoolean();
    private final ThreadPool _threadPool;
    private final ClassLoader _classLoader = Thread.currentThread().getContextClassLoader();
    private long _idleTimeout = 30000L;
    private boolean _isClosed;
    private volatile Thread _thread;

    protected TaskWorker() {
        this._threadPool = ThreadPool.getCurrent();
    }

    protected boolean isPermanent() {
        return false;
    }

    public boolean isTaskActive() {
        return this._isActive.get();
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public abstract long runTask();

    public void destroy() {
        this._isClosed = true;
        this.wake();
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public final void wake() {
        Thread thread;
        int oldState = this._taskState.getAndSet(2);
        if (!this._isActive.getAndSet(true)) {
            this._threadPool.schedulePriority(this);
        }
        if (oldState == 0 && (thread = this._thread) != null) {
            LockSupport.unpark(thread);
        }
    }

    protected String getThreadName() {
        return this.toString() + "-" + _idGen.incrementAndGet();
    }

    protected void onThreadStart() {
    }

    protected void onThreadComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        String oldName = null;
        try {
            this._thread = Thread.currentThread();
            this._thread.setContextClassLoader(this._classLoader);
            oldName = this._thread.getName();
            this._thread.setName(this.getThreadName());
            this.onThreadStart();
            long expires = Alarm.getCurrentTimeActual() + this._idleTimeout;
            while (true) {
                if (this._taskState.getAndSet(1) == 2) {
                    long delta = this.runTask();
                    if (delta < 0L) {
                        expires = Alarm.getCurrentTimeActual() + this._idleTimeout;
                        continue;
                    }
                    expires = Alarm.getCurrentTimeActual() + delta;
                    continue;
                }
                if (this.isClosed()) {
                    return;
                }
                if (this._taskState.compareAndSet(1, 0)) {
                    Thread.interrupted();
                    LockSupport.parkUntil(expires);
                    if (this.isPermanent()) {
                        this._taskState.set(2);
                    }
                }
                if (this._taskState.get() != 2 && Alarm.getCurrentTimeActual() >= expires && !this.isPermanent()) break;
            }
        }
        finally {
            Thread thread = this._thread;
            this._thread = null;
            this._isActive.set(false);
            if (this._taskState.get() == 2) {
                this.wake();
            }
            this.onThreadComplete();
            if (thread != null && oldName != null) {
                thread.setName(oldName);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

