/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.broker;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.hemp.broker.QueueWorker;
import com.caucho.hemp.packet.Message;
import com.caucho.hemp.packet.MessageError;
import com.caucho.hemp.packet.Packet;
import com.caucho.hemp.packet.PacketQueue;
import com.caucho.hemp.packet.QueryError;
import com.caucho.hemp.packet.QueryGet;
import com.caucho.hemp.packet.QueryResult;
import com.caucho.hemp.packet.QuerySet;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.io.Closeable;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HempMemoryQueue
implements ActorStream,
Closeable {
    private static final L10N L = new L10N(HempMemoryQueue.class);
    private static final Logger log = Logger.getLogger(HempMemoryQueue.class.getName());
    private final String _name;
    private final ActorStream _linkStream;
    private final ActorStream _actorStream;
    private final QueueWorker[] _workers;
    private final PacketQueue _queue;
    private final Lifecycle _lifecycle = new Lifecycle();

    public HempMemoryQueue(ActorStream actorStream, ActorStream linkStream, int threadMax) {
        if (linkStream == null) {
            throw new NullPointerException();
        }
        if (actorStream == null) {
            throw new NullPointerException();
        }
        this._linkStream = linkStream;
        this._actorStream = actorStream;
        this._name = this._actorStream.getJid() == null ? this._actorStream.getClass().getSimpleName() : this._actorStream.getJid();
        this._workers = new QueueWorker[threadMax];
        for (int i = 0; i < threadMax; ++i) {
            this._workers[i] = new QueueWorker(this);
        }
        int maxDiscardSize = -1;
        int maxBlockSize = 1024;
        long expireTimeout = -1L;
        this._queue = new PacketQueue(this._name, maxDiscardSize, maxBlockSize, expireTimeout);
        this._lifecycle.toActive();
        Environment.addCloseListener(this);
    }

    public String getJid() {
        return this._actorStream.getJid();
    }

    public boolean isPacketAvailable() {
        return !this._queue.isEmpty();
    }

    public ActorStream getLinkStream() {
        return this._linkStream;
    }

    protected ActorStream getActorStream() {
        return this._actorStream;
    }

    public void message(String to, String from, Serializable value) {
        this.enqueue(new Message(to, from, value));
    }

    public void messageError(String to, String from, Serializable value, ActorError error) {
        this.enqueue(new MessageError(to, from, value, error));
    }

    public void queryGet(long id, String to, String from, Serializable query) {
        this.enqueue(new QueryGet(id, to, from, query));
    }

    public void querySet(long id, String to, String from, Serializable payload) {
        this.enqueue(new QuerySet(id, to, from, payload));
    }

    public void queryResult(long id, String to, String from, Serializable value) {
        this.enqueue(new QueryResult(id, to, from, value));
    }

    public void queryError(long id, String to, String from, Serializable query, ActorError error) {
        this.enqueue(new QueryError(id, to, from, query, error));
    }

    protected final void enqueue(Packet packet) {
        if (!this._lifecycle.isActive()) {
            throw new IllegalStateException(L.l("{0} cannot accept packets because it's no longer active", this));
        }
        if (log.isLoggable(Level.FINEST)) {
            int size = this._queue.getSize();
            log.finest(this + " enqueue(" + size + ") " + packet);
        }
        this._queue.enqueue(packet);
        this.wakeConsumer(packet);
    }

    private void wakeConsumer(Packet packet) {
        for (QueueWorker worker : this._workers) {
            boolean isRunning = worker.isRunning();
            worker.wake();
            if (isRunning) continue;
            return;
        }
    }

    protected void dispatch(Packet packet) {
        packet.dispatch(this.getActorStream(), this._linkStream);
    }

    protected Packet dequeue() {
        return this._queue.dequeue();
    }

    public void close() {
        this._lifecycle.toStop();
        for (QueueWorker worker : this._workers) {
            worker.wake();
        }
        long expires = Alarm.getCurrentTimeActual() + 2000L;
        while (!this._queue.isEmpty() && Alarm.getCurrentTimeActual() < expires) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        for (QueueWorker worker : this._workers) {
            worker.destroy();
        }
        this._lifecycle.toDestroy();
    }

    public boolean isClosed() {
        return this._lifecycle.isDestroying() || this._linkStream.isClosed();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

