/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.services;

import com.caucho.bam.SimpleActor;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class BamJmsService
extends SimpleActor {
    private static final L10N L = new L10N(BamJmsService.class);
    private static final Logger log = Logger.getLogger(BamJmsService.class.getName());
    private ConnectionFactory _factory;
    private Destination _queue;
    private Connection _conn;
    private Session _session;
    private MessageProducer _producer;

    public void setConnectionFactory(ConnectionFactory factory) {
        this._factory = factory;
    }

    public void setDestination(Destination queue) {
        this._queue = queue;
    }

    @PostConstruct
    public void init() throws JMSException {
        if (this._factory == null) {
            throw new ConfigException(L.l("{0} requires a JMS ConnectionFactory", this.getClass().getSimpleName()));
        }
        if (this._queue == null) {
            throw new ConfigException(L.l("{0} requires a JMS destination", this.getClass().getSimpleName()));
        }
        this._conn = this._factory.createConnection();
        this._session = this._conn.createSession(false, 1);
        this._producer = this._session.createProducer(this._queue);
    }

    public void message(String to, String from, Serializable value) {
        try {
            ObjectMessage msg = this._session.createObjectMessage(value);
            this._producer.send((Message)msg);
        }
        catch (JMSException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @PreDestroy
    public void close() {
        try {
            this._session.close();
            this._conn.close();
        }
        catch (JMSException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }
}

