/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.services;

import com.caucho.bam.SimpleActor;
import com.caucho.config.types.Period;
import com.caucho.hemp.services.MailService;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class BamMailService
extends SimpleActor
implements AlarmListener {
    private static final Logger log = Logger.getLogger(BamMailService.class.getName());
    @Inject
    private Session _session;
    private long _delayTime = 60000L;
    private StringBuilder _text;
    private Alarm _alarm;
    private MailService _mailService = new MailService();

    public BamMailService() {
        this._alarm = new Alarm(this);
    }

    public void setDelayTime(Period period) {
        this._delayTime = period.getPeriod();
    }

    public void setMailSession(Session session) {
        this._mailService.setSession(session);
    }

    public void setProperty(String key, String value) {
        this._mailService.setProperty(key, value);
    }

    public void setProperties(Properties props) {
        this._mailService.setProperties(props);
    }

    public void setSubject(String subject) {
        this._mailService.setSubject(subject);
    }

    public void addTo(String to) throws AddressException {
        this._mailService.addTo((Address)new InternetAddress(to));
    }

    @PostConstruct
    public void init() {
        this._mailService.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void message(String to, String from, Serializable value) {
        String text = this.messageToText(value);
        if (this._delayTime <= 0L) {
            this._mailService.send(text);
            return;
        }
        boolean isStartAlarm = false;
        BamMailService bamMailService = this;
        synchronized (bamMailService) {
            if (this._text == null) {
                isStartAlarm = true;
                this._text = new StringBuilder();
            }
            this._text.append(text).append("\n");
        }
        if (isStartAlarm) {
            this._alarm.queue(this._delayTime);
        }
    }

    protected String messageToText(Serializable value) {
        String text = null;
        if (value instanceof String) {
            text = value.toString();
        } else if (value instanceof TextMessage) {
            try {
                text = ((TextMessage)value).getText();
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        } else if (value instanceof ObjectMessage) {
            try {
                text = String.valueOf(((ObjectMessage)value).getObject());
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        if (text == null) {
            text = String.valueOf(value);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        String text = null;
        BamMailService bamMailService = this;
        synchronized (bamMailService) {
            if (this._text != null) {
                text = this._text.toString();
            }
            this._text = null;
        }
        if (text != null) {
            this._mailService.send(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void close() {
        String text = null;
        BamMailService bamMailService = this;
        synchronized (bamMailService) {
            if (this._text != null) {
                text = this._text.toString();
            }
            this._text = null;
        }
        if (text != null) {
            this._mailService.send(text);
        }
    }
}

