/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.services;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

public class MailService {
    private static final L10N L = new L10N(MailService.class);
    private static final Logger log = Logger.getLogger(MailService.class.getName());
    private ArrayList<Address> _toList = new ArrayList();
    private Address[] _to;
    private String _subject = "Resin MailService messages";
    private Properties _properties = new Properties();
    private Session _session;
    private Transport _smtp;

    public void setSession(Session session) {
        this._session = session;
    }

    public Session getSession() {
        return this._session;
    }

    public void addTo(Address address) {
        this._toList.add(address);
    }

    public void setProperty(String key, String value) {
        this._properties.put(key, value);
    }

    public void setProperties(Properties props) {
        this._properties.putAll((Map<?, ?>)props);
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public void send(String text) {
        try {
            MimeMessage msg = new MimeMessage(this.getSession());
            msg.addRecipients(Message.RecipientType.TO, this._to);
            msg.setSubject(this._subject);
            msg.setContent((Object)text, "text/plain");
            this.send((Message)msg);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    public void send(Message message) {
        block10: {
            Transport smtp = null;
            smtp = this._session.getTransport("smtp");
            smtp.connect();
            Transport.send((Message)message, (Address[])this._to);
            log.fine(this + " sent mail to " + this._to[0]);
            Object var5_3 = null;
            try {
                if (smtp != null) {
                    smtp.close();
                }
                break block10;
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
            break block10;
            {
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (smtp != null) {
                        smtp.close();
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                throw throwable;
            }
        }
    }

    public void init() {
        if (this._toList.size() == 0) {
            throw new ConfigException(L.l("mail service requires at least one 'to' address"));
        }
        this._to = new Address[this._toList.size()];
        this._toList.toArray(this._to);
        try {
            if (this._session == null) {
                this._session = Session.getInstance((Properties)this._properties);
            }
            Transport smtp = this._session.getTransport("smtp");
            smtp.close();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this._toList;
    }
}

