/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.servlet;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorException;
import com.caucho.bam.ActorStream;
import com.caucho.bam.Broker;
import com.caucho.bam.QueryGet;
import com.caucho.bam.QuerySet;
import com.caucho.bam.SimpleActor;
import com.caucho.hemp.servlet.LoginQuery;
import com.caucho.hemp.servlet.ServerAuthManager;
import com.caucho.hemp.servlet.ServerLinkStream;
import com.caucho.hemp.servlet.ServerPassStream;
import com.caucho.hmtp.AuthQuery;
import com.caucho.hmtp.AuthResult;
import com.caucho.hmtp.NonceQuery;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerLinkActor
extends SimpleActor {
    private static final Logger log = Logger.getLogger(ServerLinkActor.class.getName());
    private final Broker _broker;
    private final ServerLinkStream _serverLinkStream;
    private final ServerPassStream _serverPassStream;
    private final ActorStream _brokerStream;
    private final ServerAuthManager _authManager;
    private final String _ipAddress;

    public ServerLinkActor(ActorStream linkStream, Broker broker, ServerAuthManager authManager, String ipAddress, boolean isUnidir) {
        if (linkStream == null) {
            throw new NullPointerException();
        }
        if (broker == null) {
            throw new NullPointerException();
        }
        this.setLinkStream(linkStream);
        this._broker = broker;
        this._authManager = authManager;
        this._ipAddress = ipAddress;
        if (isUnidir) {
            this._serverPassStream = new ServerPassStream(linkStream, this);
            this._brokerStream = this._serverPassStream;
            this._serverLinkStream = null;
        } else {
            this._serverPassStream = null;
            this._serverLinkStream = new ServerLinkStream(linkStream, this);
            this._brokerStream = this._serverLinkStream;
        }
    }

    public ActorStream getBrokerStream() {
        return this._brokerStream;
    }

    @QueryGet
    public void getNonce(long id, String to, String from, NonceQuery query) {
        NonceQuery result = this._authManager.generateNonce(query);
        this.getLinkStream().queryResult(id, from, to, result);
    }

    @QuerySet
    public void authLogin(long id, String to, String from, LoginQuery query) {
        this.login(id, to, from, query.getAuth(), query.getAddress());
    }

    @QuerySet
    public void authLogin(long id, String to, String from, AuthQuery query) {
        this.login(id, to, from, query, this._ipAddress);
    }

    private void login(long id, String to, String from, AuthQuery query, String ipAddress) {
        String uid = query.getUid();
        Serializable credentials = query.getCredentials();
        try {
            this._authManager.authenticate(query.getUid(), credentials, ipAddress);
        }
        catch (ActorException e) {
            log.log(Level.FINE, e.toString(), e);
            this.getLinkStream().queryError(id, from, to, query, e.createActorError());
            return;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            this.getLinkStream().queryError(id, from, to, query, new ActorError("auth", "not-authorized", e.getMessage()));
            return;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (this._serverLinkStream != null) {
            this._serverLinkStream.setBrokerStream(this._broker.getBrokerStream());
        }
        if (this._serverPassStream != null) {
            this._serverPassStream.setBrokerStream(this._broker.getBrokerStream());
        }
        String jid = this._broker.createClient(this.getLinkStream(), uid, query.getResource());
        if (this._serverLinkStream != null) {
            this._serverLinkStream.setJid(jid);
        }
        if (this._serverPassStream != null) {
            this._serverPassStream.setJid(jid);
        }
        this.notifyValidLogin(from);
        AuthResult result = new AuthResult(jid);
        this.getLinkStream().queryResult(id, from, to, result);
    }

    protected void notifyValidLogin(String jid) {
    }
}

