/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.Actor;
import com.caucho.bam.ActorStream;
import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.hmtp.HmtpReader;
import com.caucho.hmtp.HmtpWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HmtpLink
implements Runnable {
    protected InputStream _is;
    protected OutputStream _os;
    private String _jid;
    private ActorStream _actorStream;
    private HmtpWriter _toLinkStream;
    private HmtpReader _in;

    public HmtpLink(Actor actor, InputStream is, OutputStream os) {
        this._actorStream = actor.getActorStream();
        this._is = is;
        this._os = os;
        this._toLinkStream = new HmtpWriter(this._os);
        this._in = new HmtpReader(this._is);
        if (actor.getJid() == null) {
            actor.setJid(actor.getClass().getSimpleName() + "@link");
        }
        actor.setLinkStream(this._toLinkStream);
    }

    public String getJid() {
        return this._jid;
    }

    public void setJid(String jid) {
        this._jid = jid;
    }

    public ActorStream getLinkStream() {
        return this._toLinkStream;
    }

    public ActorStream getActorStream() {
        ActorStream stream = this._actorStream;
        if (stream != null) {
            return stream;
        }
        throw new RemoteConnectionFailedException("connection has been closed");
    }

    public boolean isClosed() {
        return this._actorStream == null;
    }

    public void run() {
        try {
            while (!this.isClosed() && this._in.readPacket(this._actorStream)) {
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this._actorStream = null;
    }
}

