/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2StreamingInput;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hmtp.HmtpPacketType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmtpReader {
    private static final Logger log = Logger.getLogger(HmtpReader.class.getName());
    private String _id;
    private InputStream _is;
    private Hessian2StreamingInput _in;

    public HmtpReader() {
    }

    public HmtpReader(InputStream is) {
        this.init(is);
    }

    public void setId(String id) {
        this._id = id;
    }

    public void init(InputStream is) {
        this._is = is;
        if (log.isLoggable(Level.FINEST)) {
            HessianDebugInputStream hIs = new HessianDebugInputStream(is, log, Level.FINEST);
            hIs.startStreaming();
            is = hIs;
        }
        this._in = new Hessian2StreamingInput(is);
    }

    public boolean isDataAvailable() {
        return this._in != null && this._in.isDataAvailable();
    }

    public boolean readPacket(ActorStream actorStream) throws IOException {
        if (actorStream == null) {
            throw new IllegalStateException("HmtpReader.readPacket requires a valid ActorStream for callbacks");
        }
        Hessian2StreamingInput in = this._in;
        if (in == null) {
            return false;
        }
        Hessian2Input hIn = null;
        try {
            hIn = in.startPacket();
        }
        catch (IOException e) {
            log.fine(this + " exception while reading HMTP packet\n  " + e);
            log.log(Level.FINER, e.toString(), e);
        }
        if (hIn == null) {
            this.close();
            return false;
        }
        int type = hIn.readInt();
        String to = hIn.readString();
        String from = hIn.readString();
        switch (HmtpPacketType.TYPES[type]) {
            case MESSAGE: {
                Serializable value = (Serializable)hIn.readObject();
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " message " + value + " {to:" + to + ", from:" + from + "}");
                }
                actorStream.message(to, from, value);
                break;
            }
            case MESSAGE_ERROR: {
                Serializable value = (Serializable)hIn.readObject();
                ActorError error = (ActorError)hIn.readObject();
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " messageError " + error + " " + value + " {to:" + to + ", from:" + from + "}");
                }
                actorStream.messageError(to, from, value, error);
                break;
            }
            case QUERY_GET: {
                long id = hIn.readLong();
                Serializable value = (Serializable)hIn.readObject();
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryGet " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.queryGet(id, to, from, value);
                break;
            }
            case QUERY_SET: {
                long id = hIn.readLong();
                Serializable value = (Serializable)hIn.readObject();
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " querySet " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.querySet(id, to, from, value);
                break;
            }
            case QUERY_RESULT: {
                long id = hIn.readLong();
                Serializable value = (Serializable)hIn.readObject();
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryResult " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.queryResult(id, to, from, value);
                break;
            }
            case QUERY_ERROR: {
                long id = hIn.readLong();
                Serializable value = (Serializable)hIn.readObject();
                ActorError error = (ActorError)hIn.readObject();
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryError " + error + " " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.queryError(id, to, from, value, error);
                break;
            }
            default: {
                throw new UnsupportedOperationException("ERROR: " + (Object)((Object)HmtpPacketType.TYPES[type]));
            }
        }
        return true;
    }

    public void close() {
        try {
            Hessian2StreamingInput in = this._in;
            this._in = null;
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public String toString() {
        if (this._id != null) {
            return this.getClass().getSimpleName() + "[" + this._id + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._is + "]";
    }
}

