/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.bam.ProtocolException;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hmtp.HmtpPacketType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmtpWriter
implements ActorStream {
    private static final Logger log = Logger.getLogger(HmtpWriter.class.getName());
    private String _jid;
    private OutputStream _os;
    private Hessian2Output _out;
    private boolean _isAutoFlush = true;

    public HmtpWriter() {
    }

    public HmtpWriter(OutputStream os) {
        this.init(os);
    }

    public void setAutoFlush(boolean isAutoFlush) {
        this._isAutoFlush = isAutoFlush;
    }

    public void init(OutputStream os) {
        this._os = os;
        if (log.isLoggable(Level.FINEST)) {
            HessianDebugOutputStream dOut = new HessianDebugOutputStream(this._os, log, Level.FINEST);
            dOut.startStreaming();
            this._os = dOut;
        }
        this._out = new Hessian2Output(this._os);
    }

    public String getJid() {
        return this._jid;
    }

    public void setJid(String jid) {
        this._jid = jid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void message(String to, String from, Serializable value) {
        block7: {
            try {
                Hessian2Output out = this._out;
                if (out == null) break block7;
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " message " + value + " {to:" + to + ", from:" + from + "}");
                }
                Hessian2Output hessian2Output = out;
                synchronized (hessian2Output) {
                    out.startPacket();
                    out.writeInt(HmtpPacketType.MESSAGE.ordinal());
                    out.writeString(to);
                    out.writeString(from);
                    out.writeObject(value);
                    out.endPacket();
                    if (this._isAutoFlush) {
                        out.flush();
                    }
                }
            }
            catch (IOException e) {
                this.close();
                throw new ProtocolException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageError(String to, String from, Serializable value, ActorError error) {
        block7: {
            try {
                Hessian2Output out = this._out;
                if (out == null) break block7;
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " messageError " + value + " {to:" + to + ", from:" + from + "}");
                }
                Hessian2Output hessian2Output = out;
                synchronized (hessian2Output) {
                    out.startPacket();
                    out.writeInt(HmtpPacketType.MESSAGE_ERROR.ordinal());
                    out.writeString(to);
                    out.writeString(from);
                    out.writeObject(value);
                    out.writeObject(error);
                    out.endPacket();
                    if (this._isAutoFlush) {
                        out.flush();
                    }
                }
            }
            catch (IOException e) {
                this.close();
                throw new ProtocolException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryGet(long id, String to, String from, Serializable value) {
        block7: {
            try {
                Hessian2Output out = this._out;
                if (out == null) break block7;
                Hessian2Output hessian2Output = out;
                synchronized (hessian2Output) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(this + " queryGet " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
                    }
                    out.startPacket();
                    out.writeInt(HmtpPacketType.QUERY_GET.ordinal());
                    out.writeString(to);
                    out.writeString(from);
                    out.writeLong(id);
                    out.writeObject(value);
                    out.endPacket();
                    if (this._isAutoFlush) {
                        out.flush();
                    }
                }
            }
            catch (IOException e) {
                this.close();
                throw new ProtocolException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void querySet(long id, String to, String from, Serializable value) {
        block7: {
            try {
                Hessian2Output out = this._out;
                if (out == null) break block7;
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " querySet " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
                }
                Hessian2Output hessian2Output = out;
                synchronized (hessian2Output) {
                    out.startPacket();
                    out.writeInt(HmtpPacketType.QUERY_SET.ordinal());
                    out.writeString(to);
                    out.writeString(from);
                    out.writeLong(id);
                    out.writeObject(value);
                    out.endPacket();
                    if (this._isAutoFlush) {
                        out.flush();
                    }
                }
            }
            catch (IOException e) {
                this.close();
                throw new ProtocolException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryResult(long id, String to, String from, Serializable value) {
        block7: {
            try {
                Hessian2Output out = this._out;
                if (out == null) break block7;
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryResult " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
                }
                Hessian2Output hessian2Output = out;
                synchronized (hessian2Output) {
                    out.startPacket();
                    out.writeInt(HmtpPacketType.QUERY_RESULT.ordinal());
                    out.writeString(to);
                    out.writeString(from);
                    out.writeLong(id);
                    out.writeObject(value);
                    out.endPacket();
                    if (this._isAutoFlush) {
                        out.flush();
                    }
                }
            }
            catch (IOException e) {
                this.close();
                throw new ProtocolException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryError(long id, String to, String from, Serializable value, ActorError error) {
        block7: {
            try {
                Hessian2Output out = this._out;
                if (out == null) break block7;
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryError " + error + " " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
                }
                Hessian2Output hessian2Output = out;
                synchronized (hessian2Output) {
                    out.startPacket();
                    out.writeInt(HmtpPacketType.QUERY_ERROR.ordinal());
                    out.writeString(to);
                    out.writeString(from);
                    out.writeLong(id);
                    out.writeObject(value);
                    out.writeObject(error);
                    out.endPacket();
                    if (this._isAutoFlush) {
                        out.flush();
                    }
                }
            }
            catch (IOException e) {
                this.close();
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Hessian2Output out = this._out;
        if (out != null) {
            Hessian2Output hessian2Output = out;
            synchronized (hessian2Output) {
                out.flush();
            }
        }
    }

    public boolean isClosed() {
        return this._out == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block6: {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " close");
            }
            try {
                Hessian2Output out = this._out;
                this._out = null;
                if (out == null) break block6;
                Hessian2Output hessian2Output = out;
                synchronized (hessian2Output) {
                    out.close();
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getJid() + "]";
    }
}

