/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.JavaCompiler;
import com.caucho.java.LineMap;
import com.caucho.loader.ClassLoaderContext;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;

public abstract class AbstractJavaCompiler
implements Runnable {
    protected static final L10N L = new L10N(AbstractJavaCompiler.class);
    protected static final Logger log = Logger.getLogger(AbstractJavaCompiler.class.getName());
    private ClassLoader _loader;
    protected JavaCompiler _compiler;
    private final AtomicBoolean _isDone = new AtomicBoolean();
    private String[] _path;
    private LineMap _lineMap;
    private Thread _compileThread;
    private Thread _waitThread;
    private Throwable _exception;

    public AbstractJavaCompiler(JavaCompiler compiler) {
        this._loader = Thread.currentThread().getContextClassLoader();
        this._compiler = compiler;
    }

    public void setPath(String[] path) {
        this._path = path;
    }

    public void setLineMap(LineMap lineMap) {
        this._lineMap = lineMap;
    }

    public Throwable getException() {
        return this._exception;
    }

    public boolean isDone() {
        return this._isDone.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._compileThread = Thread.currentThread();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this._loader);
                this.compileInt(this._path, this._lineMap);
            }
            catch (Throwable e) {
                new ClassLoaderContext(this._compiler.getClassLoader()){

                    public void run() {
                    }
                };
                this._exception = e;
                Object var3_2 = null;
                Thread.currentThread().setContextClassLoader(null);
                this.notifyComplete();
                this._compileThread = null;
            }
            Object var3_1 = null;
            Thread.currentThread().setContextClassLoader(null);
            this.notifyComplete();
            this._compileThread = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(null);
            this.notifyComplete();
            this._compileThread = null;
            throw throwable;
        }
    }

    protected void waitForComplete(long timeout) {
        Thread thread;
        this._waitThread = Thread.currentThread();
        long endTime = System.currentTimeMillis() + timeout;
        while (!this.isDone() && System.currentTimeMillis() <= endTime && ((thread = this._compileThread) == null || thread.isAlive())) {
            Thread.currentThread();
            Thread.interrupted();
            LockSupport.parkUntil(endTime);
        }
    }

    protected void notifyComplete() {
        this._isDone.set(true);
        Thread thread = this._waitThread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public void abort() {
    }

    protected abstract void compileInt(String[] var1, LineMap var2) throws IOException;
}

