/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.cfg;

import com.caucho.config.ConfigException;
import com.caucho.jca.cfg.AdminObjectConfig;
import com.caucho.jca.cfg.ConnectionDefinition;
import com.caucho.jca.cfg.InboundResourceAdapterConfig;
import com.caucho.jca.cfg.MessageListenerConfig;
import com.caucho.jca.cfg.OutboundResourceAdapterConfig;
import com.caucho.jca.ra.ObjectConfig;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAdapterConfig
extends ObjectConfig {
    private static final L10N L = new L10N(ResourceAdapterConfig.class);
    private Class<?> _adapterClass;
    private ArrayList<ConnectionDefinition> _outboundConnections = new ArrayList();
    private ArrayList<MessageListenerConfig> _inboundConnections = new ArrayList();
    private ArrayList<AdminObjectConfig> _resources = new ArrayList();
    private ConnectionDefinition _connectionDefinition;
    private String _transactionSupport;

    public void setResourceadapterClass(Class<?> cl) throws ConfigException {
        this._adapterClass = cl;
        this.setType(cl);
    }

    public Class<?> getResourceadapterClass() {
        return this._adapterClass;
    }

    public void addAdminobject(AdminObjectConfig adminObject) {
        this._resources.add(adminObject);
    }

    public void setManagedconnectionfactoryClass(Class<?> cl) throws ConfigException {
        this.getConnectionDefinition().setManagedconnectionfactoryClass(cl);
    }

    public void setConnectionfactoryInterface(String cl) {
    }

    public void setConnectionfactoryImplClass(String cl) {
    }

    public void setConnectionInterface(String cl) {
    }

    public void setConnectionImplClass(String cl) {
    }

    private ConnectionDefinition getConnectionDefinition() throws ConfigException {
        if (this._connectionDefinition == null) {
            this._connectionDefinition = new ConnectionDefinition();
            this._outboundConnections.add(this._connectionDefinition);
        }
        return this._connectionDefinition;
    }

    void addConnectionDefinition(ConnectionDefinition conn) throws ConfigException {
        if (this.getConnectionDefinition(conn.getConnectionFactoryInterface().getName()) != null) {
            throw new ConfigException(L.l("'{0}' is a duplicate connection-definition.  The <connectionfactory-interface> must be unique.", conn.getConnectionFactoryInterface().getName()));
        }
        this._outboundConnections.add(conn);
    }

    public ConnectionDefinition getConnectionDefinition(String type) {
        if (type == null && this._outboundConnections.size() == 1) {
            return this._outboundConnections.get(0);
        }
        if (type == null) {
            return null;
        }
        for (int i = 0; i < this._outboundConnections.size(); ++i) {
            ConnectionDefinition cfg = this._outboundConnections.get(i);
            Class cl = cfg.getManagedConnectionFactoryClass();
            if (cl != null && cl.getName().equals(type)) {
                return cfg;
            }
            cl = cfg.getConnectionFactoryInterface();
            if (cl != null && cl.getName().equals(type)) {
                return cfg;
            }
            cl = cfg.getConnectionFactoryImpl();
            if (cl == null || !cl.getName().equals(type)) continue;
            return cfg;
        }
        return null;
    }

    void addMessageListener(MessageListenerConfig cfg) throws ConfigException {
        if (this.getMessageListener(cfg.getMessageListenerType().getName()) != null) {
            throw new ConfigException(L.l("'{0}' is a duplicate messagelistener-type.  The <messagelistener-type> must be unique.", cfg.getMessageListenerType().getName()));
        }
        this._inboundConnections.add(cfg);
    }

    public MessageListenerConfig getMessageListener(String type) {
        if (type == null && this._inboundConnections.size() == 1) {
            return this._inboundConnections.get(0);
        }
        if (type == null) {
            return null;
        }
        for (int i = 0; i < this._inboundConnections.size(); ++i) {
            MessageListenerConfig cfg = this._inboundConnections.get(i);
            Class cl = cfg.getActivationSpecClass();
            if (cl == null || !cl.getName().equals(type)) continue;
            return cfg;
        }
        return null;
    }

    void addResource(AdminObjectConfig cfg) {
        this._resources.add(cfg);
    }

    public AdminObjectConfig getAdminObject(String type) {
        for (int i = 0; i < this._resources.size(); ++i) {
            AdminObjectConfig cfg = this._resources.get(i);
            Class cl = cfg.getAdminObjectClass();
            if (cl != null && cl.getName().equals(type)) {
                return cfg;
            }
            cl = cfg.getAdminObjectInterface();
            if (cl == null || !cl.getName().equals(type)) continue;
            return cfg;
        }
        return null;
    }

    public void setTransactionSupport(String xa) {
        this._transactionSupport = xa;
    }

    public String getTransactionSupport() {
        return this._transactionSupport;
    }

    public void setReauthenticationSupport(boolean support) {
    }

    public AuthenticationMechanism createAuthenticationMechanism() {
        return new AuthenticationMechanism();
    }

    public SecurityPermission createSecurityPermission() {
        return new SecurityPermission();
    }

    public OutboundResourceAdapterConfig createOutboundResourceadapter() throws ConfigException {
        return new OutboundResourceAdapterConfig(this);
    }

    public InboundResourceAdapterConfig createInboundResourceadapter() throws ConfigException {
        return new InboundResourceAdapterConfig(this);
    }

    public static class SecurityPermission {
        public void setDescription(String description) {
        }

        public void setSecurityPermissionSpec(String spec) {
        }
    }

    public static class AuthenticationMechanism {
        public void setDescription(String description) {
        }

        public void setAuthenticationMechanismType(String type) {
        }

        public void setCredentialInterface(String type) {
        }
    }
}

