/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.ra;

import com.caucho.config.inject.InjectManager;
import com.caucho.jca.ra.ResourceArchive;
import com.caucho.jca.ra.ResourceManagerImpl;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.StartLifecycleException;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import javax.enterprise.inject.spi.Bean;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAdapterController
implements EnvironmentListener {
    private InjectManager _beanManager;
    private final Bean<ResourceAdapter> _comp;
    private final ResourceArchive _raConfig;
    private Lifecycle _lifecycle = new Lifecycle();
    private ResourceAdapter _ra;

    public ResourceAdapterController(Bean<ResourceAdapter> comp, ResourceArchive raConfig) {
        this._beanManager = InjectManager.create();
        this._comp = comp;
        this._raConfig = raConfig;
        Environment.addEnvironmentListener(this);
    }

    public ResourceAdapter getResourceAdapter() {
        this.start();
        return this._ra;
    }

    private void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        if (this._ra != null) {
            return;
        }
        this._ra = this._beanManager.getReference(this._comp);
        try {
            this._ra.start((BootstrapContext)ResourceManagerImpl.create());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StartLifecycleException(e);
        }
    }

    private void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        try {
            ResourceAdapter ra = this._ra;
            if (ra != null) {
                ra.stop();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StartLifecycleException(e);
        }
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) throws StartLifecycleException {
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) throws StartLifecycleException {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) throws StartLifecycleException {
        this.start();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._comp + "]";
    }
}

