/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.ra;

import com.caucho.config.ConfigException;
import com.caucho.env.deploy.DeployMode;
import com.caucho.jca.cfg.ResourceConfig;
import com.caucho.jca.ra.ResourceArchive;
import com.caucho.jca.ra.ResourceArchiveManager;
import com.caucho.jca.ra.ResourceDefault;
import com.caucho.jca.ra.ResourceDeployAdmin;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDeploy {
    private static final L10N L = new L10N(ResourceDeploy.class);
    private final ResourceDeployAdmin _admin = new ResourceDeployAdmin(this);
    private ClassLoader _classLoader;
    private Path _containerRootDirectory;
    private Path _rarDir;
    private Path _rarExpandDir;
    private String _expandPrefix = "";
    private HashSet<String> _rarNames = new HashSet();
    private volatile boolean _isInit;

    public ResourceDeploy() {
        this._classLoader = Thread.currentThread().getContextClassLoader();
        this.setExpandPrefix("_rar_");
        this._containerRootDirectory = Vfs.getPwd();
    }

    Path getContainerRootDirectory() {
        return this._containerRootDirectory;
    }

    public Path getPath() {
        return this._rarDir;
    }

    public void setPath(Path path) {
        this._rarDir = path;
    }

    public Path getArchiveDirectory() {
        return this.getPath();
    }

    public Path getArchivePath(String name) {
        return this.getArchiveDirectory().lookup(name + this.getExtension());
    }

    protected String getExpandName(String name) {
        return this.getExpandPrefix() + name + this.getExpandSuffix();
    }

    public void setExpandPath(Path path) {
        this._rarExpandDir = path;
    }

    public Path getExpandPath() {
        return this.getExpandDirectory();
    }

    public Path getExpandDirectory() {
        if (this._rarExpandDir != null) {
            return this._rarExpandDir;
        }
        return this._rarDir;
    }

    public Path getExpandPath(String name) {
        if (!this.isDeployedKey(name)) {
            return null;
        }
        return this.getExpandDirectory().lookup(this.getExpandName(name));
    }

    private boolean isDeployedKey(String name) {
        return this._rarNames.contains(name);
    }

    public String getExpandPrefix() {
        return this._expandPrefix;
    }

    public void setExpandPrefix(String prefix) {
        this._expandPrefix = prefix;
    }

    public boolean isModified() {
        try {
            return !this._rarNames.equals(this.getRarNames());
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws ConfigException {
        ResourceDeploy resourceDeploy = this;
        synchronized (resourceDeploy) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
        }
        if (this.getPath() == null) {
            throw new ConfigException(L.l("resource-deploy requires a path attribute"));
        }
        this.deployResources();
        this._admin.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployResources() {
        HashSet<String> oldNames = this._rarNames;
        try {
            this._rarNames = this.getRarNames();
            for (String oldName : oldNames) {
                if (this._rarNames.contains(oldName)) continue;
                this.undeployResource(oldName);
            }
            for (String name : this._rarNames) {
                Object var9_10;
                if (oldNames.contains(name)) continue;
                ResourceArchive rar = new ResourceArchive();
                rar.setRarPath(this.getPath().lookup(name + ".rar"));
                rar.setRootDirectory(this.getExpandPath().lookup(this.getExpandPrefix() + name));
                Path oldPwd = Vfs.getPwd();
                try {
                    Vfs.setPwd(rar.getRootDirectory());
                    for (ResourceConfig config : ResourceDefault.getDefaultList()) {
                        config.getBuilderProgram().configure(rar);
                    }
                    var9_10 = null;
                }
                catch (Throwable throwable) {
                    var9_10 = null;
                    Vfs.setPwd(oldPwd);
                    throw throwable;
                }
                Vfs.setPwd(oldPwd);
                rar.init();
                ResourceArchiveManager.addResourceArchive(rar);
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private void undeployResource(String name) {
        ResourceArchiveManager.removeResourceArchive(name);
    }

    private HashSet<String> getRarNames() throws IOException {
        HashSet<String> rarNames = new HashSet<String>();
        Path rarDir = this.getPath();
        Path rarExpandDir = this.getExpandPath();
        if (rarDir == null || rarExpandDir == null) {
            return rarNames;
        }
        String[] rarDirList = rarDir.list();
        for (int i = 0; i < rarDirList.length; ++i) {
            Path path;
            String rarName = rarDirList[i];
            if (!rarName.endsWith(".rar") || !(path = rarDir.lookup(rarName)).canRead()) continue;
            String appName = rarName.substring(0, rarName.length() - 4);
            if (CauchoSystem.isCaseInsensitive()) {
                appName = appName.toLowerCase();
            }
            rarNames.add(appName);
        }
        String[] rarExpandList = rarExpandDir.list();
        ArrayList<String> newNames = new ArrayList<String>();
        for (int i = 0; i < rarExpandList.length; ++i) {
            Path path;
            String rarDirName = rarExpandList[i];
            if (!rarDirName.startsWith(this.getExpandPrefix())) continue;
            if (CauchoSystem.isCaseInsensitive()) {
                rarDirName = rarDirName.toLowerCase();
            }
            if (!(path = rarExpandDir.lookup(rarDirName)).isDirectory() || !rarDirName.startsWith(this.getExpandPrefix())) continue;
            String appName = rarDirName.substring(this.getExpandPrefix().length());
            if (!newNames.contains(appName)) {
                newNames.add(appName);
            }
            rarNames.add(appName);
        }
        return rarNames;
    }

    public String getExtension() {
        return ".rar";
    }

    public String getExpandSuffix() {
        return "";
    }

    public long getDependencyCheckInterval() {
        return -1L;
    }

    public DeployMode getStartupMode() {
        return DeployMode.AUTOMATIC;
    }

    public DeployMode getRedeployMode() {
        return DeployMode.MANUAL;
    }

    public String getState() {
        if (!this._isInit) {
            return LifecycleState.NEW.toString();
        }
        return LifecycleState.ACTIVE.toString();
    }

    public void start() {
    }

    public Throwable getConfigException() {
        return null;
    }

    public void stop() {
    }

    public void update() {
    }

    public String[] getNames() {
        return new String[0];
    }

    public void stop(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String name) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            this.deployResources();
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public Throwable getConfigException(String moduleID) {
        return null;
    }

    public void undeploy(String name) {
    }
}

