/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.event;

import com.caucho.jms.memory.MemorySubscriberQueue;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.AbstractTopic;
import com.caucho.jms.queue.MessageException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTopic<E>
extends AbstractTopic<E> {
    private static final Logger log = Logger.getLogger(EventTopic.class.getName());
    private ArrayList<AbstractQueue> _subscriptionList = new ArrayList();
    private int _id;

    @Override
    public String getUrl() {
        return "event:name=" + this.getName();
    }

    @Override
    public AbstractQueue<E> createSubscriber(Object publisher, String name, boolean noLocal) {
        MemorySubscriberQueue queue;
        if (name != null) {
            queue = new MemorySubscriberQueue(publisher, noLocal);
            queue.setName(this.getName() + ":sub-" + name);
            this._subscriptionList.add(queue);
        } else {
            queue = new MemorySubscriberQueue(publisher, noLocal);
            queue.setName(this.getName() + ":sub-" + this._id++);
            this._subscriptionList.add(queue);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " create-subscriber(" + queue + ")");
        }
        return queue;
    }

    @Override
    public void closeSubscriber(AbstractQueue queue) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " close-subscriber(" + queue + ")");
        }
        this._subscriptionList.remove(queue);
    }

    @Override
    public void send(String msgId, E payload, int priority, long timeout, Object publisher) throws MessageException {
        for (int i = 0; i < this._subscriptionList.size(); ++i) {
            this._subscriptionList.get(i).send(msgId, payload, priority, timeout, publisher);
        }
    }
}

