/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.file;

import com.caucho.jms.file.FileTopicImpl;
import com.caucho.jms.memory.MemoryQueueImpl;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSubscriberQueue<E>
extends MemoryQueueImpl<E> {
    private static final Logger log = Logger.getLogger(FileSubscriberQueue.class.getName());
    private FileTopicImpl<E> _topic;
    private Object _publisher;
    private boolean _isNoLocal;

    FileSubscriberQueue(FileTopicImpl<E> topic, Object publisher, boolean noLocal) {
        this._topic = topic;
        this._publisher = publisher;
        this._isNoLocal = noLocal;
    }

    @Override
    public void send(String msgId, E msg, int priority, long timeout, Object publisher) {
        if (this._isNoLocal && this._publisher == publisher) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " send message " + msg);
        }
        super.send(msgId, msg, priority, timeout);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._topic.getName() + "]";
    }
}

