/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.memory;

import com.caucho.jms.memory.MemorySubscriberQueue;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.AbstractTopic;
import com.caucho.jms.queue.MessageException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryTopicImpl<E>
extends AbstractTopic<E> {
    private static final Logger log = Logger.getLogger(MemoryTopicImpl.class.getName());
    private HashMap<String, AbstractQueue<E>> _durableSubscriptionMap = new HashMap();
    private ArrayList<AbstractQueue<E>> _subscriptionList = new ArrayList();
    private int _id;

    @Override
    public String getUrl() {
        return "memory:name=" + this.getName();
    }

    @Override
    public void send(String msgId, E payload, int priority, long timeout, Object publisher) throws MessageException {
        for (int i = 0; i < this._subscriptionList.size(); ++i) {
            this._subscriptionList.get(i).send(msgId, payload, priority, timeout, publisher);
        }
    }

    @Override
    public AbstractQueue<E> createSubscriber(Object publisher, String name, boolean noLocal) {
        AbstractQueue<E> queue;
        if (name != null) {
            queue = this._durableSubscriptionMap.get(name);
            if (queue == null) {
                queue = new MemorySubscriberQueue(publisher, noLocal);
                queue.setName(this.getName() + ":sub-" + name);
                this._subscriptionList.add(queue);
                this._durableSubscriptionMap.put(name, queue);
            }
        } else {
            queue = new MemorySubscriberQueue(publisher, noLocal);
            queue.setName(this.getName() + ":sub-" + this._id++);
            this._subscriptionList.add(queue);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " create-subscriber(" + queue + ")");
        }
        return queue;
    }

    @Override
    public void closeSubscriber(AbstractQueue<E> queue) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " close-subscriber(" + queue + ")");
        }
        if (!this._durableSubscriptionMap.values().contains(queue)) {
            this._subscriptionList.remove(queue);
        }
    }
}

