/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.queue;

import com.caucho.config.Configurable;
import com.caucho.config.inject.HandleAware;
import com.caucho.jms.queue.DestinationHandle;
import com.caucho.jms.queue.MessageException;
import com.caucho.util.Alarm;
import com.caucho.util.Base64;
import com.caucho.util.RandomUtil;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Destination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDestination<E>
extends AbstractQueue<E>
implements Destination,
BlockingQueue<E>,
Serializable,
HandleAware {
    private static long _idRandom;
    private static final AtomicLong _idCount;
    private String _name = "default";
    private Object _serializationHandle;

    protected AbstractDestination() {
        if (_idRandom == 0L || Alarm.isTest()) {
            _idCount.set(Alarm.getCurrentTime() << 16);
            _idRandom = RandomUtil.getRandomLong();
        }
    }

    @Configurable
    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getQueueName() {
        return this.getName();
    }

    public String getTopicName() {
        return this.getName();
    }

    @Override
    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    public String getUrl() {
        return this.getClass().getSimpleName() + ":";
    }

    public final String generateMessageID() {
        StringBuilder cb = new StringBuilder();
        cb.append("ID:");
        this.generateMessageID(cb);
        return cb.toString();
    }

    protected void generateMessageID(StringBuilder cb) {
        long id = _idCount.getAndIncrement();
        Base64.encode(cb, _idRandom);
        Base64.encode(cb, id);
    }

    public abstract void send(String var1, E var2, int var3, long var4) throws MessageException;

    public void send(String msgId, E msg, int priority, long expires, Object publisher) throws MessageException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public E receive(long timeout) throws MessageException {
        return null;
    }

    public boolean hasMessage() {
        return false;
    }

    public void acknowledge(String msgId) {
    }

    public void rollback(String msgId) {
    }

    public Destination getJMSDestination() {
        return new DestinationHandle(this.toString());
    }

    private Object writeReplace() {
        return this._serializationHandle;
    }

    public void close() {
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    static {
        _idCount = new AtomicLong();
    }
}

