/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.queue;

import com.caucho.env.thread.ThreadPool;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.EntryCallback;
import com.caucho.jms.queue.MessageCallback;
import com.caucho.jms.queue.MessageException;
import com.caucho.jms.queue.QueueEntry;
import com.caucho.jms.queue.QueueEntrySelector;
import com.caucho.util.Alarm;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMemoryQueue<E, QE extends QueueEntry<E>>
extends AbstractQueue<E> {
    private static final Logger log = Logger.getLogger(AbstractMemoryQueue.class.getName());
    private int _queueSizeMax = 0x3FFFFFFF;
    private final Object _queueLock = new Object();
    private ArrayList<EntryCallback<E>> _callbackList = new ArrayList();
    private QE[] _head = new QueueEntry[10];
    private QE[] _tail = new QueueEntry[10];
    private ThreadPool _threadPool = ThreadPool.getThreadPool();
    private final AtomicLong _readSequenceGenerator = new AtomicLong();
    private final AtomicInteger _queueSize = new AtomicInteger();
    private final AtomicBoolean _isQueueThrottle = new AtomicBoolean();
    private AtomicInteger _receiverCount = new AtomicInteger();
    private AtomicInteger _listenerCount = new AtomicInteger();

    public void setQueueSizeMax(int max) {
        this._queueSizeMax = max <= 0 || 0x3FFFFFFF < max ? 0x3FFFFFFF : max;
    }

    public int getQueueSizeMax() {
        return this._queueSizeMax;
    }

    @Override
    public void send(String msgId, E payload, int priority, long expireTime) throws MessageException {
        QE entry = this.writeEntry(msgId, payload, priority, expireTime);
        this.addQueueEntry(entry, expireTime);
    }

    protected abstract QE writeEntry(String var1, E var2, int var3, long var4);

    protected void addQueueEntry(QE entry, long expires) {
        this.addEntry(entry, expires);
        this.dispatchMessage();
    }

    public QE receiveEntry(long expireTime, boolean isAutoAck) throws MessageException {
        return this.receiveEntry(expireTime, isAutoAck, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QE receiveEntry(long expireTime, boolean isAutoAck, QueueEntrySelector selector) throws MessageException {
        block10: {
            Object object;
            block9: {
                this._receiverCount.incrementAndGet();
                try {
                    QueueEntry entry = null;
                    object = this._queueLock;
                    synchronized (object) {
                        if (this._callbackList.size() == 0) {
                            entry = (QueueEntry)this.readEntry(selector);
                        }
                    }
                    if (entry == null) break block9;
                    this.readPayload(entry);
                    if (isAutoAck) {
                        this.acknowledge(entry.getMsgId());
                    }
                    object = entry;
                    Object var9_8 = null;
                    this._receiverCount.decrementAndGet();
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    this._receiverCount.decrementAndGet();
                    throw throwable;
                }
                return (QE)object;
            }
            if (expireTime > Alarm.getCurrentTimeActual()) break block10;
            object = null;
            Object var9_9 = null;
            this._receiverCount.decrementAndGet();
            return (QE)object;
        }
        ReceiveEntryCallback callback = new ReceiveEntryCallback(isAutoAck);
        QueueEntry queueEntry = callback.waitForEntry(expireTime);
        Object var9_10 = null;
        this._receiverCount.decrementAndGet();
        return (QE)queueEntry;
    }

    @Override
    public EntryCallback<E> addMessageCallback(MessageCallback<E> callback, boolean isAutoAck) {
        this._listenerCount.incrementAndGet();
        ListenEntryCallback entryCallback = new ListenEntryCallback(callback, isAutoAck);
        this.listen(entryCallback);
        return entryCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageCallback(EntryCallback<E> callback) {
        ListenEntryCallback listenerCallback = (ListenEntryCallback)callback;
        listenerCallback.close();
        Object object = this._queueLock;
        synchronized (object) {
            this._callbackList.remove(listenerCallback);
        }
        this._listenerCount.decrementAndGet();
    }

    protected void acknowledge(QE entry) {
    }

    protected void readPayload(QE entry) {
    }

    public void removeMessageCallback(MessageCallback callback) {
    }

    @Override
    public void acknowledge(String msgId) {
        QE entry = this.removeEntry(msgId);
        if (entry != null) {
            this.acknowledge(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listen(EntryCallback<E> callback) throws MessageException {
        QueueEntry entry;
        block8: {
            entry = null;
            Object object = this._queueLock;
            synchronized (object) {
                block7: {
                    if (this._callbackList.size() > 0) break block7;
                    QE QE = this.readEntry();
                    entry = (QueueEntry)QE;
                    if (QE != null) break block8;
                }
                this._callbackList.add(callback);
                return false;
            }
        }
        this.readPayload(entry);
        if (callback.entryReceived(entry)) {
            this.acknowledge(entry.getMsgId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchMessage() {
        while (true) {
            QueueEntry entry = null;
            EntryCallback<E> callback = null;
            Object object = this._queueLock;
            synchronized (object) {
                block7: {
                    block6: {
                        if (this._callbackList.size() == 0) break block6;
                        QE QE = this.readEntry();
                        entry = (QueueEntry)QE;
                        if (QE != null) break block7;
                    }
                    return;
                }
                callback = this._callbackList.remove(0);
            }
            this.readPayload(entry);
            if (!callback.entryReceived(entry)) continue;
            this.acknowledge(entry.getMsgId());
        }
    }

    @Override
    public int getQueueSize() {
        int count = 0;
        for (int i = 0; i < this._head.length; ++i) {
            Object entry = this._head[i];
            while (entry != null) {
                ++count;
                entry = ((QueueEntry)entry)._next;
            }
        }
        return count;
    }

    @Override
    public boolean hasMessage() {
        return this.getQueueSize() > 0;
    }

    @Override
    public int getConsumerCount() {
        return this._listenerCount.get();
    }

    @Override
    public int getReceiverCount() {
        return this._receiverCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QE addEntry(QE entry, long expires) {
        int priority = ((QueueEntry)entry).getPriority();
        Object object = this._queueLock;
        synchronized (object) {
            if (this._tail[priority] != null) {
                ((QueueEntry)this._tail[priority])._next = entry;
            } else {
                this._head[priority] = entry;
            }
            this._tail[priority] = entry;
        }
        int size = this._queueSize.incrementAndGet();
        if (this._queueSizeMax < size) {
            long timeout = 100L;
            this.waitForQueueThrottle(timeout);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueueThrottle(long timeout) {
        this._isQueueThrottle.set(true);
        AtomicBoolean atomicBoolean = this._isQueueThrottle;
        synchronized (atomicBoolean) {
            try {
                if (this._isQueueThrottle.get()) {
                    if (timeout > 1000L) {
                        timeout = 1000L;
                    }
                    if (timeout > 0L) {
                        this._isQueueThrottle.wait(timeout);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeQueueThrottle() {
        int size = this._queueSize.get();
        if (size <= this._queueSizeMax && this._isQueueThrottle.compareAndSet(true, false)) {
            AtomicBoolean atomicBoolean = this._isQueueThrottle;
            synchronized (atomicBoolean) {
                this._isQueueThrottle.notifyAll();
            }
        }
    }

    protected QE readEntry() {
        return this.readEntry(null);
    }

    protected QE readEntry(QueueEntrySelector selector) {
        for (int i = this._head.length - 1; i >= 0; --i) {
            Object entry = this._head[i];
            while (entry != null) {
                if (((QueueEntry)entry).isLease() && !((QueueEntry)entry).isRead()) {
                    this.readPayload(entry);
                    if (selector == null || selector.isMatch(entry)) {
                        ((QueueEntry)entry).setReadSequence(this._readSequenceGenerator.incrementAndGet());
                        return (QE)entry;
                    }
                }
                entry = ((QueueEntry)entry)._next;
            }
        }
        return null;
    }

    @Override
    public ArrayList<QE> getBrowserList() {
        ArrayList<QE> entries = new ArrayList<QE>();
        for (int i = this._head.length - 1; i >= 0; --i) {
            Object entry = this._head[i];
            while (entry != null) {
                if (((QueueEntry)entry).isLease() && !((QueueEntry)entry).isRead()) {
                    this.readPayload(entry);
                    entries.add(entry);
                }
                entry = ((QueueEntry)entry)._next;
            }
        }
        return entries.size() > 0 ? entries : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QE removeEntry(String msgId) {
        Object object = this._queueLock;
        synchronized (object) {
            for (int i = this._head.length - 1; i >= 0; --i) {
                Object prev = null;
                Object entry = this._head[i];
                while (entry != null) {
                    QueueEntry next = ((QueueEntry)entry)._next;
                    if (msgId.equals(((QueueEntry)entry).getMsgId())) {
                        if (prev != null) {
                            prev._next = ((QueueEntry)entry)._next;
                        } else {
                            this._head[i] = ((QueueEntry)entry)._next;
                        }
                        if (this._tail[i] == entry) {
                            this._tail[i] = prev;
                        }
                        this._queueSize.decrementAndGet();
                        if (this._isQueueThrottle.get()) {
                            this.wakeQueueThrottle();
                        }
                        return entry;
                    }
                    prev = entry;
                    entry = next;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(String msgId) {
        Object object = this._queueLock;
        synchronized (object) {
            for (int i = this._head.length - 1; i >= 0; --i) {
                Object entry = this._head[i];
                while (entry != null) {
                    if (msgId.equals(((QueueEntry)entry).getMsgId())) {
                        if (((QueueEntry)entry).isRead()) {
                            ((QueueEntry)entry).setReadSequence(0L);
                        }
                        return;
                    }
                    entry = ((QueueEntry)entry)._next;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getMessageIds() {
        ArrayList<String> browserList = new ArrayList<String>();
        Object object = this._queueLock;
        synchronized (object) {
            for (int i = 0; i < this._head.length; ++i) {
                Object entry = this._head[i];
                while (entry != null) {
                    browserList.add(((QueueEntry)entry).getMsgId());
                    entry = ((QueueEntry)entry)._next;
                }
            }
        }
        return browserList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListenEntryCallback
    implements EntryCallback<E>,
    Runnable {
        private MessageCallback<E> _callback;
        private ClassLoader _classLoader;
        private boolean _isClosed;
        private volatile QueueEntry<E> _entry;

        ListenEntryCallback(MessageCallback<E> callback, boolean isAutoAck) {
            this._callback = callback;
            this._classLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public boolean entryReceived(QueueEntry<E> entry) {
            this._entry = entry;
            AbstractMemoryQueue.this._threadPool.schedule(this);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isValid;
            block10: {
                Thread thread = Thread.currentThread();
                ClassLoader oldLoader = thread.getContextClassLoader();
                isValid = false;
                long readSequence = this._entry.getReadSequence();
                try {
                    try {
                        thread.setContextClassLoader(this._classLoader);
                        this._callback.messageReceived(this._entry.getMsgId(), this._entry.getPayload());
                        isValid = true;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                        isValid = true;
                        Object var8_6 = null;
                        thread.setContextClassLoader(oldLoader);
                        if (readSequence == this._entry.getReadSequence()) {
                            AbstractMemoryQueue.this.acknowledge(this._entry.getMsgId());
                        }
                        break block10;
                    }
                    catch (Throwable t) {
                        log.log(Level.SEVERE, t.toString(), t);
                        Object var8_7 = null;
                        thread.setContextClassLoader(oldLoader);
                        if (readSequence == this._entry.getReadSequence()) {
                            AbstractMemoryQueue.this.acknowledge(this._entry.getMsgId());
                        }
                    }
                    Object var8_5 = null;
                    thread.setContextClassLoader(oldLoader);
                    if (readSequence == this._entry.getReadSequence()) {
                        AbstractMemoryQueue.this.acknowledge(this._entry.getMsgId());
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    thread.setContextClassLoader(oldLoader);
                    if (readSequence == this._entry.getReadSequence()) {
                        AbstractMemoryQueue.this.acknowledge(this._entry.getMsgId());
                    }
                    throw throwable;
                }
            }
            if (!this._isClosed && isValid) {
                AbstractMemoryQueue.this.listen(this);
            }
        }

        public void close() {
            this._isClosed = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReceiveEntryCallback
    implements EntryCallback<E> {
        private boolean _isAutoAck;
        private Thread _thread;
        private volatile QueueEntry<E> _entry;

        ReceiveEntryCallback(boolean isAutoAck) {
            this._isAutoAck = isAutoAck;
            this._thread = Thread.currentThread();
        }

        @Override
        public boolean entryReceived(QueueEntry<E> entry) {
            this._entry = entry;
            LockSupport.unpark(this._thread);
            return this._isAutoAck;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueueEntry<E> waitForEntry(long expireTime) {
            AbstractMemoryQueue.this.listen(this);
            while (this._entry == null && Alarm.getCurrentTimeActual() < expireTime) {
                LockSupport.parkUntil(expireTime);
            }
            if (this._entry == null) {
                Object object = AbstractMemoryQueue.this._queueLock;
                synchronized (object) {
                    AbstractMemoryQueue.this._callbackList.remove(this);
                }
            }
            return this._entry;
        }
    }
}

