/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.queue;

import com.caucho.jms.queue.AbstractDestination;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.MessageException;
import com.caucho.jms.queue.TopicAdmin;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTopic<E>
extends AbstractDestination<E>
implements Topic {
    private static final L10N L = new L10N(AbstractTopic.class);
    private TopicAdmin _admin;

    public void setTopicName(String name) {
        this.setName(name);
    }

    protected void init() {
    }

    @PostConstruct
    public void postConstruct() {
        this.init();
        this._admin = new TopicAdmin(this);
        this._admin.register();
    }

    @Override
    public void send(String msgId, E msg, int priority, long expires) throws MessageException {
        this.send(msgId, msg, priority, expires, null);
    }

    @Override
    public E receive(long timeout) {
        throw new IllegalStateException(L.l("topic cannot be used directly for receive."));
    }

    public abstract AbstractQueue<E> createSubscriber(Object var1, String var2, boolean var3);

    public abstract void closeSubscriber(AbstractQueue<E> var1);

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean offer(E value, long timeout, TimeUnit unit) {
        int priority = 0;
        timeout = unit.toMillis(timeout);
        long expires = Alarm.getCurrentTime() + timeout;
        this.send(this.generateMessageID(), value, priority, expires);
        return true;
    }

    @Override
    public boolean offer(E value) {
        return this.offer(value, 0L, TimeUnit.SECONDS);
    }

    @Override
    public void put(E value) {
        this.offer(value, Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) {
        long msTimeout = unit.toMillis(timeout);
        E payload = this.receive(msTimeout);
        try {
            if (payload == null) {
                return null;
            }
            if (payload instanceof ObjectMessage) {
                return (E)((ObjectMessage)payload).getObject();
            }
            if (payload instanceof TextMessage) {
                return (E)((TextMessage)payload).getText();
            }
            if (payload instanceof Serializable) {
                return payload;
            }
            throw new MessageException(L.l("'{0}' is an unsupported message for the BlockingQueue API.", payload));
        }
        catch (JMSException e) {
            throw new MessageException(e);
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public E poll() {
        return this.poll(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public E take() {
        return this.poll(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public int drainTo(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection c, int max) {
        throw new UnsupportedOperationException();
    }
}

