/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.queue;

import com.caucho.util.Alarm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueueEntry<M> {
    private final int _priority;
    private final long _leaseExpire;
    private final String _msgId;
    QueueEntry<M> _next;
    QueueEntry<M> _nextPriority;
    private long _expiresTime;
    private M _payload;
    private long _readSequence;

    public QueueEntry(String msgId, long leaseTimeout, int priority, long expiresTime) {
        if (msgId == null) {
            throw new NullPointerException();
        }
        this._msgId = msgId;
        this._leaseExpire = leaseTimeout + Alarm.getCurrentTime();
        this._expiresTime = expiresTime;
        this._priority = priority;
    }

    public String getMsgId() {
        return this._msgId;
    }

    public long getLeaseExpires() {
        return this._leaseExpire;
    }

    public long getExpiresTime() {
        return this._expiresTime;
    }

    public boolean isLease() {
        return this._leaseExpire < Alarm.getCurrentTime();
    }

    public boolean isRead() {
        return this._readSequence != 0L;
    }

    public boolean isExpired() {
        return this._expiresTime < Alarm.getCurrentTime();
    }

    public long getReadSequence() {
        return this._readSequence;
    }

    public void setReadSequence(long readSequence) {
        this._readSequence = readSequence;
    }

    public void rollback() {
    }

    public int getPriority() {
        return this._priority;
    }

    public M readPayload() {
        return this.getPayload();
    }

    public final M getPayload() {
        return this._payload;
    }

    public final void setPayload(M payload) {
        this._payload = payload;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._msgId + ",pri=" + this._priority + "]";
    }
}

