/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.Selector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;

public class OrSelector
extends Selector {
    private Selector _left;
    private Selector _right;

    OrSelector(Selector left, Selector right) throws JMSException {
        this._left = left;
        this._right = right;
        if (!this._left.isUnknown() && !this._left.isBoolean()) {
            throw new InvalidSelectorException(L.l("'{0}' must have a numeric value for comparison.", this));
        }
        if (!this._right.isUnknown() && !this._right.isBoolean()) {
            throw new InvalidSelectorException(L.l("'{0}' must have a numeric value for comparison.", this));
        }
    }

    boolean isBoolean() {
        return true;
    }

    boolean isUnknown() {
        return false;
    }

    public Object evaluate(Message message) throws JMSException {
        Object lvalue = this._left.evaluate(message);
        if (lvalue instanceof Boolean && ((Boolean)lvalue).booleanValue()) {
            return Boolean.TRUE;
        }
        Object rvalue = this._right.evaluate(message);
        if (rvalue == null) {
            return NULL;
        }
        if (rvalue instanceof Boolean && ((Boolean)rvalue).booleanValue()) {
            return Boolean.TRUE;
        }
        if (lvalue instanceof Boolean || rvalue instanceof Boolean) {
            return Boolean.FALSE;
        }
        return NULL;
    }

    public String toString() {
        return this._left + " OR " + this._right;
    }
}

