/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmtp;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.bam.ProtocolException;
import com.caucho.json.JsonOutput;
import com.caucho.util.Utf8;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmtpWriter
implements ActorStream {
    private static final Logger log = Logger.getLogger(JmtpWriter.class.getName());
    private String _jid;
    private OutputStream _os;
    private JsonOutput _out;

    public JmtpWriter() {
    }

    public JmtpWriter(OutputStream os) {
        this.init(os);
    }

    public void init(OutputStream os) {
        this._os = os;
        this._out = new JsonOutput(this._os);
    }

    public String getJid() {
        return this._jid;
    }

    public void setJid(String jid) {
        this._jid = jid;
    }

    public void message(String to, String from, Serializable value) {
        try {
            OutputStream os = this._os;
            JsonOutput out = this._out;
            if (out != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " message " + value + " {to:" + to + ", from:" + from + "}");
                }
                os.write(0);
                this.writeString(os, "message\n");
                this.writeString(os, to);
                os.write(10);
                this.writeString(os, from);
                os.write(10);
                this.writeType(os, value);
                out.writeObject(value);
                out.flushBuffer();
                os.write(255);
                os.flush();
            }
        }
        catch (IOException e) {
            this.close();
            throw new ProtocolException(e);
        }
    }

    public void messageError(String to, String from, Serializable value, ActorError error) {
        try {
            OutputStream os = this._os;
            JsonOutput out = this._out;
            if (out != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " messageError " + value + " {to:" + to + ", from:" + from + "}");
                }
                os.write(0);
                this.writeString(os, "message_error\n");
                this.writeString(os, to);
                os.write(10);
                this.writeString(os, from);
                os.write(10);
                this.writeType(os, value);
                out.writeObject(value);
                out.flushBuffer();
                os.write(10);
                out.writeObject(error);
                out.flushBuffer();
                os.write(10);
                os.write(255);
                os.flush();
            }
        }
        catch (IOException e) {
            this.close();
            throw new ProtocolException(e);
        }
    }

    public void queryGet(long id, String to, String from, Serializable value) {
        try {
            OutputStream os = this._os;
            JsonOutput out = this._out;
            if (out != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryGet " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
                }
                os.write(0);
                this.writeString(os, "get\n");
                this.writeString(os, to);
                os.write(10);
                this.writeString(os, from);
                os.write(10);
                this.writeType(os, value);
                this.writeString(os, String.valueOf(id));
                os.write(10);
                out.writeObject(value);
                out.flushBuffer();
                os.write(255);
                os.flush();
            }
        }
        catch (IOException e) {
            this.close();
            throw new ProtocolException(e);
        }
    }

    public void querySet(long id, String to, String from, Serializable value) {
        try {
            OutputStream os = this._os;
            JsonOutput out = this._out;
            if (out != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " querySet " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
                }
                os.write(0);
                this.writeString(os, "set\n");
                this.writeString(os, to);
                os.write(10);
                this.writeString(os, from);
                os.write(10);
                this.writeType(os, value);
                this.writeString(os, String.valueOf(id));
                os.write(10);
                out.writeObject(value);
                out.flushBuffer();
                os.write(255);
                os.flush();
            }
        }
        catch (IOException e) {
            this.close();
            throw new ProtocolException(e);
        }
    }

    public void queryResult(long id, String to, String from, Serializable value) {
        try {
            OutputStream os = this._os;
            JsonOutput out = this._out;
            if (out != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryResult " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
                }
                os.write(0);
                this.writeString(os, "result\n");
                this.writeString(os, to);
                os.write(10);
                this.writeString(os, from);
                os.write(10);
                this.writeType(os, value);
                this.writeString(os, String.valueOf(id));
                os.write(10);
                out.writeObject(value);
                out.flushBuffer();
                os.write(255);
                os.flush();
            }
        }
        catch (IOException e) {
            this.close();
            throw new ProtocolException(e);
        }
    }

    public void queryError(long id, String to, String from, Serializable value, ActorError error) {
        try {
            OutputStream os = this._os;
            JsonOutput out = this._out;
            if (out != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryError " + error + " " + value + " {id: " + id + ", to:" + to + ", from:" + from + "}");
                }
                os.write(0);
                this.writeString(os, "query_error\n");
                this.writeString(os, to);
                os.write(10);
                this.writeString(os, from);
                os.write(10);
                this.writeType(os, value);
                this.writeString(os, String.valueOf(id));
                os.write(10);
                out.writeObject(value);
                out.flushBuffer();
                os.write(10);
                out.writeObject(error);
                out.flushBuffer();
                os.write(10);
                os.write(255);
                os.flush();
            }
        }
        catch (IOException e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    private void writeType(OutputStream os, Object value) throws IOException {
        if (value == null) {
            this.writeString(os, "null\n");
            return;
        }
        Class<?> cl = value.getClass();
        if (cl == String.class) {
            this.writeString(os, "String\n");
        } else if (cl.getName().startsWith("java.")) {
            this.writeString(os, "Object\n");
        } else {
            this.writeString(os, value.getClass().getName());
            os.write(10);
        }
    }

    private void writeString(OutputStream os, String s) throws IOException {
        Utf8.write(os, s);
    }

    public void flush() throws IOException {
        JsonOutput out = this._out;
        if (out != null) {
            out.flush();
        }
    }

    public boolean isClosed() {
        return this._out == null;
    }

    public void close() {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " close");
        }
        try {
            JsonOutput out = this._out;
            this._out = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getJid() + "]";
    }
}

