/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx.remote;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.jmx.JMXSerializerFactory;
import com.caucho.jmx.remote.RemoteJMX;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.IOExceptionWrapper;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class HessianMBeanServerConnection
implements MBeanServerConnection {
    private static final L10N L = new L10N(HessianMBeanServerConnection.class);
    private static final Logger log = Log.open(HessianMBeanServerConnection.class);
    private String _url;
    private RemoteJMX _jmxProxy;

    public HessianMBeanServerConnection() {
    }

    public HessianMBeanServerConnection(String url) {
        this._url = url;
    }

    public void setProxy(RemoteJMX proxy) {
        this._jmxProxy = proxy;
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        try {
            return this.getProxy().getMBeanInfo(objectName.getCanonicalName());
        }
        catch (JMException ex) {
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            if (ex instanceof IntrospectionException) {
                throw (IntrospectionException)ex;
            }
            if (ex instanceof ReflectionException) {
                throw (ReflectionException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public Object getAttribute(ObjectName objectName, String attrName) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        try {
            return this.getProxy().getAttribute(objectName.getCanonicalName(), attrName);
        }
        catch (JMException ex) {
            if (ex instanceof MBeanException) {
                throw (MBeanException)ex;
            }
            if (ex instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)ex;
            }
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            if (ex instanceof ReflectionException) {
                throw (ReflectionException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public String getDefaultDomain() throws IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public String[] getDomains() throws IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
        MBeanInfo info = null;
        try {
            info = this.getMBeanInfo(objectName);
        }
        catch (IntrospectionException e) {
            throw new IOExceptionWrapper(e);
        }
        catch (ReflectionException e) {
            throw new IOExceptionWrapper(e);
        }
        String className = info.getClassName();
        return new ObjectInstance(objectName, className);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public Set queryNames(ObjectName name, QueryExp query) throws IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public boolean isRegistered(ObjectName name) throws IOException {
        return true;
    }

    public Integer getMBeanCount() throws IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    private RemoteJMX getProxy() {
        if (this._jmxProxy == null) {
            try {
                HessianProxyFactory proxy = new HessianProxyFactory();
                proxy.getSerializerFactory().addFactory(new JMXSerializerFactory());
                this._jmxProxy = (RemoteJMX)proxy.create(this._url);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this._jmxProxy;
    }
}

