/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.cfg;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.jsf.application.ApplicationImpl;
import com.caucho.jsf.cfg.ResourceBundleConfig;
import com.caucho.util.L10N;
import com.caucho.util.LocaleUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationConfig {
    private static final Logger log = Logger.getLogger(ApplicationConfig.class.getName());
    private static final L10N L = new L10N(ApplicationConfig.class);
    private String _id;
    private Class _actionListener;
    private String _defaultRenderKitId;
    private String _messageBundle;
    private Class _navigationHandler;
    private Class _viewHandler;
    private Class _stateManager;
    private ArrayList<ELResolver> _elResolverList = new ArrayList();
    private Class _propertyResolver;
    private Class _variableResolver;
    private ArrayList<ResourceBundleConfig> _resourceBundleList = new ArrayList();
    private LocaleConfig _localeConfig;

    public void setId(String id) {
        this._id = id;
    }

    public void setDefaultRenderKitId(String id) {
        this._defaultRenderKitId = id;
    }

    public void setMessageBundle(String messageBundle) {
        this._messageBundle = messageBundle;
    }

    public void setActionListener(Class actionListener) throws ConfigException {
        Config.validate(actionListener, ActionListener.class, ActionListener.class);
        this._actionListener = actionListener;
    }

    public void setNavigationHandler(Class navigationHandler) throws ConfigException {
        if (!NavigationHandler.class.isAssignableFrom(navigationHandler)) {
            throw new ConfigException(L.l("navigation-handler '{0}' must extend javax.faces.application.NavigationHandler.", navigationHandler.getName()));
        }
        Constructor ctor = null;
        try {
            ctor = navigationHandler.getConstructor(NavigationHandler.class);
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        try {
            if (ctor == null) {
                ctor = navigationHandler.getConstructor(new Class[0]);
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        if (ctor == null) {
            throw new ConfigException(L.l("navigation-handler '{0}' must have either a zero-arg constructor or a constructor with a single NavigationHandler argument.", navigationHandler.getName()));
        }
        this._navigationHandler = navigationHandler;
    }

    public void setViewHandler(Class viewHandler) throws ConfigException {
        if (!ViewHandler.class.isAssignableFrom(viewHandler)) {
            throw new ConfigException(L.l("view-handler '{0}' must extend javax.faces.application.ViewHandler.", viewHandler.getName()));
        }
        Constructor ctor = null;
        try {
            ctor = viewHandler.getConstructor(ViewHandler.class);
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        try {
            if (ctor == null) {
                ctor = viewHandler.getConstructor(new Class[0]);
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        if (ctor == null) {
            throw new ConfigException(L.l("view-handler '{0}' must have either a zero-arg constructor or a constructor with a single ViewHandler argument.", viewHandler.getName()));
        }
        this._viewHandler = viewHandler;
    }

    public void setResourceHandler(Class resourceHandler) throws ConfigException {
    }

    public void setStateManager(Class stateManager) throws ConfigException {
        if (!StateManager.class.isAssignableFrom(stateManager)) {
            throw new ConfigException(L.l("state-manager '{0}' must extend javax.faces.application.StateManager.", stateManager.getName()));
        }
        Constructor ctor = null;
        try {
            ctor = stateManager.getConstructor(StateManager.class);
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        try {
            if (ctor == null) {
                ctor = stateManager.getConstructor(new Class[0]);
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        if (ctor == null) {
            throw new ConfigException(L.l("state-manager '{0}' must have either a zero-arg constructor or a constructor with a single StateManager argument.", stateManager.getName()));
        }
        this._stateManager = stateManager;
    }

    public Class getStateManager() {
        return this._stateManager;
    }

    public void setElResolver(Class elResolver) throws ConfigException {
        Config.validate(elResolver, ELResolver.class);
        try {
            this._elResolverList.add((ELResolver)elResolver.newInstance());
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public Class getElResolver() {
        return null;
    }

    public ArrayList<ELResolver> getElResolverList() {
        return this._elResolverList;
    }

    public void setPropertyResolver(Class propertyResolver) throws ConfigException {
        Config.validate(propertyResolver, PropertyResolver.class, PropertyResolver.class);
        this._propertyResolver = propertyResolver;
    }

    public Class getPropertyResolver() {
        return this._propertyResolver;
    }

    public void setVariableResolver(Class variableResolver) throws ConfigException {
        Config.validate(variableResolver, VariableResolver.class, VariableResolver.class);
        this._variableResolver = variableResolver;
    }

    public Class getVariableResolver() {
        return this._variableResolver;
    }

    public void setResourceBundle(ResourceBundleConfig bundle) throws ConfigException {
        this._resourceBundleList.add(bundle);
    }

    private ResourceBundleConfig getResourceBundle() throws ConfigException {
        return null;
    }

    public ArrayList<ResourceBundleConfig> getResourceBundleList() {
        return this._resourceBundleList;
    }

    public void setApplicationExtension(ConfigProgram program) {
    }

    public void setLocaleConfig(LocaleConfig config) {
        this._localeConfig = config;
    }

    public void configure(ApplicationImpl app) {
        ViewHandler oldHandler;
        ViewHandler handler;
        Constructor ctor;
        if (this._messageBundle != null) {
            app.setMessageBundle(this._messageBundle);
        }
        if (this._localeConfig != null) {
            this._localeConfig.configure(app);
        }
        if (this._defaultRenderKitId != null) {
            app.setDefaultRenderKitId(this._defaultRenderKitId);
        }
        if (this._actionListener != null) {
            ActionListener listener = null;
            try {
                ctor = this._actionListener.getConstructor(ActionListener.class);
                ActionListener oldListener = app.getActionListener();
                listener = (ActionListener)ctor.newInstance(oldListener);
            }
            catch (NoSuchMethodException e) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            if (listener == null) {
                try {
                    listener = (ActionListener)this._actionListener.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ConfigException.create(e);
                }
            }
            if (listener != null) {
                app.setActionListener(listener);
                log.fine(L.l("JSF[] using '{0}' as action-listener", listener));
            }
        }
        if (this._viewHandler != null) {
            handler = null;
            try {
                ctor = this._viewHandler.getConstructor(ViewHandler.class);
                oldHandler = app.getViewHandler();
                handler = (ViewHandler)ctor.newInstance(oldHandler);
            }
            catch (NoSuchMethodException e) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            if (handler == null) {
                try {
                    handler = (ViewHandler)this._viewHandler.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ConfigException.create(e);
                }
            }
            if (handler != null) {
                app.setViewHandler(handler);
                log.fine(L.l("JSF[] using '{0}' as view-handler", handler));
            }
        }
        if (this._navigationHandler != null) {
            handler = null;
            try {
                ctor = this._navigationHandler.getConstructor(NavigationHandler.class);
                oldHandler = app.getNavigationHandler();
                handler = (NavigationHandler)ctor.newInstance(oldHandler);
            }
            catch (NoSuchMethodException e) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            if (handler == null) {
                try {
                    handler = (NavigationHandler)this._navigationHandler.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ConfigException.create(e);
                }
            }
            if (handler != null) {
                app.setNavigationHandler((NavigationHandler)handler);
                log.fine(L.l("JSF[] using '{0}' as navigation-handler", handler));
            }
        }
        if (this._stateManager != null) {
            StateManager manager = null;
            try {
                ctor = this._stateManager.getConstructor(StateManager.class);
                oldHandler = app.getStateManager();
                manager = (StateManager)ctor.newInstance(oldHandler);
            }
            catch (NoSuchMethodException e) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            if (manager == null) {
                try {
                    manager = (StateManager)this._stateManager.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ConfigException.create(e);
                }
            }
            if (manager != null) {
                app.setStateManager(manager);
                log.fine(L.l("JSF[] using '{0}' as state-manager", manager));
            }
        }
        for (int i = 0; i < this._elResolverList.size(); ++i) {
            app.addELResolver(this._elResolverList.get(i));
        }
        if (this._propertyResolver != null) {
            PropertyResolver propertyResolver = null;
            try {
                ctor = this._propertyResolver.getConstructor(PropertyResolver.class);
                PropertyResolver oldPropertyResolver = app.getLegacyPropertyResolver();
                propertyResolver = (PropertyResolver)ctor.newInstance(oldPropertyResolver);
            }
            catch (NoSuchMethodException e) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            if (propertyResolver == null) {
                try {
                    propertyResolver = (PropertyResolver)this._propertyResolver.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ConfigException.create(e);
                }
            }
            if (propertyResolver != null) {
                app.setPropertyResolver(propertyResolver);
                log.fine(L.l("JSF[] using '{0}' as property-resolver", propertyResolver));
            }
        }
        if (this._variableResolver != null) {
            VariableResolver variableResolver = null;
            try {
                ctor = this._variableResolver.getConstructor(VariableResolver.class);
                VariableResolver oldVariableResolver = app.getLegacyVariableResolver();
                variableResolver = (VariableResolver)ctor.newInstance(oldVariableResolver);
            }
            catch (NoSuchMethodException e) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            if (variableResolver == null) {
                try {
                    variableResolver = (VariableResolver)this._variableResolver.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ConfigException.create(e);
                }
            }
            if (variableResolver != null) {
                app.setVariableResolver(variableResolver);
                log.fine(L.l("JSF[] using '{0}' as variable-resolver", variableResolver));
            }
        }
    }

    public static class LocaleConfig {
        private Locale _defaultLocale;
        private ArrayList<Locale> _supportedLocales = new ArrayList();

        public void setId(String id) {
        }

        public void setDefaultLocale(String locale) {
            this._defaultLocale = LocaleUtil.createLocale(locale);
        }

        public void addSupportedLocale(String locale) {
            this._supportedLocales.add(LocaleUtil.createLocale(locale));
        }

        public void configure(Application app) {
            if (this._defaultLocale != null) {
                app.setDefaultLocale(this._defaultLocale);
            }
            app.setSupportedLocales(this._supportedLocales);
        }
    }
}

