/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.context;

import com.caucho.jsf.context.AttributeMap;
import com.caucho.jsf.context.ServletFacesContextImpl;
import com.caucho.server.http.CauchoRequest;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletExternalContext
extends ExternalContext {
    private static final L10N L = new L10N(ServletExternalContext.class);
    private static final Logger log = Logger.getLogger(ServletFacesContextImpl.class.getName());
    private ServletContext _webApp;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private Map<String, String> _requestParameterMap;
    private Map<String, Object> _applicationMap;
    private Map<String, Object> _requestMap;
    private Map<String, Object> _sessionMap;

    ServletExternalContext(ServletContext webApp, HttpServletRequest request, HttpServletResponse response) {
        this._webApp = webApp;
        this._request = request;
        this._response = response;
    }

    public void dispatch(String path) throws IOException {
        try {
            RequestDispatcher rd = this._request.getRequestDispatcher(path);
            if (rd == null) {
                throw new FacesException(L.l("'{0}' is an unknown dispatcher.", path));
            }
            rd.forward((ServletRequest)this._request, (ServletResponse)this._response);
        }
        catch (ServletException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public String encodeActionURL(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        return this._response.encodeURL(url);
    }

    public String encodeNamespace(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return name;
    }

    public String encodeResourceURL(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        return this._response.encodeURL(url);
    }

    public Map<String, Object> getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new ApplicationMap();
        }
        return this._applicationMap;
    }

    public String getAuthType() {
        return this._request.getAuthType();
    }

    public Object getContext() {
        return this._webApp;
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this._webApp.getInitParameter(name);
    }

    public Map getInitParameterMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration e = this._webApp.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            map.put(name, this._webApp.getInitParameter(name));
        }
        return Collections.unmodifiableMap(map);
    }

    public String getRemoteUser() {
        return this._request.getRemoteUser();
    }

    public Object getRequest() {
        return this._request;
    }

    public void setRequest(Object request) {
        if (request instanceof HttpServletRequest) {
            this._request = (HttpServletRequest)request;
        } else {
            log.warning("parameter request is not HttpServletRequest");
        }
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this._request.setCharacterEncoding(encoding);
    }

    public String getRequestContextPath() {
        return this._request.getContextPath();
    }

    public Map<String, Object> getRequestCookieMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Cookie[] cookies = this._request.getCookies();
        if (cookies == null) {
            return map;
        }
        for (int i = 0; i < cookies.length; ++i) {
            map.put(cookies[i].getName(), cookies[i]);
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, String> getRequestHeaderMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration e = this._request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            map.put(name, this._request.getHeader(name));
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration e = this._request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Enumeration e1 = this._request.getHeaders(name);
            ArrayList<String> values = new ArrayList<String>();
            while (e1.hasMoreElements()) {
                values.add((String)e1.nextElement());
            }
            map.put(name, values.toArray(new String[values.size()]));
        }
        return Collections.unmodifiableMap(map);
    }

    public Locale getRequestLocale() {
        return this._request.getLocale();
    }

    public Iterator<Locale> getRequestLocales() {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Enumeration e = this._request.getLocales();
        while (e.hasMoreElements()) {
            locales.add((Locale)e.nextElement());
        }
        return locales.iterator();
    }

    public Map<String, Object> getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new RequestMap();
        }
        return this._requestMap;
    }

    public Map<String, String> getRequestParameterMap() {
        if (this._requestParameterMap == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration e = this._request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                map.put(name, this._request.getParameter(name));
            }
            this._requestParameterMap = Collections.unmodifiableMap(map);
        }
        return this._requestParameterMap;
    }

    public Iterator<String> getRequestParameterNames() {
        return this.getRequestParameterMap().keySet().iterator();
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration e = this._request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            map.put(name, this._request.getParameterValues(name));
        }
        return Collections.unmodifiableMap(map);
    }

    public String getRequestPathInfo() {
        if (this._request instanceof CauchoRequest) {
            return ((CauchoRequest)this._request).getPagePathInfo();
        }
        return this._request.getPathInfo();
    }

    public String getRequestServletPath() {
        if (this._request instanceof CauchoRequest) {
            return ((CauchoRequest)this._request).getPageServletPath();
        }
        return this._request.getServletPath();
    }

    public String getRequestCharacterEncoding() {
        return this._request.getCharacterEncoding();
    }

    public String getRequestContentType() {
        return this._request.getContentType();
    }

    public String getResponseCharacterEncoding() {
        return this._response.getCharacterEncoding();
    }

    public String getResponseContentType() {
        return this._response.getContentType();
    }

    public URL getResource(String path) throws MalformedURLException {
        return this._webApp.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this._webApp.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this._webApp.getResourcePaths(path);
    }

    public Object getResponse() {
        return this._response;
    }

    public void setResponse(Object response) {
        this._response = (HttpServletResponse)response;
    }

    public void setResponseCharacterEncoding(String encoding) {
        this._response.setCharacterEncoding(encoding);
    }

    public Object getSession(boolean create) {
        return this._request.getSession(create);
    }

    public Map<String, Object> getSessionMap() {
        if (this._sessionMap == null) {
            this._sessionMap = new SessionMap(this._request.getSession(true));
        }
        return this._sessionMap;
    }

    public Principal getUserPrincipal() {
        return this._request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this._request.isUserInRole(role);
    }

    public void log(String message) {
        this._webApp.log(message);
    }

    public void log(String message, Throwable exn) {
        this._webApp.log(message, exn);
    }

    public void redirect(String url) throws IOException {
        this._response.sendRedirect(url);
        FacesContext.getCurrentInstance().responseComplete();
    }

    class RequestMap
    extends AttributeMap {
        RequestMap() {
        }

        public Object get(String key) {
            return ServletExternalContext.this._request.getAttribute(key);
        }

        public Object put(String key, Object value) {
            Object oldValue = ServletExternalContext.this._request.getAttribute(key);
            ServletExternalContext.this._request.setAttribute(key, value);
            return oldValue;
        }

        public Object remove(String key) {
            Object value = ServletExternalContext.this._request.getAttribute(key);
            ServletExternalContext.this._request.removeAttribute(key);
            return value;
        }

        public Enumeration getNames() {
            return ServletExternalContext.this._request.getAttributeNames();
        }
    }

    class SessionMap
    extends AttributeMap {
        private HttpSession _session;

        SessionMap(HttpSession session) {
            this._session = session;
        }

        public Object get(String key) {
            return this._session.getAttribute(key);
        }

        public Object put(String key, Object value) {
            Object oldValue = this._session.getAttribute(key);
            this._session.setAttribute(key, value);
            return oldValue;
        }

        public Object remove(String key) {
            Object value = this._session.getAttribute(key);
            this._session.removeAttribute(key);
            return value;
        }

        public Enumeration getNames() {
            return this._session.getAttributeNames();
        }
    }

    class ApplicationMap
    extends AttributeMap {
        ApplicationMap() {
        }

        public Object get(String key) {
            return ServletExternalContext.this._webApp.getAttribute(key);
        }

        public Object put(String key, Object value) {
            Object oldValue = ServletExternalContext.this._webApp.getAttribute(key);
            ServletExternalContext.this._webApp.setAttribute(key, value);
            return oldValue;
        }

        public Object remove(String key) {
            Object value = ServletExternalContext.this._webApp.getAttribute(key);
            ServletExternalContext.this._webApp.removeAttribute(key);
            return value;
        }

        public Enumeration getNames() {
            return ServletExternalContext.this._webApp.getAttributeNames();
        }
    }
}

