/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.dev;

import com.caucho.jsf.dev.JsfDeveloperAidLink;
import com.caucho.jsf.webapp.FacesServletImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

public class JsfDeveloperAid
implements PhaseListener {
    public static final String URL_PATTERN = "caucho.jsf.developer.aid";
    private static final Logger log = Logger.getLogger(FacesServletImpl.class.getName());
    private static final L10N L = new L10N(JsfDeveloperAid.class);
    private String _developerAidLinkStyle;

    public JsfDeveloperAid() {
        WebApp webApp = WebApp.getCurrent();
        this._developerAidLinkStyle = webApp.getJsf().getDeveloperAidLinkStyle();
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        ExternalContext exContext = context.getExternalContext();
        Map sessionMap = exContext.getSessionMap();
        HashMap<String, JsfRequestSnapshot> aidMap = (HashMap<String, JsfRequestSnapshot>)sessionMap.get(URL_PATTERN);
        if (aidMap == null) {
            aidMap = new HashMap<String, JsfRequestSnapshot>();
            sessionMap.put(URL_PATTERN, aidMap);
        }
        try {
            UIViewRoot uiViewRoot = context.getViewRoot();
            if (uiViewRoot != null) {
                JsfRequestSnapshot snapshot;
                String viewId = uiViewRoot.getViewId();
                String phaseId = event.getPhaseId().toString();
                ViewRoot viewRoot = (ViewRoot)this.reflect(context, (UIComponent)uiViewRoot);
                viewRoot.setPhase(phaseId);
                Map requestMap = exContext.getRequestMap();
                HashMap<String, Bean> requestSnapshot = new HashMap<String, Bean>();
                for (String key : requestMap.keySet()) {
                    if (key.startsWith("caucho.") || key.startsWith("com.caucho.") || key.startsWith("javax.")) continue;
                    Bean bean = this.reflect(requestMap.get(key));
                    requestSnapshot.put(key, bean);
                }
                viewRoot.setRequestMap(requestSnapshot);
                HashMap<String, Bean> sessionSnapshot = new HashMap<String, Bean>();
                for (String key : sessionMap.keySet()) {
                    if (key.startsWith("caucho.") || key.startsWith("com.caucho.") || key.startsWith("javax.")) continue;
                    Bean bean = this.reflect(sessionMap.get(key));
                    sessionSnapshot.put(key, bean);
                }
                viewRoot.setSessionMap(sessionSnapshot);
                Map applicationMap = exContext.getApplicationMap();
                HashMap<String, Bean> applicationSnapshot = new HashMap<String, Bean>();
                for (String key : applicationMap.keySet()) {
                    if (key.startsWith("caucho.") || key.startsWith("com.caucho.") || key.startsWith("javax.")) continue;
                    Bean bean = this.reflect(applicationMap.get(key));
                    applicationSnapshot.put(key, bean);
                }
                viewRoot.setApplicationMap(applicationSnapshot);
                if (PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
                    snapshot = new JsfRequestSnapshot();
                    Map map = exContext.getRequestHeaderMap();
                    snapshot.setHeaderMap(new HashMap<String, String>(map));
                    map = exContext.getRequestParameterMap();
                    snapshot.setParameterMap(new HashMap<String, String>(map));
                    aidMap.put(viewId, snapshot);
                } else {
                    snapshot = (JsfRequestSnapshot)aidMap.get(viewId);
                }
                snapshot.addViewRoot(viewRoot);
            }
        }
        catch (IllegalStateException e) {
            log.log(Level.FINER, e.getMessage(), e);
        }
        catch (Throwable t) {
            log.log(Level.FINER, t.getMessage(), t);
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (!PhaseId.RENDER_RESPONSE.equals(event.getPhaseId())) {
            return;
        }
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        if (viewRoot == null) {
            return;
        }
        JsfDeveloperAidLink link = new JsfDeveloperAidLink();
        link.setStyle(this._developerAidLinkStyle);
        viewRoot.getChildren().add(link);
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public Component reflect(FacesContext facesContext, UIComponent uiComponent) {
        int facetCount;
        Component result;
        if (uiComponent instanceof UIViewRoot) {
            UIViewRoot uiViewRoot = (UIViewRoot)uiComponent;
            result = new ViewRoot();
            ViewRoot viewRoot = (ViewRoot)result;
            viewRoot.setLocale(uiViewRoot.getLocale());
            viewRoot.setRenderKitId(uiViewRoot.getRenderKitId());
        } else {
            result = new Component();
        }
        result._uiComponentClass = uiComponent.getClass().getSimpleName();
        result._clientId = uiComponent.getClientId(facesContext);
        result._family = uiComponent.getFamily();
        int childCount = uiComponent.getChildCount();
        if (childCount > 0) {
            List children = uiComponent.getChildren();
            result._children = new ArrayList(children.size());
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (child instanceof JsfDeveloperAidLink) continue;
                result._children.add(this.reflect(facesContext, (UIComponent)children.get(i)));
            }
        }
        if ((facetCount = uiComponent.getFacetCount()) > 0) {
            Map facets = uiComponent.getFacets();
            result._facets = new HashMap(facets.size());
            Set names = facets.keySet();
            for (String name : names) {
                UIComponent child = (UIComponent)facets.get(name);
                result._facets.put(name, this.reflect(facesContext, child));
            }
        }
        if (uiComponent instanceof ValueHolder) {
            Object localValue;
            Object value;
            result._isValueHolder = true;
            try {
                value = ((ValueHolder)uiComponent).getValue();
            }
            catch (Throwable t) {
                value = "Failed due to: " + t.getMessage();
            }
            result._value = String.valueOf(value);
            try {
                localValue = ((ValueHolder)uiComponent).getLocalValue();
            }
            catch (Throwable t) {
                localValue = "Failed due to: " + t.getMessage();
            }
            result._localValue = String.valueOf(localValue);
        }
        if (uiComponent instanceof EditableValueHolder) {
            Object submittedValue;
            result._isEditableValueHolder = true;
            try {
                submittedValue = ((EditableValueHolder)uiComponent).getSubmittedValue();
            }
            catch (Throwable t) {
                submittedValue = "Failed due to: " + t.getMessage();
            }
            if (submittedValue instanceof Object[]) {
                StringBuilder sb = new StringBuilder(91);
                Object[] values = (Object[])submittedValue;
                for (int i = 0; i < values.length; ++i) {
                    Object value = values[i];
                    sb.append(String.valueOf(value));
                    if (i + 1 >= values.length) continue;
                    sb.append(',');
                }
                sb.append(']');
                result._submittedValue = sb.toString();
            } else {
                result._submittedValue = String.valueOf(submittedValue);
            }
        }
        for (Method method : uiComponent.getClass().getMethods()) {
            String name;
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getParameterTypes().length != 0) continue;
            if (method.getName().startsWith("get")) {
                name = method.getName().substring(3);
            } else {
                if (!method.getName().startsWith("is")) continue;
                name = method.getName().substring(2);
            }
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            ValueExpression expr = uiComponent.getValueExpression(name);
            Class<?> type = method.getReturnType();
            if (expr != null) {
                result.setAttribute("expr:" + name, expr.getExpressionString());
                continue;
            }
            if (method.getDeclaringClass().equals(UIComponent.class) || method.getDeclaringClass().equals(UIComponentBase.class) || name.equals("family") || name.equals("value") || name.equals("localValue") || name.equals("submittedValue") || !String.class.equals(type)) continue;
            try {
                Object value = method.invoke((Object)uiComponent, new Object[0]);
                if (value == null) continue;
                result.setAttribute(name, String.valueOf(value));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public Bean reflect(Object obj) {
        Bean result;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String || obj instanceof Boolean || obj instanceof Character || obj instanceof Number || obj instanceof Date) {
            result = new Bean();
            result.setClassName(obj.getClass().getSimpleName());
            result.setToString(obj.toString());
            result.setSimple(true);
        } else if (obj instanceof Object[]) {
            result = new Bean();
            result.setArray(true);
            result.setClassName(obj.getClass().getComponentType().getName());
            result.setLength(Array.getLength(obj));
        } else {
            result = new Bean();
            result.setClassName(obj.getClass().getName());
            result.setToString(obj.toString());
            Field[] fields = obj.getClass().getDeclaredFields();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Field field : fields) {
                try {
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    attributes.put(field.getName(), String.valueOf(value));
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            result.setAttributes(attributes);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Component
    implements Serializable {
        private String _uiComponentClass;
        private String _clientId;
        private String _family;
        private String _value;
        private String _localValue;
        private String _submittedValue;
        private boolean _isValueHolder;
        private boolean _isEditableValueHolder;
        private List<Component> _children;
        private Map<String, Component> _facets;
        private Map<String, String> _attributes;

        public List<Component> getChildren() {
            return this._children;
        }

        public void setChildren(List<Component> children) {
            this._children = children;
        }

        public Map<String, Component> getFacets() {
            return this._facets;
        }

        public void setFacets(Map<String, Component> facets) {
            this._facets = facets;
        }

        public String getUiComponentClass() {
            return this._uiComponentClass;
        }

        public void setUiComponentClass(String uiComponentClass) {
            this._uiComponentClass = uiComponentClass;
        }

        public String getClientId() {
            return this._clientId;
        }

        public void setClientId(String clientId) {
            this._clientId = clientId;
        }

        public String getFamily() {
            return this._family;
        }

        public void setFamily(String family) {
            this._family = family;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public String getLocalValue() {
            return this._localValue;
        }

        public void setLocalValue(String localValue) {
            this._localValue = localValue;
        }

        public String getSubmittedValue() {
            return this._submittedValue;
        }

        public void setSubmittedValue(String submittedValue) {
            this._submittedValue = submittedValue;
        }

        public boolean isValueHolder() {
            return this._isValueHolder;
        }

        public void setValueHolder(boolean valueHolder) {
            this._isValueHolder = valueHolder;
        }

        public boolean isEditableValueHolder() {
            return this._isEditableValueHolder;
        }

        public void setEditableValueHolder(boolean editableValueHolder) {
            this._isEditableValueHolder = editableValueHolder;
        }

        public void setAttribute(String name, String value) {
            if (this._attributes == null) {
                this._attributes = new HashMap<String, String>();
            }
            this._attributes.put(name, value);
        }

        public Map<String, String> getAttributes() {
            return this._attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this._attributes = attributes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewRoot
    extends Component {
        private Locale _locale;
        private String _renderKitId;
        private String _phase;
        private Map<String, Bean> _requestMap;
        private Map<String, Bean> _sessionMap;
        private Map<String, Bean> _applicationMap;

        public Locale getLocale() {
            return this._locale;
        }

        public void setLocale(Locale locale) {
            this._locale = locale;
        }

        public String getRenderKitId() {
            return this._renderKitId;
        }

        public void setRenderKitId(String renderKitId) {
            this._renderKitId = renderKitId;
        }

        public String getPhase() {
            return this._phase;
        }

        public void setPhase(String phase) {
            this._phase = phase;
        }

        public Map<String, Bean> getRequestMap() {
            return this._requestMap;
        }

        public void setRequestMap(Map<String, Bean> requestMap) {
            this._requestMap = requestMap;
        }

        public Map<String, Bean> getSessionMap() {
            return this._sessionMap;
        }

        public void setSessionMap(Map<String, Bean> sessionMap) {
            this._sessionMap = sessionMap;
        }

        public Map<String, Bean> getApplicationMap() {
            return this._applicationMap;
        }

        public void setApplicationMap(Map<String, Bean> applicationMap) {
            this._applicationMap = applicationMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bean
    implements Serializable {
        private Map<String, String> _attributes;
        private String _className;
        private String _toString;
        private boolean _isArray;
        private int _length;
        private boolean _simple;

        public String getToString() {
            return this._toString;
        }

        public void setToString(String toString) {
            this._toString = toString;
        }

        public String getClassName() {
            return this._className;
        }

        public void setClassName(String className) {
            this._className = className;
        }

        public Map<String, String> getAttributes() {
            return this._attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this._attributes = attributes;
        }

        public boolean isArray() {
            return this._isArray;
        }

        public void setArray(boolean array) {
            this._isArray = array;
        }

        public int getLength() {
            return this._length;
        }

        public void setLength(int length) {
            this._length = length;
        }

        public boolean isSimple() {
            return this._simple;
        }

        public void setSimple(boolean simple) {
            this._simple = simple;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JsfRequestSnapshot
    implements Serializable {
        private ViewRoot[] _phases;
        private Map<String, String> _parameterMap;
        private Map<String, String> _headerMap;

        public void addViewRoot(ViewRoot viewRoot) {
            if (this._phases == null) {
                this._phases = new ViewRoot[]{viewRoot};
            } else {
                ViewRoot[] newPhases = new ViewRoot[this._phases.length + 1];
                System.arraycopy(this._phases, 0, newPhases, 0, this._phases.length);
                newPhases[newPhases.length - 1] = viewRoot;
                this._phases = newPhases;
            }
        }

        public void setPhases(ViewRoot[] phases) {
            this._phases = phases;
        }

        public ViewRoot[] getPhases() {
            return this._phases;
        }

        public Map<String, String> getParameterMap() {
            return this._parameterMap;
        }

        public void setParameterMap(Map<String, String> parameterMap) {
            this._parameterMap = parameterMap;
        }

        public Map<String, String> getHeaderMap() {
            return this._headerMap;
        }

        public void setHeaderMap(Map<String, String> headerMap) {
            this._headerMap = headerMap;
        }
    }
}

