/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

class HtmlMessagesRenderer
extends Renderer {
    public static final Renderer RENDERER = new HtmlMessagesRenderer();

    HtmlMessagesRenderer() {
    }

    public boolean getRendersChildren() {
        return false;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String warnStyle;
        String warnClass;
        String title;
        String styleClass;
        String style;
        String layout;
        String lang;
        String infoStyle;
        String infoClass;
        String dir;
        String fatalStyle;
        String fatalClass;
        String errorStyle;
        String errorClass;
        boolean isShowDetail;
        boolean isShowSummary;
        Iterator iter = context.getMessages();
        ResponseWriter out = context.getResponseWriter();
        String id = component.getId();
        if (component instanceof HtmlMessages) {
            HtmlMessages htmlComp = (HtmlMessages)component;
            isShowSummary = htmlComp.isShowSummary();
            isShowDetail = htmlComp.isShowDetail();
            errorClass = htmlComp.getErrorClass();
            errorStyle = htmlComp.getErrorStyle();
            fatalClass = htmlComp.getFatalClass();
            fatalStyle = htmlComp.getFatalStyle();
            dir = htmlComp.getDir();
            infoClass = htmlComp.getInfoClass();
            infoStyle = htmlComp.getInfoStyle();
            lang = htmlComp.getLang();
            layout = htmlComp.getLayout();
            style = htmlComp.getStyle();
            styleClass = htmlComp.getStyleClass();
            title = htmlComp.getTitle();
            warnClass = htmlComp.getWarnClass();
            warnStyle = htmlComp.getWarnStyle();
        } else {
            Map attrMap = component.getAttributes();
            isShowSummary = Boolean.TRUE.equals(attrMap.get("showSummary"));
            isShowDetail = Boolean.TRUE.equals(attrMap.get("showDetail"));
            dir = (String)attrMap.get("dir");
            errorClass = (String)attrMap.get("errorClass");
            errorStyle = (String)attrMap.get("errorStyle");
            fatalClass = (String)attrMap.get("fatalClass");
            fatalStyle = (String)attrMap.get("fatalStyle");
            infoClass = (String)attrMap.get("infoClass");
            infoStyle = (String)attrMap.get("infoStyle");
            warnClass = (String)attrMap.get("warnClass");
            warnStyle = (String)attrMap.get("warnStyle");
            lang = (String)attrMap.get("lang");
            layout = (String)attrMap.get("layout");
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
            title = (String)attrMap.get("title");
        }
        boolean isFirst = true;
        while (iter.hasNext()) {
            FacesMessage msg = (FacesMessage)iter.next();
            if (isFirst) {
                if ("table".equals(layout)) {
                    out.startElement("table", component);
                } else {
                    out.startElement("ul", component);
                }
                if (id != null && !id.startsWith("j_id")) {
                    out.writeAttribute("id", (Object)component.getClientId(context), "id");
                }
                if (dir != null) {
                    out.writeAttribute("dir", (Object)dir, "dir");
                }
                if (lang != null) {
                    out.writeAttribute("lang", (Object)lang, "lang");
                }
                if (style != null) {
                    out.writeAttribute("style", (Object)style, "style");
                }
                if (styleClass != null) {
                    out.writeAttribute("class", (Object)styleClass, "styleClass");
                }
                if (title != null) {
                    out.writeAttribute("title", (Object)title, "title");
                }
            }
            isFirst = false;
            if ("table".equals(layout)) {
                out.startElement("tr", component);
                out.startElement("td", component);
            } else {
                out.startElement("li", component);
            }
            if (FacesMessage.SEVERITY_ERROR.equals(msg.getSeverity())) {
                if (errorClass != null) {
                    out.writeAttribute("class", (Object)errorClass, "errorClass");
                }
                if (errorStyle != null) {
                    out.writeAttribute("style", (Object)errorStyle, "errorStyle");
                }
            } else if (FacesMessage.SEVERITY_FATAL.equals(msg.getSeverity())) {
                if (fatalClass != null) {
                    out.writeAttribute("class", (Object)fatalClass, "fatalClass");
                }
                if (fatalStyle != null) {
                    out.writeAttribute("style", (Object)fatalStyle, "fatalStyle");
                }
            } else if (FacesMessage.SEVERITY_INFO.equals(msg.getSeverity())) {
                if (infoClass != null) {
                    out.writeAttribute("class", (Object)infoClass, "infoClass");
                }
                if (infoStyle != null) {
                    out.writeAttribute("style", (Object)infoStyle, "infoStyle");
                }
            } else if (FacesMessage.SEVERITY_WARN.equals(msg.getSeverity())) {
                if (warnClass != null) {
                    out.writeAttribute("class", (Object)warnClass, "warnClass");
                }
                if (warnStyle != null) {
                    out.writeAttribute("style", (Object)warnStyle, "warnStyle");
                }
            }
            if (isShowSummary) {
                out.writeText((Object)msg.getSummary(), "summary");
            }
            if (isShowDetail) {
                out.writeText((Object)msg.getDetail(), "detail");
            }
            if ("table".equals(layout)) {
                out.endElement("td");
                out.endElement("tr");
                continue;
            }
            out.endElement("li");
        }
        if (!isFirst) {
            if ("table".equals(layout)) {
                out.endElement("table");
            } else {
                out.endElement("ul");
            }
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public String toString() {
        return "HtmlMessagesRenderer[]";
    }
}

