/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

class HtmlPanelGridRenderer
extends Renderer {
    public static final Renderer RENDERER = new HtmlPanelGridRenderer();

    HtmlPanelGridRenderer() {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIComponent header;
        int columns;
        ResponseWriter out = context.getResponseWriter();
        String bgcolor = null;
        int border = -1;
        String captionClass = null;
        String captionStyle = null;
        String cellpadding = null;
        String cellspacing = null;
        String columnClasses = null;
        String dir = null;
        String frame = null;
        String headerClass = null;
        String lang = null;
        String onclick = null;
        String ondblclick = null;
        String onkeydown = null;
        String onkeypress = null;
        String onkeyup = null;
        String onmousedown = null;
        String onmousemove = null;
        String onmouseout = null;
        String onmouseover = null;
        String onmouseup = null;
        String rules = null;
        String style = null;
        String styleClass = null;
        String summary = null;
        String title = null;
        String width = null;
        String id = component.getId();
        if (component instanceof HtmlPanelGrid) {
            HtmlPanelGrid html = (HtmlPanelGrid)component;
            bgcolor = html.getBgcolor();
            border = html.getBorder();
            captionClass = html.getCaptionClass();
            captionStyle = html.getCaptionStyle();
            cellpadding = html.getCellpadding();
            cellspacing = html.getCellspacing();
            columns = html.getColumns();
            columnClasses = html.getColumnClasses();
            dir = html.getDir();
            frame = html.getFrame();
            headerClass = html.getHeaderClass();
            lang = html.getLang();
            onclick = html.getOnclick();
            ondblclick = html.getOndblclick();
            onkeydown = html.getOnkeydown();
            onkeypress = html.getOnkeypress();
            onkeyup = html.getOnkeyup();
            onmousedown = html.getOnmousedown();
            onmousemove = html.getOnmousemove();
            onmouseout = html.getOnmouseout();
            onmouseover = html.getOnmouseover();
            onmouseup = html.getOnmouseup();
            rules = html.getRules();
            style = html.getStyle();
            styleClass = html.getStyleClass();
            summary = html.getSummary();
            title = html.getTitle();
            width = html.getWidth();
        } else {
            Map attrMap = component.getAttributes();
            bgcolor = (String)attrMap.get("bgcolor");
            captionClass = (String)attrMap.get("captionClass");
            captionStyle = (String)attrMap.get("captionStyle");
            Integer iValue = (Integer)attrMap.get("columns");
            columns = iValue != null ? iValue : 0;
            headerClass = (String)attrMap.get("headerClass");
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
        }
        String[] columnClassArray = null;
        if (columnClasses != null && (columnClassArray = columnClasses.split("[ \t,]+")).length == 0) {
            columnClassArray = null;
        }
        out.startElement("table", component);
        if (id != null && !id.startsWith("j_id")) {
            out.writeAttribute("id", (Object)component.getClientId(context), "id");
        }
        if (bgcolor != null) {
            out.writeAttribute("bgcolor", (Object)bgcolor, "bgcolor");
        }
        if (border >= 0) {
            out.writeAttribute("border", (Object)border, "border");
        }
        if (cellpadding != null) {
            out.writeAttribute("cellpadding", (Object)cellpadding, "cellpadding");
        }
        if (cellspacing != null) {
            out.writeAttribute("cellspacing", (Object)cellspacing, "cellspacing");
        }
        if (dir != null) {
            out.writeAttribute("dir", (Object)dir, "dir");
        }
        if (frame != null) {
            out.writeAttribute("frame", (Object)frame, "frame");
        }
        if (lang != null) {
            out.writeAttribute("lang", (Object)lang, "lang");
        }
        if (onclick != null) {
            out.writeAttribute("onclick", (Object)onclick, "onclick");
        }
        if (ondblclick != null) {
            out.writeAttribute("ondblclick", (Object)ondblclick, "ondblclick");
        }
        if (onkeydown != null) {
            out.writeAttribute("onkeydown", (Object)onkeydown, "onkeydown");
        }
        if (onkeypress != null) {
            out.writeAttribute("onkeypress", (Object)onkeypress, "onkeypress");
        }
        if (onkeyup != null) {
            out.writeAttribute("onkeyup", (Object)onkeyup, "onkeyup");
        }
        if (onmousedown != null) {
            out.writeAttribute("onmousedown", (Object)onmousedown, "onmousedown");
        }
        if (onmousemove != null) {
            out.writeAttribute("onmousemove", (Object)onmousemove, "onmousemove");
        }
        if (onmouseout != null) {
            out.writeAttribute("onmouseout", (Object)onmouseout, "onmouseout");
        }
        if (onmouseover != null) {
            out.writeAttribute("onmouseover", (Object)onmouseover, "onmouseover");
        }
        if (onmouseup != null) {
            out.writeAttribute("onmouseup", (Object)onmouseup, "onmouseup");
        }
        if (rules != null) {
            out.writeAttribute("rules", (Object)rules, "rules");
        }
        if (style != null) {
            out.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (summary != null) {
            out.writeAttribute("summary", (Object)summary, "summary");
        }
        if (title != null) {
            out.writeAttribute("title", (Object)title, "title");
        }
        if (width != null) {
            out.writeAttribute("width", (Object)width, "width");
        }
        out.write("\n");
        UIComponent caption = component.getFacet("caption");
        if (caption != null && caption.isRendered()) {
            out.startElement("caption", caption);
            if (captionClass != null) {
                out.writeAttribute("class", (Object)captionClass, "captionClass");
            }
            if (captionStyle != null) {
                out.writeAttribute("style", (Object)captionStyle, "captionStyle");
            }
            caption.encodeAll(context);
            out.endElement("caption");
        }
        if ((header = component.getFacet("header")) != null && header.isRendered()) {
            out.startElement("thead", header);
            out.startElement("tr", header);
            out.startElement("th", header);
            if (headerClass != null) {
                out.writeAttribute("class", (Object)headerClass, "headerClass");
            }
            if (columns > 0) {
                out.writeAttribute("colspan", (Object)columns, "columns");
            }
            out.writeAttribute("scope", (Object)"colgroup", "scope");
            header.encodeAll(context);
            out.endElement("th");
            out.endElement("tr");
            out.endElement("thead");
            out.write("\n");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        int size;
        String rowClasses;
        String columnClasses;
        int columns = 0;
        ResponseWriter out = context.getResponseWriter();
        if (component instanceof HtmlPanelGrid) {
            HtmlPanelGrid html = (HtmlPanelGrid)component;
            columnClasses = html.getColumnClasses();
            rowClasses = html.getRowClasses();
            columns = html.getColumns();
        } else {
            Map attrMap = component.getAttributes();
            columnClasses = (String)attrMap.get("columnClasses");
            rowClasses = (String)attrMap.get("rowClasses");
            Integer iValue = (Integer)attrMap.get("columns");
            columns = iValue != null ? iValue : 0;
        }
        String[] columnClassArray = null;
        if (columnClasses != null && (columnClassArray = columnClasses.split("[ \t,]+")).length == 0) {
            columnClassArray = null;
        }
        String[] rowClassArray = null;
        if (rowClasses != null && (rowClassArray = rowClasses.split("[ \t,]+")).length == 0) {
            rowClassArray = null;
        }
        if ((size = component.getChildCount()) == 0) {
            return;
        }
        if (columns < 1) {
            columns = 1;
        }
        List children = component.getChildren();
        int count = 0;
        out.startElement("tbody", component);
        out.write("\n");
        for (int i = 0; i < size; ++i) {
            String v;
            UIComponent child = (UIComponent)children.get(i);
            if (!child.isRendered()) continue;
            int column = count % columns;
            int row = count / columns;
            if (column == 0) {
                if (count > 0) {
                    out.endElement("tr");
                    out.write("\n");
                }
                out.startElement("tr", child);
                if (rowClassArray != null) {
                    v = rowClassArray[row % rowClassArray.length];
                    out.writeAttribute("class", (Object)v, "rowClasses");
                }
            }
            ++count;
            out.startElement("td", child);
            if (columnClassArray != null) {
                v = columnClassArray[column % columnClassArray.length];
                out.writeAttribute("class", (Object)v, "columnClasses");
            }
            if (child instanceof UIColumn) {
                int subCount = child.getChildCount();
                for (int j = 0; j < subCount; ++j) {
                    UIComponent subChild = (UIComponent)child.getChildren().get(j);
                    subChild.encodeAll(context);
                }
            } else {
                child.encodeAll(context);
            }
            out.endElement("td");
        }
        if (count > 0) {
            out.endElement("tr");
            out.write("\n");
        }
        out.endElement("tbody");
        out.write("\n");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String footerClass;
        int columns;
        ResponseWriter out = context.getResponseWriter();
        if (component instanceof HtmlPanelGrid) {
            HtmlPanelGrid html = (HtmlPanelGrid)component;
            columns = html.getColumns();
            footerClass = html.getFooterClass();
        } else {
            Map attrMap = component.getAttributes();
            columns = (Integer)attrMap.get("columns");
            footerClass = (String)attrMap.get("footerClass");
        }
        UIComponent footer = component.getFacet("footer");
        if (footer != null && footer.isRendered()) {
            out.startElement("tfoot", footer);
            out.startElement("tr", footer);
            out.startElement("td", footer);
            if (columns > 0) {
                out.writeAttribute("colspan", (Object)columns, "columns");
            }
            if (footerClass != null) {
                out.writeAttribute("class", (Object)footerClass, "footerClass");
            }
            footer.encodeAll(context);
            out.endElement("td");
            out.endElement("tr");
            out.endElement("tfoot");
            out.write("\n");
        }
        out.endElement("table");
        out.write("\n");
    }

    public String toString() {
        return "HtmlPanelGridRenderer[]";
    }
}

