/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import com.caucho.jsf.html.BaseRenderer;
import com.caucho.util.Html;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SelectRenderer
extends BaseRenderer {
    private static Map<Class, Class> _primitiveTypeMap = new HashMap<Class, Class>();

    SelectRenderer() {
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (component instanceof UISelectMany) {
            return this.getConvertedValue(context, (UISelectMany)component, submittedValue);
        }
        return super.getConvertedValue(context, component, submittedValue);
    }

    private Object getConvertedValue(FacesContext context, UISelectMany uiSelectMany, Object submittedValue) throws ConverterException {
        String[] strValues = (String[])submittedValue;
        Converter converter = uiSelectMany.getConverter();
        Object[] values = null;
        ValueExpression valueExpr = uiSelectMany.getValueExpression("value");
        if (valueExpr != null) {
            Class cl = valueExpr.getType(context.getELContext());
            if (cl.isArray()) {
                if ((cl = cl.getComponentType()).isPrimitive()) {
                    cl = _primitiveTypeMap.get(cl);
                }
                converter = context.getApplication().createConverter(cl);
                values = (Object[])Array.newInstance(cl, strValues.length);
            } else if (List.class.isAssignableFrom(cl)) {
                values = strValues;
                return values;
            }
        } else {
            values = new Object[strValues.length];
        }
        for (int i = 0; i < strValues.length; ++i) {
            values[i] = converter != null ? converter.getAsObject(context, (UIComponent)uiSelectMany, strValues[i]) : strValues[i];
        }
        return values;
    }

    public List<SelectItem> accrueSelectItems(UIComponent component) {
        ArrayList<SelectItem> itemList = new ArrayList<SelectItem>();
        int count = component.getChildCount();
        if (count == 0) {
            return itemList;
        }
        List children = component.getChildren();
        for (int i = 0; i < count; ++i) {
            Object items;
            UIComponent child = (UIComponent)children.get(i);
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                SelectItem item = (SelectItem)uiSelectItem.getValue();
                if (item == null) {
                    item = new SelectItem(uiSelectItem.getItemValue(), uiSelectItem.getItemLabel(), uiSelectItem.getItemDescription(), uiSelectItem.isItemDisabled(), uiSelectItem.isItemEscaped());
                }
                itemList.add(item);
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            UISelectItems selectedItems = (UISelectItems)child;
            Object value = selectedItems.getValue();
            if (value instanceof SelectItem) {
                itemList.add((SelectItem)value);
                continue;
            }
            if (value instanceof SelectItem[]) {
                items = (SelectItem[])value;
                itemList.ensureCapacity(itemList.size() + ((SelectItem[])items).length);
                for (Object item : items) {
                    itemList.add((SelectItem)item);
                }
                continue;
            }
            if (value instanceof Collection) {
                items = (Collection)value;
                itemList.ensureCapacity(itemList.size() + items.size());
                itemList.addAll((Collection<SelectItem>)items);
                continue;
            }
            if (!(value instanceof Map)) continue;
            Map map = (Map)value;
            itemList.ensureCapacity(itemList.size() + map.size());
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                itemList.add(new SelectItem(entry.getValue(), String.valueOf(entry.getKey())));
            }
        }
        return itemList;
    }

    protected void encodeChildren(ResponseWriter out, FacesContext context, UIComponent component, Object[] values, String enabledClass, String disabledClass) throws IOException {
        List<SelectItem> list = this.accrueSelectItems(component);
        for (int i = 0; i < list.size(); ++i) {
            SelectItem selectItem = list.get(i);
            out.startElement("option", component);
            if (selectItem.isDisabled()) {
                out.writeAttribute("disabled", (Object)"disabled", "disabled");
                if (disabledClass != null) {
                    out.writeAttribute("class", (Object)disabledClass, "disabledClass");
                }
            } else if (enabledClass != null) {
                out.writeAttribute("class", (Object)enabledClass, "enabledClass");
            }
            if (values != null) {
                for (int j = 0; j < values.length; ++j) {
                    if (!values[j].equals(selectItem.getValue())) continue;
                    out.writeAttribute("selected", (Object)"selected", "selected");
                    break;
                }
            }
            out.writeAttribute("value", (Object)String.valueOf(selectItem.getValue()), "value");
            String label = selectItem.getLabel();
            if (label != null) {
                if (selectItem.isEscape()) {
                    label = Html.escapeHtml(label);
                }
                out.writeText((Object)label, "label");
            }
            out.endElement("option");
            out.write("\n");
        }
    }

    protected void encodeOneChildren(ResponseWriter out, FacesContext context, UIComponent component, Object value, String enabledClass, String disabledClass) throws IOException {
        String clientId = component.getClientId(context);
        ValueExpression ve = component.getValueExpression("value");
        Class type = null;
        if (ve != null) {
            type = ve.getType(context.getELContext());
        }
        List<SelectItem> items = this.accrueSelectItems(component);
        for (int i = 0; i < items.size(); ++i) {
            String childId = clientId + ":" + i;
            SelectItem selectItem = items.get(i);
            String itemLabel = selectItem.getLabel();
            Object itemValue = selectItem.getValue();
            out.startElement("option", component);
            Object optionValue = type != null ? context.getApplication().getExpressionFactory().coerceToType(itemValue, type) : selectItem.getValue();
            if (value != null && value.equals(optionValue)) {
                out.writeAttribute("selected", (Object)"selected", "selected");
            }
            if (selectItem.isDisabled()) {
                out.writeAttribute("disabled", (Object)"disabled", "disabled");
                if (disabledClass != null) {
                    out.writeAttribute("class", (Object)disabledClass, "disabledClass");
                }
            } else if (enabledClass != null) {
                out.writeAttribute("class", (Object)enabledClass, "enabledClass");
            }
            String itemValueString = this.toString(context, component, itemValue);
            out.writeAttribute("value", (Object)itemValueString, "value");
            if (itemLabel == null) {
                itemLabel = itemValueString;
            }
            if (selectItem.isEscape()) {
                itemLabel = Html.escapeHtml(itemLabel);
            }
            out.writeText((Object)itemLabel, "label");
            out.endElement("option");
            out.write("\n");
        }
    }

    static {
        _primitiveTypeMap.put(Boolean.TYPE, Boolean.class);
        _primitiveTypeMap.put(Byte.TYPE, Byte.class);
        _primitiveTypeMap.put(Character.TYPE, Character.class);
        _primitiveTypeMap.put(Short.TYPE, Short.class);
        _primitiveTypeMap.put(Integer.TYPE, Integer.class);
        _primitiveTypeMap.put(Long.TYPE, Long.class);
        _primitiveTypeMap.put(Float.TYPE, Float.class);
        _primitiveTypeMap.put(Double.TYPE, Double.class);
    }
}

