/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.webapp;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.jsf.application.ApplicationImpl;
import com.caucho.jsf.application.JspViewHandler;
import com.caucho.jsf.application.NavigationHandlerImpl;
import com.caucho.jsf.application.SessionStateManager;
import com.caucho.jsf.cfg.ApplicationConfig;
import com.caucho.jsf.cfg.FacesConfig;
import com.caucho.jsf.cfg.JsfPropertyGroup;
import com.caucho.jsf.cfg.ManagedBeanConfig;
import com.caucho.jsf.cfg.NavigationRule;
import com.caucho.jsf.cfg.ResourceBundleConfig;
import com.caucho.jsf.dev.JsfDeveloperAid;
import com.caucho.jsf.dev.JsfDeveloperAidServlet;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.webapp.WebApp;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FacesServletImpl
extends GenericServlet {
    private static final Logger log = Logger.getLogger(FacesServletImpl.class.getName());
    private static final String FACES_SCHEMA = "com/caucho/jsf/cfg/jsf.rnc";
    private ConfigException _configException;
    private ArrayList<PhaseListener> _phaseListenerList = new ArrayList();

    public void init(ServletConfig config) throws ServletException {
        FacesServletImpl.initFactory("javax.faces.application.ApplicationFactory", "com.caucho.jsf.application.ApplicationFactoryImpl");
        FacesServletImpl.initFactory("javax.faces.lifecycle.LifecycleFactory", "com.caucho.jsf.lifecycle.LifecycleFactoryImpl");
        FacesServletImpl.initFactory("javax.faces.render.RenderKitFactory", "com.caucho.jsf.render.RenderKitFactoryImpl");
        FacesServletImpl.initFactory("javax.faces.context.FacesContextFactory", "com.caucho.jsf.context.FacesContextFactoryImpl");
        ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Application app = appFactory.getApplication();
        if (app == null) {
            app = new ApplicationImpl();
            appFactory.setApplication(app);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> e = loader.getResources("META-INF/faces-config.xml");
            while (e != null && e.hasMoreElements()) {
                URL url = e.nextElement();
                this.initPath(app, Vfs.lookup(url.toString()));
            }
        }
        catch (IOException e) {
            throw ConfigException.create(e);
        }
        String path = config.getServletContext().getInitParameter("javax.faces.CONFIG_FILES");
        String[] paths = null;
        if (path != null) {
            paths = path.split("\\s*,\\s*");
        }
        for (int i = 0; paths != null && i < paths.length; ++i) {
            this.initPath(app, Vfs.lookup("./" + paths[i]));
        }
        this.initPath(app, Vfs.lookup("WEB-INF/faces-config.xml"));
        if (app.getViewHandler() == null) {
            app.setViewHandler((ViewHandler)new JspViewHandler());
        }
        JsfPropertyGroup jsfPropertyGroup = WebApp.getLocal().getJsf();
        if (app.getStateManager() == null) {
            SessionStateManager stateManager = new SessionStateManager();
            if (jsfPropertyGroup != null) {
                stateManager.setStateSerializationMethod(jsfPropertyGroup.getStateSerializationMethod());
            }
            app.setStateManager((StateManager)stateManager);
        }
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        JsfDeveloperAid developerAidListener = null;
        if (jsfPropertyGroup != null && jsfPropertyGroup.isEnableDeveloperAid()) {
            developerAidListener = new JsfDeveloperAid();
            ServletMapping servletMapping = WebApp.getCurrent().createServletMapping();
            servletMapping.addURLPattern("/caucho.jsf.developer.aid");
            servletMapping.setServletClass(JsfDeveloperAidServlet.class.getName());
            WebApp.getCurrent().addServletMapping(servletMapping);
        }
        Iterator iter = lifecycleFactory.getLifecycleIds();
        while (iter.hasNext()) {
            Lifecycle lifecycle = lifecycleFactory.getLifecycle((String)iter.next());
            if (developerAidListener != null) {
                lifecycle.addPhaseListener((PhaseListener)developerAidListener);
            }
            for (PhaseListener listener : this._phaseListenerList) {
                lifecycle.addPhaseListener(listener);
            }
        }
    }

    private static void initFactory(String factoryName, String defaultName) {
        Object factoryObj = null;
        try {
            factoryObj = FactoryFinder.getFactory((String)factoryName);
        }
        catch (FacesException e) {
            // empty catch block
        }
        if (factoryObj == null) {
            FactoryFinder.setFactory((String)factoryName, (String)defaultName);
            String factory = FacesServletImpl.getServiceFactory(factoryName);
            if (factory != null && !"".equals(factory)) {
                FactoryFinder.setFactory((String)factoryName, (String)factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getServiceFactory(String factoryName) {
        try {
            InputStream is;
            block9: {
                String string;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                is = loader.getResourceAsStream("META-INF/services/" + factoryName);
                try {
                    try {
                        BufferedReader reader;
                        String line;
                        if (is == null || (line = (reader = new BufferedReader(new InputStreamReader(is))).readLine()) == null) break block9;
                        if (line.indexOf(35) >= 0) {
                            line = line.substring(0, line.indexOf(35));
                        }
                        string = line.trim();
                        Object var7_8 = null;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                        Object var7_10 = null;
                        is.close();
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                return string;
            }
            Object var7_9 = null;
            is.close();
            return null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void initPath(Application app, Path facesPath) throws ServletException {
        if (facesPath.canRead() && !facesPath.isDirectory()) {
            try {
                FacesConfig facesConfig = new FacesConfig();
                Config config = new Config();
                config.setEL(false);
                config.configure((Object)facesConfig, facesPath, FACES_SCHEMA);
                if (app instanceof ApplicationImpl) {
                    ApplicationImpl appImpl = (ApplicationImpl)app;
                    NavigationHandlerImpl navigationHandler = appImpl.getDefaultNavigationHandler();
                    List<NavigationRule> navigationRules = facesConfig.getNavigationRules();
                    for (NavigationRule navigationRule : navigationRules) {
                        navigationHandler.addRule(navigationRule);
                    }
                    facesConfig.configure(appImpl);
                    facesConfig.configurePhaseListeners(this._phaseListenerList);
                    for (ManagedBeanConfig bean : facesConfig.getManagedBeans()) {
                        appImpl.addManagedBean(bean.getName(), bean);
                    }
                    ApplicationConfig appConfig = facesConfig.getApplication();
                    if (appConfig != null) {
                        appConfig.configure(appImpl);
                        for (ResourceBundleConfig bundle : appConfig.getResourceBundleList()) {
                            appImpl.addResourceBundle(bundle.getVar(), bundle);
                        }
                    }
                }
            }
            catch (ConfigException e) {
                this._configException = e;
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
    }
}

