/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.json;

import com.caucho.json.JsonOutput;
import com.caucho.json.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSerializer
implements JsonSerializer {
    private static final Logger log = Logger.getLogger(JavaSerializer.class.getName());
    private Class _type;
    private Field[] _fields;

    JavaSerializer(Class type) {
        this._type = type;
        this.introspect();
    }

    void introspect() {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.introspectFields(fields, this._type);
        Collections.sort(fields, new FieldComparator());
        this._fields = new Field[fields.size()];
        fields.toArray(this._fields);
    }

    private void introspectFields(ArrayList<Field> fields, Class type) {
        if (type == null) {
            return;
        }
        this.introspectFields(fields, type.getSuperclass());
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            fields.add(field);
        }
    }

    @Override
    public void write(JsonOutput out, Object value) throws IOException {
        int i = 0;
        out.writeMapBegin();
        for (Field field : this._fields) {
            Object fieldValue = null;
            try {
                fieldValue = field.get(value);
            }
            catch (Exception e) {
                log.warning(out + " cannot get field " + field + " with value " + value);
            }
            if (fieldValue == null) continue;
            if (i++ > 0) {
                out.writeMapComma();
            }
            out.writeMapEntry(field.getName(), fieldValue);
        }
        out.writeMapEnd();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldComparator
    implements Comparator<Field> {
        FieldComparator() {
        }

        @Override
        public int compare(Field a, Field b) {
            return a.getName().compareTo(b.getName());
        }
    }
}

