/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.json;

import com.caucho.json.JsonSerializer;
import com.caucho.json.JsonSerializerFactory;
import com.caucho.util.Utf8;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class JsonOutput {
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};
    private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};
    private JsonSerializerFactory _factory = new JsonSerializerFactory();
    private OutputStream _os;

    public JsonOutput() {
    }

    public JsonOutput(OutputStream os) {
        this.init(os);
    }

    public void init(OutputStream os) {
        this._os = os;
    }

    public void writeObject(Serializable value) throws IOException {
        OutputStream os = this._os;
        if (value == null) {
            os.write(NULL, 0, 4);
            return;
        }
        JsonSerializer ser = this._factory.getSerializer(value.getClass());
        ser.write(this, value);
    }

    public void writeNull() throws IOException {
        OutputStream os = this._os;
        os.write(NULL, 0, 4);
    }

    public void writeBoolean(boolean value) throws IOException {
        OutputStream os = this._os;
        if (value) {
            os.write(TRUE, 0, 4);
        } else {
            os.write(FALSE, 0, 5);
        }
    }

    public void writeLong(long value) throws IOException {
        this.writeStringValue(String.valueOf(value));
    }

    public void writeDouble(double value) throws IOException {
        this.writeStringValue(String.valueOf(value));
    }

    public void writeString(String v) throws IOException {
        OutputStream os = this._os;
        if (v == null) {
            os.write(NULL, 0, 4);
            return;
        }
        os.write(34);
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            char ch = v.charAt(i);
            this.writeChar(os, ch);
        }
        os.write(34);
    }

    public void writeString(char[] v, int offset, int length) throws IOException {
        OutputStream os = this._os;
        os.write(34);
        for (int i = 0; i < length; ++i) {
            char ch = v[offset + i];
            this.writeChar(os, ch);
        }
        os.write(34);
    }

    private void writeChar(OutputStream os, char ch) throws IOException {
        switch (ch) {
            case '\u0000': {
                os.write(92);
                os.write(117);
                os.write(48);
                os.write(48);
                os.write(48);
                os.write(48);
                break;
            }
            case '\n': {
                os.write(92);
                os.write(110);
                break;
            }
            case '\r': {
                os.write(92);
                os.write(114);
                break;
            }
            case '\t': {
                os.write(92);
                os.write(116);
                break;
            }
            case '\b': {
                os.write(92);
                os.write(98);
                break;
            }
            case '\f': {
                os.write(92);
                os.write(102);
                break;
            }
            case '\\': {
                os.write(92);
                os.write(92);
                break;
            }
            case '\"': {
                os.write(92);
                os.write(34);
                break;
            }
            default: {
                Utf8.write(os, ch);
            }
        }
    }

    public void writeArrayBegin() throws IOException {
        this._os.write(91);
    }

    public void writeArrayComma() throws IOException {
        this._os.write(44);
    }

    public void writeArrayEnd() throws IOException {
        this._os.write(93);
    }

    public void writeMapBegin() throws IOException {
        this._os.write(123);
    }

    public void writeMapComma() throws IOException {
        this._os.write(44);
    }

    public void writeMapEntry(String key, Object value) throws IOException {
        this.writeString(key);
        this._os.write(58);
        this.writeObject((Serializable)value);
    }

    public void writeMapEnd() throws IOException {
        this._os.write(125);
    }

    private void writeStringValue(String s) throws IOException {
        OutputStream os = this._os;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            os.write(ch);
        }
    }

    public void flushBuffer() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }
}

