/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.json;

import com.caucho.json.BooleanArraySerializer;
import com.caucho.json.BooleanSerializer;
import com.caucho.json.ByteArraySerializer;
import com.caucho.json.CharArraySerializer;
import com.caucho.json.CharSerializer;
import com.caucho.json.CollectionSerializer;
import com.caucho.json.DoubleArraySerializer;
import com.caucho.json.DoubleSerializer;
import com.caucho.json.FloatArraySerializer;
import com.caucho.json.IntArraySerializer;
import com.caucho.json.JavaDeserializer;
import com.caucho.json.JavaSerializer;
import com.caucho.json.JsonDeserializer;
import com.caucho.json.JsonSerializer;
import com.caucho.json.LongArraySerializer;
import com.caucho.json.LongSerializer;
import com.caucho.json.MapSerializer;
import com.caucho.json.ObjectArraySerializer;
import com.caucho.json.ShortArraySerializer;
import com.caucho.json.StringDeserializer;
import com.caucho.json.StringSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JsonSerializerFactory {
    private static final HashMap<Class, JsonSerializer> _staticSerMap = new HashMap();
    private final ConcurrentHashMap<Class, JsonSerializer> _serMap = new ConcurrentHashMap();
    private static final HashMap<Class, JsonDeserializer> _staticDeserMap = new HashMap();
    private final ConcurrentHashMap<Class, JsonDeserializer> _deserMap = new ConcurrentHashMap();

    public JsonSerializer getSerializer(Class cl) {
        JsonSerializer ser = this._serMap.get(cl);
        if (ser == null) {
            ser = this.createSerializer(cl);
            this._serMap.putIfAbsent(cl, ser);
        }
        return ser;
    }

    protected JsonSerializer createSerializer(Class cl) {
        JsonSerializer ser = _staticSerMap.get(cl);
        if (ser != null) {
            return ser;
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return CollectionSerializer.SER;
        }
        if (Map.class.isAssignableFrom(cl)) {
            return MapSerializer.SER;
        }
        if (cl.isArray()) {
            return ObjectArraySerializer.SER;
        }
        return new JavaSerializer(cl);
    }

    public JsonDeserializer getDeserializer(Class cl) {
        JsonDeserializer deser = this._deserMap.get(cl);
        if (deser == null) {
            deser = this.createDeserializer(cl);
            this._deserMap.putIfAbsent(cl, deser);
        }
        return deser;
    }

    protected JsonDeserializer createDeserializer(Class cl) {
        JsonDeserializer deser = _staticDeserMap.get(cl);
        if (deser != null) {
            return deser;
        }
        return new JavaDeserializer(cl);
    }

    static {
        _staticSerMap.put(Boolean.TYPE, BooleanSerializer.SER);
        _staticSerMap.put(Boolean.class, BooleanSerializer.SER);
        _staticSerMap.put(Character.TYPE, CharSerializer.SER);
        _staticSerMap.put(Character.class, CharSerializer.SER);
        _staticSerMap.put(Byte.TYPE, LongSerializer.SER);
        _staticSerMap.put(Byte.class, LongSerializer.SER);
        _staticSerMap.put(Short.TYPE, LongSerializer.SER);
        _staticSerMap.put(Short.class, LongSerializer.SER);
        _staticSerMap.put(Integer.TYPE, LongSerializer.SER);
        _staticSerMap.put(Integer.class, LongSerializer.SER);
        _staticSerMap.put(Long.TYPE, LongSerializer.SER);
        _staticSerMap.put(Long.class, LongSerializer.SER);
        _staticSerMap.put(Float.TYPE, DoubleSerializer.SER);
        _staticSerMap.put(Float.class, DoubleSerializer.SER);
        _staticSerMap.put(Double.TYPE, DoubleSerializer.SER);
        _staticSerMap.put(Double.class, DoubleSerializer.SER);
        _staticSerMap.put(String.class, StringSerializer.SER);
        _staticSerMap.put(boolean[].class, BooleanArraySerializer.SER);
        _staticSerMap.put(byte[].class, ByteArraySerializer.SER);
        _staticSerMap.put(char[].class, CharArraySerializer.SER);
        _staticSerMap.put(short[].class, ShortArraySerializer.SER);
        _staticSerMap.put(int[].class, IntArraySerializer.SER);
        _staticSerMap.put(long[].class, LongArraySerializer.SER);
        _staticSerMap.put(float[].class, FloatArraySerializer.SER);
        _staticSerMap.put(double[].class, DoubleArraySerializer.SER);
        _staticDeserMap.put(String.class, StringDeserializer.DESER);
    }
}

