/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaCompiler;
import com.caucho.java.LineMap;
import com.caucho.jsf.cfg.JsfPropertyGroup;
import com.caucho.jsp.AppDirResourceManager;
import com.caucho.jsp.AppResourceManager;
import com.caucho.jsp.JspBuilder;
import com.caucho.jsp.JspCompiler;
import com.caucho.jsp.JspContentHandler;
import com.caucho.jsp.JspGenerator;
import com.caucho.jsp.JspPageConfig;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspParser;
import com.caucho.jsp.JspResourceManager;
import com.caucho.jsp.Page;
import com.caucho.jsp.ParseState;
import com.caucho.jsp.ParseTagManager;
import com.caucho.jsp.TagFileManager;
import com.caucho.jsp.TaglibManager;
import com.caucho.jsp.cfg.ImplicitTld;
import com.caucho.jsp.cfg.JspConfig;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.jsp.java.JavaJspBuilder;
import com.caucho.jsp.java.JspTagSupport;
import com.caucho.jsp.java.TagTaglib;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.xml.Xml;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspCompilerInstance {
    private static final L10N L = new L10N(JspCompilerInstance.class);
    private static final Logger log = Logger.getLogger(JspCompilerInstance.class.getName());
    private JspCompiler _jspCompiler;
    private Path _jspPath;
    private String _uri;
    private String _className;
    private JspPropertyGroup _jspPropertyGroup;
    private JsfPropertyGroup _jsfPropertyGroup;
    private JspBuilder _jspBuilder;
    private boolean _isXml;
    private boolean _isPrototype;
    private boolean _isGeneratedSource;
    private ParseState _parseState;
    private ParseTagManager _tagManager;
    private JspParser _parser;
    private Page _page;
    private JspGenerator _generator;
    private ArrayList<String> _preludeList = new ArrayList();
    private ArrayList<String> _codaList = new ArrayList();
    private ArrayList<PersistentDependency> _dependList = new ArrayList();

    JspCompilerInstance(JspCompiler compiler) {
        this._jspCompiler = compiler;
        this._isXml = this._jspCompiler.isXml();
    }

    void setJspBuilder(JspBuilder builder) {
        this._jspBuilder = builder;
    }

    void setJspPath(Path path) {
        this._jspPath = path;
    }

    void setURI(String uri) {
        this._uri = uri;
    }

    void setXML(boolean isXml) {
        this._isXml = isXml;
    }

    void setGeneratedSource(boolean isGeneratedSource) {
        this._isGeneratedSource = isGeneratedSource;
    }

    public boolean isGeneratedSource() {
        return this._isGeneratedSource;
    }

    void setClassName(String className) {
        this._className = className;
    }

    public void addDepend(PersistentDependency depend) {
        this._dependList.add(depend);
    }

    public void addDependList(ArrayList<PersistentDependency> dependList) {
        if (dependList != null) {
            this._dependList.addAll(dependList);
        }
    }

    public JspPropertyGroup getJspPropertyGroup() {
        return this._jspPropertyGroup;
    }

    public boolean isPrototype() {
        return this._isPrototype;
    }

    public void setPrototype(boolean prototype) {
        this._isPrototype = prototype;
    }

    void init() throws Exception {
        JspResourceManager resourceManager;
        JspConfig jspConfig;
        int p;
        this._parseState = new ParseState();
        String uriPwd = this._uri != null ? ((p = this._uri.lastIndexOf(47)) <= 0 ? "/" : this._uri.substring(0, p + 1)) : "/";
        this._parseState.setUriPwd(uriPwd);
        if (this._className == null) {
            this._className = JavaCompiler.mangleName("jsp/" + this._uri);
        }
        if (this._uri.endsWith("x")) {
            this._parseState.setXml(true);
        }
        WebApp app = this._jspCompiler.getWebApp();
        Path appDir = this._jspCompiler.getAppDir();
        if (appDir == null && app != null) {
            appDir = app.getRootDirectory();
        }
        if (app != null && app.hasPre23Config() && this._parseState.getELIgnoredDefault() == null && !this._parseState.isXml()) {
            this._parseState.setELIgnoredDefault(true);
        }
        if ((jspConfig = null) == null && app != null) {
            jspConfig = (JspConfig)app.getExtension("jsp-config");
        }
        ArrayList<JspPropertyGroup> jspList = new ArrayList<JspPropertyGroup>();
        this._jspPropertyGroup = null;
        if (this._jspPropertyGroup == null) {
            this._jspPropertyGroup = this._jspCompiler.getJspPropertyGroup();
            if (this._jspPropertyGroup != null) {
                jspList.add(this._jspPropertyGroup);
            }
        }
        if (this._jspPropertyGroup == null && app != null) {
            this._jspPropertyGroup = app.getJsp();
            if (this._jspPropertyGroup != null) {
                jspList.add(this._jspPropertyGroup);
            }
        }
        if (this._jspPropertyGroup == null) {
            this._jspPropertyGroup = this._jspCompiler.getJspPropertyGroup();
            if (this._jspPropertyGroup != null) {
                jspList.add(this._jspPropertyGroup);
            }
        }
        if (jspConfig != null) {
            jspList.addAll(jspConfig.findJspPropertyGroupList(this._uri));
            if (this._parseState.getELIgnoredDefault() == null) {
                this._parseState.setELIgnoredDefault(false);
            }
        }
        if ((resourceManager = this._jspCompiler.getResourceManager()) == null) {
            resourceManager = app != null ? new AppResourceManager(app) : new AppDirResourceManager(appDir);
        }
        TagFileManager tagFileManager = this._jspCompiler.getTagFileManager();
        TaglibManager taglibManager = this._jspCompiler.getTaglibManager();
        JspPageConfig pageConfig = new JspPageConfig();
        for (JspPropertyGroup jspPropertyGroup : jspList) {
            ArrayList<String> preludeList = jspPropertyGroup.getIncludePreludeList();
            for (int i = 0; preludeList != null && i < preludeList.size(); ++i) {
                String prelude = preludeList.get(i);
                this._preludeList.add(prelude);
            }
            ArrayList<String> codaList = jspPropertyGroup.getIncludeCodaList();
            for (int i = 0; codaList != null && i < codaList.size(); ++i) {
                String coda = codaList.get(i);
                this._codaList.add(coda);
            }
            this._parseState.setJspPropertyGroup(jspPropertyGroup);
            this._parseState.setSession(jspPropertyGroup.isSession());
            this._parseState.setScriptingInvalid(jspPropertyGroup.isScriptingInvalid());
            if (jspPropertyGroup.isELIgnored() != null) {
                this._parseState.setELIgnored(Boolean.TRUE.equals(jspPropertyGroup.isELIgnored()));
            }
            this._parseState.setVelocityEnabled(jspPropertyGroup.isVelocityEnabled());
            this._parseState.setPageEncoding(jspPropertyGroup.getPageEncoding());
            if (Boolean.TRUE.equals(jspPropertyGroup.isXml())) {
                this._parseState.setXml(true);
            }
            if (Boolean.FALSE.equals(jspPropertyGroup.isXml())) {
                this._parseState.setXml(false);
                this._parseState.setForbidXml(true);
            }
            if (jspPropertyGroup.getPageEncoding() != null) {
                try {
                    this._parseState.setPageEncoding(jspPropertyGroup.getPageEncoding());
                }
                catch (JspParseException e) {
                    // empty catch block
                }
            }
            pageConfig.setStaticEncoding(jspPropertyGroup.isStaticEncoding());
            this._parseState.setRecycleTags(jspPropertyGroup.isRecycleTags());
            this._parseState.setTrimWhitespace(jspPropertyGroup.isTrimDirectiveWhitespaces());
            this._parseState.setDeferredSyntaxAllowedAsLiteral(jspPropertyGroup.isDeferredSyntaxAllowedAsLiteral());
            if (jspPropertyGroup.getTldFileSet() == null) continue;
            taglibManager.setTldFileSet(jspPropertyGroup.getTldFileSet());
        }
        if (this._jsfPropertyGroup == null) {
            this._jsfPropertyGroup = this._jspCompiler.getJsfPropertyGroup();
        }
        if (this._jsfPropertyGroup == null && app != null) {
            this._jsfPropertyGroup = app.getJsf();
        }
        this._parseState.setResourceManager(resourceManager);
        Object lineMap = null;
        this._tagManager = new ParseTagManager(resourceManager, taglibManager, tagFileManager);
        this._jspBuilder = new JavaJspBuilder();
        this._jspBuilder.setParseState(this._parseState);
        this._jspBuilder.setJspCompiler(this._jspCompiler);
        this._jspBuilder.setJspPropertyGroup(this._jspPropertyGroup);
        this._jspBuilder.setJsfPropertyGroup(this._jsfPropertyGroup);
        this._jspBuilder.setTagManager(this._tagManager);
        this._jspBuilder.setPageConfig(pageConfig);
        this._jspBuilder.setPrototype(this._isPrototype);
        this._parser = new JspParser();
        this._parser.setJspBuilder(this._jspBuilder);
        this._parser.setParseState(this._parseState);
        this._parser.setTagManager(this._tagManager);
        this._jspBuilder.setJspParser(this._parser);
    }

    public Page compile() throws Exception {
        LineMap lineMap = null;
        if (this._page != null) {
            throw new IllegalStateException("JspCompilerInstance cannot be reused");
        }
        try {
            Page page;
            JspGenerator generator = this.generate();
            lineMap = generator.getLineMap();
            String encoding = this._parseState.getCharEncoding();
            this._jspCompiler.compilePending();
            boolean isAutoCompile = true;
            if (this._jspPropertyGroup != null) {
                isAutoCompile = this._jspPropertyGroup.isAutoCompile();
            }
            if (!generator.isStatic()) {
                this.compileJava(this._jspPath, this._className, lineMap, encoding);
                page = this._jspCompiler.loadPage(this._className, isAutoCompile);
            } else {
                page = this._jspCompiler.loadStatic(this._className, this._parseState.isOptionalSession());
                page._caucho_addDepend(generator.getDependList());
                page._caucho_setContentType(this._parseState.getContentType());
            }
            return page;
        }
        catch (JspParseException e) {
            e.setLineMap(lineMap);
            e.setErrorPage(this._parseState.getErrorPage());
            throw e;
        }
        catch (SAXException e) {
            if (e.getCause() instanceof JspParseException) {
                JspParseException subE = (JspParseException)((Object)e.getCause());
                subE.setLineMap(lineMap);
                subE.setErrorPage(this._parseState.getErrorPage());
                throw subE;
            }
            JspParseException exn = new JspParseException(e);
            exn.setErrorPage(this._parseState.getErrorPage());
            exn.setLineMap(lineMap);
            throw exn;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            JspParseException exn = new JspParseException(e);
            exn.setLineMap(lineMap);
            exn.setErrorPage(this._parseState.getErrorPage());
            throw exn;
        }
        catch (Throwable e) {
            JspParseException exn = new JspParseException(e);
            exn.setLineMap(lineMap);
            exn.setErrorPage(this._parseState.getErrorPage());
            throw exn;
        }
    }

    public JspGenerator generate() throws Exception {
        if (this._page != null) {
            throw new IllegalStateException("JspCompilerInstance cannot be reused");
        }
        this.parse();
        try {
            JspGenerator generator = this._jspBuilder.getGenerator();
            generator.setJspCompilerInstance(this);
            for (int i = 0; i < this._dependList.size(); ++i) {
                generator.addDepend(this._dependList.get(i));
            }
            generator.validate();
            generator.generate(this._jspPath, this._className);
            return generator;
        }
        catch (IOException e) {
            JspParseException exn = new JspParseException(e);
            exn.setErrorPage(this._parseState.getErrorPage());
            throw exn;
        }
    }

    public void parse() throws Exception {
        boolean isXml = this._parseState.isXml();
        boolean isForbidXml = this._parseState.isForbidXml();
        ParseState parseState = this._parser.getParseState();
        try {
            this._parser.getParseState().setBuilder(this._jspBuilder);
            for (String prelude : this._preludeList) {
                parseState.setXml(false);
                parseState.setForbidXml(false);
                this._parser.parse(parseState.getResourceManager().resolvePath(prelude), prelude);
            }
            this._parser.getParseState().setXml(isXml);
            this._parser.getParseState().setForbidXml(isForbidXml);
            if (isXml) {
                if (this._parseState.getELIgnoredDefault() == null) {
                    this._parseState.setELIgnoredDefault(false);
                }
                Xml xml = new Xml();
                this._parseState.setXml(xml);
                xml.setContentHandler(new JspContentHandler(this._jspBuilder));
                this._jspPath.setUserPath(this._uri);
                xml.setNamespaceAware(true);
                xml.setDtdValidating(true);
                xml.parse(this._jspPath);
            } else {
                WebApp app = this._jspCompiler.getWebApp();
                if (app != null && app.hasPre23Config() && this._parseState.getELIgnoredDefault() == null) {
                    this._parseState.setELIgnoredDefault(true);
                }
                this._parser.parse(this._jspPath, this._uri);
            }
            for (String coda : this._codaList) {
                parseState.setXml(false);
                parseState.setForbidXml(false);
                this._parser.parse(parseState.getResourceManager().resolvePath(coda), coda);
            }
        }
        catch (JspParseException e) {
            e.setErrorPage(this._parseState.getErrorPage());
            throw e;
        }
        catch (SAXException e) {
            if (e.getCause() instanceof JspParseException) {
                JspParseException subE = (JspParseException)((Object)e.getCause());
                subE.setErrorPage(this._parseState.getErrorPage());
                throw subE;
            }
            JspParseException exn = new JspParseException(e);
            exn.setErrorPage(this._parseState.getErrorPage());
            throw exn;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            JspParseException exn = new JspParseException(e);
            exn.setErrorPage(this._parseState.getErrorPage());
            throw exn;
        }
    }

    public TagInfo compileTag(TagTaglib taglib) throws Exception {
        TagInfo preloadTag = this.preloadTag(taglib);
        if (preloadTag != null) {
            return preloadTag;
        }
        return this.generateTag(taglib);
    }

    private TagInfo preloadTag(TagLibraryInfo taglib) {
        try {
            JspTagSupport tag = (JspTagSupport)((Object)this._jspCompiler.loadClass(this._className, true));
            if (tag == null) {
                return null;
            }
            tag.init(this._jspCompiler.getAppDir());
            if (tag._caucho_isModified()) {
                return null;
            }
            return tag._caucho_getTagInfo(taglib);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private TagInfo generateTag(TagTaglib taglib) throws Exception {
        LineMap lineMap = null;
        if (this._page != null) {
            throw new IllegalStateException("JspCompilerInstance cannot be reused");
        }
        try {
            boolean isXml = this._isXml;
            if (this._jspPropertyGroup != null && !isXml && this._jspPropertyGroup.isXml() != null) {
                isXml = Boolean.TRUE.equals(this._jspPropertyGroup.isXml());
            }
            if (this._jspPropertyGroup != null && Boolean.FALSE.equals(this._jspPropertyGroup.isXml())) {
                this._parseState.setForbidXml(true);
            }
            this._parseState.setXml(isXml);
            if (this._jspCompiler.addTag(this._className)) {
                this._isPrototype = true;
                this._jspBuilder.setPrototype(true);
            }
            this._parseState.setTag(true);
            this._isXml = isXml;
            Path implicitTld = this._jspPath.lookup(this._jspPath.getParent() + "/implicit.tld");
            taglib.setJspVersion("2.0");
            if (implicitTld.canRead()) {
                Config config = new Config();
                ImplicitTld tldTaglib = new ImplicitTld();
                config.configure((Object)tldTaglib, implicitTld);
                if (tldTaglib.getJspVersion() != null && tldTaglib.getJspVersion().compareTo("2.0") < 0) {
                    throw new ConfigException(L.l("'{0}' must have a jsp-version 2.0 or greater", implicitTld));
                }
                taglib.setJspVersion(tldTaglib.getJspVersion());
            }
            if (taglib.getRequiredVersion().compareTo("2.1") < 0) {
                this._parseState.setJspVersion("2.0");
                this._parseState.setDeferredSyntaxAllowedAsLiteral(true);
            }
            if (isXml) {
                this._parseState.setELIgnoredDefault(false);
                Xml xml = new Xml();
                this._parseState.setXml(xml);
                xml.setContentHandler(new JspContentHandler(this._jspBuilder));
                this._jspPath.setUserPath(this._uri);
                xml.setNamespaceAware(true);
                xml.setDtdValidating(true);
                xml.parse(this._jspPath);
            } else {
                this._parser.parseTag(this._jspPath, this._uri);
            }
            this._generator = this._jspBuilder.getGenerator();
            if (this._isPrototype) {
                return this._generator.generateTagInfo(this._className, taglib);
            }
            this._generator.validate();
            this._generator.generate(this._jspPath, this._className);
            if (this._jspCompiler.hasRecursiveCompile()) {
                this._jspCompiler.addPending(this);
                return this._generator.generateTagInfo(this._className, taglib);
            }
            return this.completeTag(taglib);
        }
        catch (JspParseException e) {
            e.setLineMap(lineMap);
            e.setErrorPage(this._parseState.getErrorPage());
            throw e;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            JspParseException exn = new JspParseException(e);
            exn.setErrorPage(this._parseState.getErrorPage());
            exn.setLineMap(lineMap);
            throw exn;
        }
    }

    TagInfo completeTag() throws Exception {
        return this.completeTag(new TagTaglib("x", "uri"));
    }

    TagInfo completeTag(TagLibraryInfo taglib) throws Exception {
        LineMap lineMap = null;
        try {
            lineMap = this._generator.getLineMap();
            String encoding = this._parseState.getCharEncoding();
            this.compileJava(this._jspPath, this._className, lineMap, encoding);
            JspTagSupport tag = (JspTagSupport)((Object)this._jspCompiler.loadClass(this._className, true));
            tag.init(this._jspCompiler.getAppDir());
            return tag._caucho_getTagInfo(taglib);
        }
        catch (JspParseException e) {
            e.setLineMap(lineMap);
            e.setErrorPage(this._parseState.getErrorPage());
            throw e;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            JspParseException exn = new JspParseException(e);
            exn.setErrorPage(this._parseState.getErrorPage());
            exn.setLineMap(lineMap);
            throw exn;
        }
        catch (Throwable e) {
            JspParseException exn = new JspParseException(e);
            exn.setErrorPage(this._parseState.getErrorPage());
            exn.setLineMap(lineMap);
            throw exn;
        }
    }

    private void compileJava(Path path, String className, LineMap lineMap, String charEncoding) throws Exception {
        JavaCompiler compiler = JavaCompiler.create(null);
        compiler.setClassDir(this._jspCompiler.getClassDir());
        String fileName = className.replace('.', '/') + ".java";
        compiler.compile(fileName, lineMap);
        Path classDir = this._jspCompiler.getClassDir();
        Path classPath = classDir.lookup(className.replace('.', '/') + ".class");
        Path smapPath = classDir.lookup(fileName + ".smap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSmap(ClassLoader loader, String className) {
        if (loader == null) {
            return;
        }
        String smapName = className.replace('.', '/') + ".java.smap";
        InputStream is = null;
        try {
            is = loader.getResourceAsStream(smapName);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

