/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.LineMap;
import com.caucho.jsp.JspBuilder;
import com.caucho.jsp.JspGenerator;
import com.caucho.jsp.JspLineParseException;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.Namespace;
import com.caucho.jsp.ParseState;
import com.caucho.jsp.ParseTagManager;
import com.caucho.jsp.Taglib;
import com.caucho.jsp.java.JspNode;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspParser {
    static L10N L = new L10N(JspParser.class);
    private static final Logger log = Logger.getLogger(JspParser.class.getName());
    public static final String JSP_NS = "http://java.sun.com/JSP/Page";
    public static final String JSTL_CORE_URI = "http://java.sun.com/jsp/jstl/core";
    public static final String JSTL_FMT_URI = "http://java.sun.com/jsp/jstl/fmt";
    public static final QName PREFIX = new QName("prefix");
    public static final QName TAGLIB = new QName("taglib");
    public static final QName TAGDIR = new QName("tagdir");
    public static final QName URI = new QName("uri");
    public static final QName JSP_DECLARATION = new QName("jsp", "declaration", "http://java.sun.com/JSP/Page");
    public static final QName JSP_SCRIPTLET = new QName("jsp", "scriptlet", "http://java.sun.com/JSP/Page");
    public static final QName JSP_EXPRESSION = new QName("jsp", "expression", "http://java.sun.com/JSP/Page");
    public static final QName JSP_DIRECTIVE_PAGE = new QName("jsp", "directive.page", "http://java.sun.com/JSP/Page");
    public static final QName JSP_DIRECTIVE_INCLUDE = new QName("jsp", "directive.include", "http://java.sun.com/JSP/Page");
    public static final QName JSP_DIRECTIVE_CACHE = new QName("jsp", "directive.cache", "http://java.sun.com/JSP/Page");
    public static final QName JSP_DIRECTIVE_TAGLIB = new QName("jsp", "directive.taglib", "http://java.sun.com/JSP/Page");
    public static final QName JSP_DIRECTIVE_ATTRIBUTE = new QName("jsp", "directive.attribute", "http://java.sun.com/JSP/Page");
    public static final QName JSP_DIRECTIVE_VARIABLE = new QName("jsp", "directive.variable", "http://java.sun.com/JSP/Page");
    public static final QName JSP_DIRECTIVE_TAG = new QName("jsp", "directive.tag", "http://java.sun.com/JSP/Page");
    public static final QName JSTL_CORE_OUT = new QName("resin-c", "out", "urn:jsptld:http://java.sun.com/jsp/jstl/core");
    public static final QName JSTL_CORE_CHOOSE = new QName("resin-c", "choose", "urn:jsptld:http://java.sun.com/jsp/jstl/core");
    public static final QName JSTL_CORE_WHEN = new QName("resin-c", "when", "urn:jsptld:http://java.sun.com/jsp/jstl/core");
    public static final QName JSTL_CORE_OTHERWISE = new QName("resin-c", "otherwise", "urn:jsptld:http://java.sun.com/jsp/jstl/core");
    public static final QName JSTL_CORE_FOREACH = new QName("resin-c", "forEach", "urn:jsptld:http://java.sun.com/jsp/jstl/core");
    private static final int TAG_UNKNOWN = 0;
    private static final int TAG_JSP = 1;
    private static final int TAG_RAW = 2;
    private ParseState _parseState;
    private JspBuilder _jspBuilder;
    private ParseTagManager _tagManager;
    private LineMap _lineMap;
    private ArrayList<String> _preludeList = new ArrayList();
    private ArrayList<String> _codaList = new ArrayList();
    private ArrayList<Include> _includes = new ArrayList();
    private Set<String> _prefixes = new HashSet<String>();
    private Set<String> _localPrefixes = new HashSet<String>();
    private Path _jspPath;
    private ReadStream _stream;
    private String _uriPwd;
    private String _contextPath = "";
    private String _filename = "";
    private int _line;
    private int _lineStart;
    private int _charCount;
    private int _startText;
    private int _peek = -1;
    private boolean _seenCr = false;
    private Namespace _namespaces = new Namespace(null, "jsp", "http://java.sun.com/JSP/Page");
    private boolean _isXml;
    private boolean _isTop = true;
    private CharBuffer _tag = new CharBuffer();
    private CharBuffer _value = new CharBuffer();
    private CharBuffer _text = new CharBuffer();

    void setJspBuilder(JspBuilder builder) {
        this._jspBuilder = builder;
    }

    void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    void setParseState(ParseState parseState) {
        this._parseState = parseState;
    }

    ParseState getParseState() {
        return this._parseState;
    }

    void setTagManager(ParseTagManager manager) {
        this._tagManager = manager;
    }

    private boolean isELIgnored() {
        return this._parseState.isELIgnored();
    }

    private boolean isVelocity() {
        return this._parseState.isVelocityEnabled();
    }

    private boolean isDeferredSyntaxAllowedAsLiteral() {
        return this._parseState.isDeferredSyntaxAllowedAsLiteral();
    }

    public void addPrelude(String prelude) {
        this._preludeList.add(prelude);
    }

    public void addCoda(String coda) {
        this._codaList.add(coda);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(Path path, String uri) throws Exception {
        int p;
        this._parseState.pushNamespace("jsp", JSP_NS);
        this._isXml = this._parseState.isXml();
        this._filename = this._contextPath + uri;
        this._uriPwd = uri != null ? ((p = uri.lastIndexOf(47)) <= 0 ? "/" : uri.substring(0, p + 1)) : "/";
        this._parseState.setUriPwd(this._uriPwd);
        ReadStream is = path.openRead();
        path.setUserPath(uri);
        try {
            this.parseJsp(is);
            is.close();
        }
        catch (Throwable throwable) {
            is.close();
            for (int i = 0; i < this._includes.size(); ++i) {
                Include inc = this._includes.get(i);
                inc._stream.close();
            }
            throw throwable;
        }
        for (int i = 0; i < this._includes.size(); ++i) {
            Include inc = this._includes.get(i);
            inc._stream.close();
        }
    }

    void parseTag(Path path, String uri) throws Exception {
        this._parseState.setTag(true);
        this.parse(path, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseJsp(ReadStream stream) throws Exception {
        int i;
        this._text.clear();
        this._includes.clear();
        String uriPwd = this._uriPwd;
        for (i = this._codaList.size() - 1; i >= 0; --i) {
            this.pushInclude(this._codaList.get(i), true);
        }
        this.addInclude(stream, uriPwd);
        for (i = this._preludeList.size() - 1; i >= 0; --i) {
            this.pushInclude(this._preludeList.get(i), true);
        }
        this.setLocation();
        this._jspBuilder.startDocument();
        String pageEncoding = this._parseState.getPageEncoding();
        if (pageEncoding != null) {
            this._parseState.setPageEncoding(pageEncoding);
            stream.setEncoding(pageEncoding);
        }
        int ch = stream.read();
        switch (ch) {
            case 254: {
                ch = stream.read();
                if (ch != 255) {
                    throw this.error(L.l("Expected 0xff in UTF-16 header.  UTF-16 pages with the initial byte 0xfe expect 0xff immediately following.  The 0xfe 0xff sequence is used by some application to suggest UTF-16 encoding without a directive."));
                }
                log.finer(L.l("JSP '{0}': setting page encoding using BOM 'fe ff' -> 'UTF-16BE'", this._jspPath.toString()));
                this._parseState.setBom(65279);
                this._parseState.setPageEncoding("UTF-16BE");
                stream.setEncoding("UTF-16BE");
                break;
            }
            case 255: {
                ch = stream.read();
                if (ch != 254) {
                    throw this.error(L.l("Expected 0xfe in UTF-16 header.  UTF-16 pages with the initial byte 0xff expect 0xfe immediately following.  The 0xff 0xfe sequence is used by some application to suggest UTF-16 encoding without a directive."));
                }
                log.finer(L.l("JSP '{0}': setting page encoding using BOM 'ff fe' -> 'UTF-16LE'", this._jspPath.toString()));
                this._parseState.setBom(65534);
                this._parseState.setPageEncoding("UTF-16LE");
                stream.setEncoding("UTF-16LE");
                break;
            }
            case 239: {
                ch = stream.read();
                if (ch != 187) {
                    stream.unread();
                    stream.unread();
                    break;
                }
                ch = stream.read();
                if (ch != 191) {
                    throw this.error(L.l("Expected 0xbf in UTF-8 header.  UTF-8 pages with the initial byte 0xbb expect 0xbf immediately following.  The 0xbb 0xbf sequence is used by some application to suggest UTF-8 encoding without a directive."));
                }
                log.finer(L.l("JSP '{0}': setting page encoding using BOM 'ef bb bf' -> 'UTF-8'", this._jspPath.toString()));
                this._parseState.setBom(0xEFBBBF);
                this._parseState.setPageEncoding("UTF-8");
                stream.setEncoding("UTF-8");
                break;
            }
            case -1: {
                break;
            }
            default: {
                stream.unread();
            }
        }
        ch = this.read();
        ch = this.parseXmlDeclaration(ch);
        try {
            this.parseNode(ch);
        }
        catch (Throwable throwable) {
            for (int i2 = 0; i2 < this._includes.size(); ++i2) {
                Include inc = this._includes.get(i2);
                inc._stream.close();
            }
            throw throwable;
        }
        for (int i3 = 0; i3 < this._includes.size(); ++i3) {
            Include inc = this._includes.get(i3);
            inc._stream.close();
        }
        this.setLocation();
        this._jspBuilder.endDocument();
    }

    private int parseXmlDeclaration(int ch) throws IOException, JspParseException {
        if (ch != 60) {
            return ch;
        }
        ch = this.read();
        if (ch != 63) {
            this.unread(ch);
            return 60;
        }
        ch = this.read();
        if (ch != 120) {
            this.addText("<?");
            return ch;
        }
        ch = this.read();
        if (ch != 109) {
            this.addText("<?x");
            return ch;
        }
        ch = this.read();
        if (ch != 108) {
            this.addText("<?xm");
            return ch;
        }
        ch = this.read();
        if (!XmlChar.isWhitespace(ch)) {
            this.addText("<?xml");
            return ch;
        }
        String encoding = null;
        this.addText("<?xml ");
        ch = this.skipWhitespace(ch);
        while (XmlChar.isNameStart(ch)) {
            ch = this.readName(ch);
            String name = this._tag.toString();
            this.addText(name);
            if (XmlChar.isWhitespace(ch)) {
                this.addText(' ');
            }
            if ((ch = this.skipWhitespace(ch)) != 61) {
                return ch;
            }
            this.readValue(name, ch, true);
            String value = this._value.toString();
            this.addText("=\"");
            this.addText(value);
            this.addText("\"");
            if (name.equals("encoding")) {
                encoding = value;
            }
            if (XmlChar.isWhitespace(ch = this.read())) {
                this.addText(' ');
            }
            ch = this.skipWhitespace(ch);
        }
        if (ch != 63) {
            return ch;
        }
        ch = this.read();
        if (ch != 62) {
            this.addText('?');
            return ch;
        }
        this.addText("?>");
        if (encoding != null) {
            this._stream.setEncoding(encoding);
            this._parseState.setPageEncoding(encoding);
        }
        return this.read();
    }

    private void parseNode(int ch) throws IOException, JspParseException {
        block18: while (ch != -1) {
            switch (ch) {
                case 60: {
                    ch = this.read();
                    switch (ch) {
                        case 37: {
                            if (this._isXml) {
                                throw this.error(L.l("'<%' syntax is not allowed in JSP/XML syntax."));
                            }
                            this.parseScriptlet();
                            this._startText = this._charCount;
                            ch = this.read();
                            if (ch != 92) continue block18;
                            ch = this.read();
                            if (ch == 10) {
                                ch = this.read();
                                continue block18;
                            }
                            if (ch == 13) {
                                ch = this.read();
                                if (ch != 10) continue block18;
                                ch = this.read();
                                continue block18;
                            }
                            this.addText('\\');
                            continue block18;
                        }
                        case 47: {
                            ch = this.parseCloseTag();
                            continue block18;
                        }
                        case 92: {
                            ch = this.read();
                            if (ch == 37) {
                                this.addText("<%");
                                ch = this.read();
                                continue block18;
                            }
                            this.addText("<\\");
                            continue block18;
                        }
                        case 33: {
                            if (!this._isXml) {
                                this.addText("<!");
                            } else {
                                ch = this.read();
                                if (ch == 91) {
                                    this.parseCdata();
                                } else if (ch == 45 && (ch = this.read()) == 45) {
                                    this.parseXmlComment();
                                } else {
                                    throw this.error(L.l("'{0}' was not expected after '<!'.  In the XML syntax, only <!-- ... --> and <![CDATA[ ... ]> are legal.  You can use '&amp;!' to escape '<!'.", this.badChar(ch)));
                                }
                            }
                            ch = this.read();
                            continue block18;
                        }
                    }
                    if (!XmlChar.isNameStart(ch)) {
                        this.addText('<');
                        continue block18;
                    }
                    ch = this.readName(ch);
                    String name = this._tag.toString();
                    int tagCode = this.getTag(name);
                    if (!this._isXml && tagCode == 0) {
                        this.addText("<");
                        this.addText(name);
                        continue block18;
                    }
                    if (this._isTop && name.equals("jsp:root")) {
                        if (this._parseState.isForbidXml()) {
                            throw this.error(L.l("jsp:root must be in a JSP (XML) document, not a plain JSP."));
                        }
                        this._text.clear();
                        this._isXml = true;
                        this._parseState.setELIgnoredDefault(false);
                        this._parseState.setXml(true);
                    }
                    this._isTop = false;
                    this.parseOpenTag(name, ch, tagCode == 0);
                    ch = this.read();
                    if (this._isXml || ch != 92) continue block18;
                    ch = this.read();
                    if (ch == 10) {
                        ch = this.read();
                        continue block18;
                    }
                    if (ch != 13 || (ch = this.read()) != 10) continue block18;
                    ch = this.read();
                    continue block18;
                }
                case 38: {
                    if (!this._isXml) {
                        this.addText((char)ch);
                    } else {
                        this.addText((char)this.parseEntity());
                    }
                    ch = this.read();
                    continue block18;
                }
                case 36: {
                    ch = this.read();
                    if (ch == 123 && !this.isELIgnored()) {
                        ch = this.parseJspExpression();
                        continue block18;
                    }
                    this.addText('$');
                    continue block18;
                }
                case 35: {
                    ch = this.read();
                    if (this.isVelocity()) {
                        ch = this.parseVelocity(ch);
                        continue block18;
                    }
                    if (ch != 123 || this.isELIgnored()) {
                        this.addText('#');
                        continue block18;
                    }
                    if (this.isDeferredSyntaxAllowedAsLiteral()) {
                        this.addText('#');
                        continue block18;
                    }
                    throw this.error(L.l("Deferred syntax ('#{...}') not allowed as literal."));
                }
                case 92: {
                    ch = this.read();
                    switch (ch) {
                        case 36: {
                            if (!this.isELIgnored()) {
                                this.addText('$');
                                ch = this.read();
                                continue block18;
                            }
                            this.addText('\\');
                            continue block18;
                        }
                        case 35: {
                            if (!this.isELIgnored()) {
                                this.addText('#');
                                ch = this.read();
                                continue block18;
                            }
                            this.addText('\\');
                            continue block18;
                        }
                        case 92: {
                            this.addText('\\');
                            continue block18;
                        }
                    }
                    this.addText('\\');
                    continue block18;
                }
            }
            this.addText((char)ch);
            ch = this.read();
        }
        this.addText();
    }

    private int parseJspExpression() throws IOException, JspParseException {
        this.addText();
        Path jspPath = this._jspPath;
        String filename = this._filename;
        int line = this._line;
        CharBuffer cb = CharBuffer.allocate();
        cb.append("${");
        int ch = this.read();
        while (ch >= 0 && ch != 125) {
            cb.append((char)ch);
            ch = this.read();
        }
        cb.append("}");
        ch = this.read();
        String prefix = this._parseState.findPrefix(JSTL_CORE_URI);
        if (prefix == null) {
            prefix = "resin-c";
            this._jspBuilder.addNamespace(prefix, JSTL_CORE_URI);
            this.processTaglib(prefix, JSTL_CORE_URI);
        }
        this.setLocation(jspPath, filename, line);
        this._jspBuilder.startElement(JSTL_CORE_OUT);
        this._jspBuilder.attribute(new QName("value"), cb.close());
        this._jspBuilder.attribute(new QName("escapeXml"), "false");
        this._jspBuilder.endAttributes();
        this._jspBuilder.endElement(JSTL_CORE_OUT.getName());
        return ch;
    }

    private int parseVelocity(int ch) throws IOException, JspParseException {
        if (ch == 123) {
            return this.parseVelocityScriptlet();
        }
        if (97 <= ch && ch <= 122) {
            ch = this.readName(ch);
            String name = this._tag.toString();
            if (name.equals("if")) {
                ch = this.parseVelocityIf("if");
            } else if (name.equals("elseif")) {
                this.addText();
                this.setLocation();
                JspNode node = this._jspBuilder.getCurrentNode();
                if (!"resin-c:when".equals(node.getTagName())) {
                    throw this.error(L.l("#elseif is missing a corresponding #if.  Velocity-style #if syntax needs matching #if ... #elseif ... #else ... #end.  The #if statements must also nest properly with any tags."));
                }
                this._jspBuilder.endElement("resin-c:when");
                ch = this.parseVelocityIf("elseif");
            } else if (name.equals("else")) {
                this.addText();
                this.setLocation();
                this._jspBuilder.endElement("resin-c:when");
                this.setLocation(this._jspPath, this._filename, this._lineStart);
                this._lineStart = this._line;
                this._jspBuilder.startElement(JSTL_CORE_OTHERWISE);
                this._jspBuilder.endAttributes();
                ch = this.skipWhitespaceToEndOfLine(ch);
            } else if (name.equals("foreach")) {
                ch = this.parseVelocityForeach("resin-c:forEach");
            } else if (name.equals("end")) {
                this.addText();
                JspNode node = this._jspBuilder.getCurrentNode();
                String nodeName = null;
                if (node != null) {
                    nodeName = node.getTagName();
                }
                if (nodeName.equals("resin-c:when") || nodeName.equals("resin-c:otherwise")) {
                    this._jspBuilder.endElement(nodeName);
                    this._jspBuilder.endElement(JSTL_CORE_CHOOSE.getName());
                } else if (nodeName.equals("resin-c:forEach")) {
                    this._jspBuilder.endElement(nodeName);
                } else {
                    throw this.error(L.l("#end is missing a corresponding #if or #foreach.  Velocity-style #if syntax needs matching #if ... #elseif ... #else ... #end. The #if statements must also nest properly with any tags."));
                }
                ch = this.skipWhitespaceToEndOfLine(ch);
            } else {
                this.addText('#');
                this.addText(name);
            }
        } else {
            this.addText('#');
        }
        return ch;
    }

    private int parseVelocityScriptlet() throws IOException, JspParseException {
        this.addText();
        this.setLocation(this._jspPath, this._filename, this._line);
        this._lineStart = this._line;
        this._jspBuilder.startElement(JSP_SCRIPTLET);
        this._jspBuilder.endAttributes();
        int ch = this.read();
        while (ch >= 0) {
            if (ch == 125) {
                ch = this.read();
                if (ch == 35) break;
                this.addText('}');
                continue;
            }
            this.addText((char)ch);
            ch = this.read();
        }
        this.createText();
        this._jspBuilder.endElement(JSP_SCRIPTLET.getName());
        ch = this.read();
        if (ch == 13) {
            ch = this.read();
            if (ch == 10) {
                return this.read();
            }
            return ch;
        }
        if (ch == 10) {
            return this.read();
        }
        return ch;
    }

    private int parseVelocityForeach(String eltName) throws IOException, JspParseException {
        int ch = this.read();
        while (XmlChar.isWhitespace(ch)) {
            ch = this.read();
        }
        if (ch != 40) {
            throw this.error(L.l("Expected `(' after #foreach at `{0}'.  The velocity-style #foreach syntax needs parentheses: #foreach ($a in expr)", this.badChar(ch)));
        }
        this.addText();
        this.processTaglib("resin-c", JSTL_CORE_URI);
        this.setLocation(this._jspPath, this._filename, this._lineStart);
        this._lineStart = this._line;
        this._jspBuilder.startElement(JSTL_CORE_FOREACH);
        CharBuffer cb = CharBuffer.allocate();
        this.parseVelocityName(cb);
        if (cb.length() == 0) {
            throw this.error(L.l("Expected iteration variable for #foreach at `{0}'.  The velocity-style #foreach syntax is: #foreach ($a in expr)", this.badChar(ch)));
        }
        String name = cb.toString();
        cb.clear();
        this.parseVelocityName(cb);
        if (cb.length() == 0) {
            throw this.error(L.l("Expected 'in' for #foreach at `{0}'.  The velocity-style #foreach syntax is: #foreach ($a in expr)", this.badChar(ch)));
        }
        String value = cb.toString();
        if (!value.equals("in")) {
            throw this.error(L.l("Expected 'in' for #foreach at `{0}'.  The velocity-style #foreach syntax is: #foreach ($a in expr)", this.badChar(ch)));
        }
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        this._jspBuilder.attribute(new QName("var"), name);
        cb.clear();
        this.parseVelocityExpr(cb, 41);
        String expr = cb.close();
        if (expr.indexOf("..") > 0) {
            int h = 0;
            while (Character.isWhitespace(expr.charAt(h))) {
                ++h;
            }
            if (expr.charAt(h) != '[') {
                throw this.error(L.l("Expected '[' for #foreach `{0}'.  The velocity-style #foreach syntax is: #foreach ([Type] $a in [min .. max])", this.badChar(expr.charAt(h))));
            }
            int t = expr.length() - 1;
            while (Character.isWhitespace(expr.charAt(t))) {
                --t;
            }
            if (expr.charAt(t) != ']') {
                throw this.error(L.l("Expected ']' for #foreach `{0}'.  The velocity-style #foreach syntax is: #foreach ($a in [min .. max])", this.badChar(expr.charAt(t))));
            }
            int p = expr.indexOf("..");
            String min = expr.substring(h + 1, p);
            String max = expr.substring(p + 2, t);
            this._jspBuilder.attribute(new QName("begin"), "${" + min + "}");
            this._jspBuilder.attribute(new QName("end"), "${" + max + "}");
        } else {
            this._jspBuilder.attribute(new QName("items"), "${" + expr + "}");
        }
        this._jspBuilder.endAttributes();
        return this.skipWhitespaceToEndOfLine(this.read());
    }

    private int parseVelocityIf(String eltName) throws IOException, JspParseException {
        int ch = this.read();
        while (XmlChar.isWhitespace(ch)) {
            ch = this.read();
        }
        if (ch != 40) {
            throw this.error(L.l("Expected `(' after #if at `{0}'.  The velocity-style #if syntax needs parentheses: #if (...)", this.badChar(ch)));
        }
        this.addText();
        this.processTaglib("resin-c", JSTL_CORE_URI);
        this.setLocation(this._jspPath, this._filename, this._line);
        if (eltName.equals("if")) {
            this._jspBuilder.startElement(JSTL_CORE_CHOOSE);
            this._jspBuilder.endAttributes();
        }
        this._jspBuilder.startElement(JSTL_CORE_WHEN);
        this._lineStart = this._line;
        CharBuffer cb = CharBuffer.allocate();
        this.parseVelocityExpr(cb, 41);
        this._jspBuilder.attribute(new QName("test"), "${" + cb.close() + "}");
        this._jspBuilder.endAttributes();
        return this.skipWhitespaceToEndOfLine(this.read());
    }

    private int parseVelocityName(CharBuffer cb) throws IOException, JspParseException {
        int ch = this.read();
        while (XmlChar.isWhitespace(ch)) {
            ch = this.read();
        }
        while (Character.isJavaIdentifierPart((char)ch)) {
            cb.append((char)ch);
            ch = this.read();
        }
        return ch;
    }

    private int parseVelocityMin(CharBuffer cb) throws IOException, JspParseException {
        int ch = this.read();
        while (ch >= 0) {
            if (ch != 36) {
                cb.append((char)ch);
            }
            if (ch == 40) {
                ch = this.parseVelocityExpr(cb, 41);
                cb.append((char)ch);
            } else if (ch == 91) {
                ch = this.parseVelocityExpr(cb, 93);
                cb.append((char)ch);
            } else if (ch == 46) {
                ch = this.read();
                if (ch == 46) {
                    return ch;
                }
                cb.append('.');
                this._peek = ch;
            }
            ch = this.read();
        }
        return ch;
    }

    private int parseVelocityExpr(CharBuffer cb, int end) throws IOException, JspParseException {
        int ch = this.read();
        while (ch >= 0 && ch != end) {
            if (ch != 36) {
                cb.append((char)ch);
            }
            if (ch == 40) {
                ch = this.parseVelocityExpr(cb, 41);
                cb.append((char)ch);
            } else if (ch == 91) {
                ch = this.parseVelocityExpr(cb, 93);
                cb.append((char)ch);
            }
            ch = this.read();
        }
        return ch;
    }

    private void parseCdata() throws IOException, JspParseException {
        int ch = this.readName(this.read());
        String name = this._tag.toString();
        if (!name.equals("CDATA")) {
            throw this.error(L.l("Expected <![CDATA[ at <!['{0}'.", (Object)name, "XML only recognizes the <![CDATA directive."));
        }
        if (ch != 91) {
            throw this.error(L.l("Expected '[' at '{0}'.  The XML CDATA syntax is <![CDATA[...]]>.", String.valueOf(ch)));
        }
        String filename = this._filename;
        int line = this._line;
        while ((ch = this.read()) >= 0) {
            while (ch == 93) {
                ch = this.read();
                if (ch != 93) {
                    this.addText(']');
                    continue;
                }
                ch = this.read();
                if (ch != 62) {
                    this.addText("]]");
                    continue;
                }
                return;
            }
            this.addText((char)ch);
        }
        throw this.error(L.l("Expected closing ]]> at end of file to match <![[CDATA at {0}.", filename + ":" + line));
    }

    private int readName(int ch) throws IOException, JspParseException {
        this._tag.clear();
        while (XmlChar.isNameChar((char)ch)) {
            this._tag.append((char)ch);
            ch = this.read();
        }
        return ch;
    }

    private void parsePageDirective(String name, String value) throws IOException, JspParseException {
        if ("isELIgnored".equals(name) && "true".equals(value)) {
            this._parseState.setELIgnored(true);
        }
    }

    private void parseScriptlet() throws IOException, JspParseException {
        this.addText();
        this._lineStart = this._line;
        int ch = this.read();
        QName eltName = null;
        switch (ch) {
            case 61: {
                eltName = JSP_EXPRESSION;
                ch = this.read();
                break;
            }
            case 33: {
                eltName = JSP_DECLARATION;
                ch = this.read();
                break;
            }
            case 64: {
                this.parseDirective();
                return;
            }
            case 45: {
                ch = this.read();
                if (ch == 45) {
                    this.parseComment();
                    return;
                }
                eltName = JSP_SCRIPTLET;
                this.addText('-');
                break;
            }
            default: {
                eltName = JSP_SCRIPTLET;
            }
        }
        this.setLocation(this._jspPath, this._filename, this._lineStart);
        this._jspBuilder.startElement(eltName);
        this._jspBuilder.endAttributes();
        block10: while (ch >= 0) {
            switch (ch) {
                case 92: {
                    this.addText('\\');
                    ch = this.read();
                    if (ch >= 0) {
                        this.addText((char)ch);
                    }
                    ch = this.read();
                    continue block10;
                }
                case 37: {
                    ch = this.read();
                    if (ch == 62) {
                        this.createText();
                        this.setLocation();
                        this._jspBuilder.endElement(eltName.getName());
                        return;
                    }
                    if (ch == 92) {
                        ch = this.read();
                        if (ch == 62) {
                            this.addText("%");
                            continue block10;
                        }
                        this.addText("%\\");
                        continue block10;
                    }
                    this.addText('%');
                    continue block10;
                }
            }
            this.addText((char)ch);
            ch = this.read();
        }
        this.createText();
        this.setLocation();
        this._jspBuilder.endElement(eltName.getName());
    }

    private void parseDirective() throws IOException, JspParseException {
        QName qname;
        Object language = null;
        int ch = this.skipWhitespace(this.read());
        String directive = "";
        if (!XmlChar.isNameStart(ch)) {
            throw this.error(L.l("Expected jsp directive name at '{0}'.  JSP directive syntax is <%@ name attr1='value1' ... %>", this.badChar(ch)));
        }
        ch = this.readName(ch);
        directive = this._tag.toString();
        if (directive.equals("page")) {
            qname = JSP_DIRECTIVE_PAGE;
        } else if (directive.equals("include")) {
            qname = JSP_DIRECTIVE_INCLUDE;
        } else if (directive.equals("taglib")) {
            qname = JSP_DIRECTIVE_TAGLIB;
        } else if (directive.equals("cache")) {
            qname = JSP_DIRECTIVE_CACHE;
        } else if (directive.equals("attribute")) {
            qname = JSP_DIRECTIVE_ATTRIBUTE;
        } else if (directive.equals("variable")) {
            qname = JSP_DIRECTIVE_VARIABLE;
        } else if (directive.equals("tag")) {
            qname = JSP_DIRECTIVE_TAG;
        } else {
            throw this.error(L.l("'{0}' is an unknown jsp directive.  Only <%@ page ... %>, <%@ include ... %>, <%@ taglib ... %>, and <%@ cache ... %> are known.", directive));
        }
        this.unread(ch);
        ArrayList<QName> keys = new ArrayList<QName>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<String> uris = new ArrayList<String>();
        this.parseAttributes(keys, values, prefixes, uris);
        ch = this.skipWhitespace(this.read());
        if (ch != 37 || (ch = this.read()) != 62) {
            throw this.error(L.l("expected '%>' at {0}.  JSP directive syntax is '<%@ name attr1='value1' ... %>'.  (Started at line {1})", (Object)this.badChar(ch), this._lineStart));
        }
        this.setLocation(this._jspPath, this._filename, this._lineStart);
        this._lineStart = this._line;
        this._jspBuilder.startElement(qname);
        for (int i = 0; i < keys.size(); ++i) {
            this._jspBuilder.attribute(keys.get(i), values.get(i));
        }
        this._jspBuilder.endAttributes();
        if (qname.equals(JSP_DIRECTIVE_TAGLIB)) {
            this.processTaglibDirective(keys, values);
        }
        this.setLocation();
        this._jspBuilder.endElement(qname.getName());
        if (qname.equals(JSP_DIRECTIVE_PAGE) || qname.equals(JSP_DIRECTIVE_TAG)) {
            String contentEncoding = this._parseState.getPageEncoding();
            if (contentEncoding == null) {
                contentEncoding = this._parseState.getCharEncoding();
            }
            if (contentEncoding != null) {
                try {
                    this._stream.setEncoding(contentEncoding);
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                    throw this.error(L.l("unknown content encoding '{0}'", contentEncoding), e);
                }
            }
        }
    }

    private void parseComment() throws IOException, JspParseException {
        int ch = this.read();
        while (ch >= 0) {
            if (ch == 45) {
                ch = this.read();
                while (ch == 45) {
                    ch = this.read();
                    if (ch == 45) continue;
                    if (ch == 37 && (ch = this.read()) == 62) {
                        return;
                    }
                    if (ch != 45) continue;
                    ch = this.read();
                }
                continue;
            }
            ch = this.read();
        }
    }

    private void parseXmlComment() throws IOException, JspParseException {
        int ch;
        while ((ch = this.read()) >= 0) {
            while (ch == 45) {
                ch = this.read();
                if (ch != 45 || (ch = this.read()) != 62) continue;
                return;
            }
        }
    }

    private void parseOpenTag(String name, int ch, boolean isXml) throws IOException, JspParseException {
        int i;
        this.addText();
        ch = this.skipWhitespace(ch);
        ArrayList<QName> keys = new ArrayList<QName>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<String> uris = new ArrayList<String>();
        this.unread(ch);
        this.parseAttributes(keys, values, prefixes, uris);
        QName qname = this.getElementQName(name);
        this.setLocation(this._jspPath, this._filename, this._lineStart);
        this._lineStart = this._line;
        this._jspBuilder.startElement(qname);
        for (i = 0; i < keys.size(); ++i) {
            QName key = keys.get(i);
            String value = values.get(i);
            this._jspBuilder.attribute(key, value);
        }
        this._jspBuilder.endAttributes();
        for (i = 0; i < prefixes.size(); ++i) {
            String prefix = prefixes.get(i);
            String uri = uris.get(i);
            this._jspBuilder.addNamespace(prefix, uri);
        }
        if (qname.equals(JSP_DIRECTIVE_TAGLIB)) {
            this.processTaglibDirective(keys, values);
        }
        ch = this.skipWhitespace(this.read());
        JspNode node = this._jspBuilder.getCurrentNode();
        if (ch == 47) {
            ch = this.read();
            if (ch != 62) {
                throw this.error(L.l("expected '/>' at '{0}' (for tag '<{1}>' at line {2}).  The XML empty tag syntax is: <tag attr1='value1'/>", this.badChar(ch), name, String.valueOf(this._lineStart)));
            }
            this.setLocation();
            this._jspBuilder.endElement(qname.getName());
        } else {
            if (ch != 62) {
                throw this.error(L.l("expected '>' at '{0}' (for tag '<{1}>' at line {2}).  The XML tag syntax is: <tag attr1='value1'>", this.badChar(ch), name, String.valueOf(this._lineStart)));
            }
            if ("tagdependent".equals(node.getBodyContent()) && !this._isXml) {
                String tail = "</" + name + ">";
                ch = this.read();
                while (ch >= 0) {
                    this._text.append((char)ch);
                    if (this._text.endsWith(tail)) {
                        this._text.setLength(this._text.length() - tail.length());
                        this.addText();
                        this._jspBuilder.endElement(qname.getName());
                        return;
                    }
                    ch = this.read();
                }
                throw this.error(L.l("expected '{0}' at end of file (for tag <{1}> at line {2}).  Tags with 'tagdependent' content need close tags.", (Object)tail, String.valueOf(this._lineStart)));
            }
        }
    }

    private QName getElementQName(String name) {
        int p = name.lastIndexOf(58);
        if (p > 0) {
            String prefix = name.substring(0, p);
            String url = Namespace.find(this._namespaces, prefix);
            this._prefixes.add(prefix);
            if (url != null) {
                return new QName(prefix, name.substring(p + 1), url);
            }
            return new QName("", name, "");
        }
        String url = Namespace.find(this._namespaces, "");
        if (url != null) {
            return new QName("", name, url);
        }
        return new QName("", name, "");
    }

    private QName getAttributeQName(String name) {
        int p = name.lastIndexOf(58);
        if (p > 0) {
            String prefix = name.substring(0, p);
            String url = Namespace.find(this._namespaces, prefix);
            if (url != null) {
                return new QName(prefix, name.substring(p + 1), url);
            }
            return new QName("", name, "");
        }
        return new QName("", name, "");
    }

    private void parseAttributes(ArrayList<QName> names, ArrayList<String> values, ArrayList<String> prefixes, ArrayList<String> uris) throws IOException, JspParseException {
        int ch = this.skipWhitespace(this.read());
        while (XmlChar.isNameStart(ch)) {
            ch = this.readName(ch);
            String key = this._tag.toString();
            this.readValue(key, ch, this._isXml);
            String value = this._value.toString();
            if (key.startsWith("xmlns:")) {
                String prefix = key.substring(6);
                this._jspBuilder.startPrefixMapping(prefix, value);
                prefixes.add(prefix);
                uris.add(value);
                this._namespaces = new Namespace(this._namespaces, prefix, value);
            } else if (key.equals("xmlns")) {
                this._jspBuilder.startPrefixMapping("", value);
                this._namespaces = new Namespace(this._namespaces, "", value);
            } else {
                names.add(this.getAttributeQName(key));
                values.add(value);
            }
            ch = this.skipWhitespace(this.read());
        }
        this.unread(ch);
    }

    private void readValue(String attribute, int ch, boolean isXml) throws IOException, JspParseException {
        boolean isRuntimeAttribute = false;
        this._value.clear();
        ch = this.skipWhitespace(ch);
        if (ch != 61) {
            this.unread(ch);
            return;
        }
        ch = this.skipWhitespace(this.read());
        if (ch != 39 && ch != 34) {
            if (XmlChar.isNameChar(ch)) {
                ch = this.readName(ch);
                throw this.error(L.l("'{0}' attribute value must be quoted at '{1}'.  JSP attribute syntax is either attr=\"value\" or attr='value'.", (Object)attribute, this._tag));
            }
            throw this.error(L.l("'{0}' attribute value must be quoted at '{1}'.  JSP attribute syntax is either attr=\"value\" or attr='value'.", (Object)attribute, this.badChar(ch)));
        }
        int end = ch;
        int lastCh = 0;
        ch = this.read();
        if (ch == 60) {
            ch = this.read();
            if (ch != 37) {
                this._value.append('<');
            } else {
                ch = this.read();
                if (ch != 61) {
                    this._value.append("<%");
                } else {
                    this._value.append("<%");
                    isRuntimeAttribute = true;
                }
            }
        }
        block5: while (ch != -1 && (ch != end || isRuntimeAttribute)) {
            if (ch == 92) {
                ch = this.read();
                switch (ch) {
                    case 34: 
                    case 39: 
                    case 92: {
                        this._value.append((char)ch);
                        ch = this.read();
                        continue block5;
                    }
                    case 62: {
                        if (lastCh == 37) {
                            this._value.append('>');
                            ch = this.read();
                            continue block5;
                        }
                        this._value.append('\\');
                        continue block5;
                    }
                    case 37: {
                        if (lastCh == 60) {
                            this._value.append('%');
                            ch = this.read();
                            continue block5;
                        }
                        this._value.append('\\');
                        continue block5;
                    }
                }
                this._value.append('\\');
                continue;
            }
            if (ch == 37 && isRuntimeAttribute) {
                this._value.append('%');
                ch = this.read();
                if (ch != 62) continue;
                isRuntimeAttribute = false;
                continue;
            }
            if (ch == 38 && isXml) {
                lastCh = -1;
                this._value.append((char)this.parseEntity());
                ch = this.read();
                continue;
            }
            if (ch == 38) {
                ch = this.read();
                if (ch == 97) {
                    ch = this.read();
                    if (ch != 112) {
                        this._value.append("&a");
                        continue;
                    }
                    ch = this.read();
                    if (ch != 111) {
                        this._value.append("&ap");
                        continue;
                    }
                    ch = this.read();
                    if (ch != 115) {
                        this._value.append("&apo");
                        continue;
                    }
                    ch = this.read();
                    if (ch != 59) {
                        this._value.append("&apos");
                        continue;
                    }
                    this._value.append('\'');
                    ch = this.read();
                    continue;
                }
                if (ch == 113) {
                    ch = this.read();
                    if (ch != 117) {
                        this._value.append("&q");
                        continue;
                    }
                    ch = this.read();
                    if (ch != 111) {
                        this._value.append("&qu");
                        continue;
                    }
                    ch = this.read();
                    if (ch != 116) {
                        this._value.append("&quo");
                        continue;
                    }
                    ch = this.read();
                    if (ch != 59) {
                        this._value.append("&quot");
                        continue;
                    }
                    this._value.append('\"');
                    ch = this.read();
                    continue;
                }
                this._value.append('&');
                continue;
            }
            this._value.append((char)ch);
            lastCh = ch;
            ch = this.read();
        }
    }

    int parseEntity() throws IOException, JspParseException {
        String entity;
        int ch = this.read();
        if (this._isXml && ch == 35) {
            int value = 0;
            ch = this.read();
            while (ch >= 48 && ch <= 57) {
                value = 10 * value + ch - 48;
                ch = this.read();
            }
            if (ch != 59) {
                throw this.error(L.l("expected ';' at '{0}' in character entity.  The XML character entities syntax is &#nn;", this.badChar(ch)));
            }
            return (char)value;
        }
        CharBuffer cb = CharBuffer.allocate();
        while (ch >= 97 && ch <= 122) {
            cb.append((char)ch);
            ch = this.read();
        }
        if (ch != 59) {
            log.warning(L.l("expected ';' at '{0}' in entity '&{1}'.  The XML entity syntax is &name;", (Object)this.badChar(ch), cb));
        }
        if ((entity = cb.close()).equals("lt")) {
            return 60;
        }
        if (entity.equals("gt")) {
            return 62;
        }
        if (entity.equals("amp")) {
            return 38;
        }
        if (entity.equals("apos")) {
            return 39;
        }
        if (entity.equals("quot")) {
            return 34;
        }
        throw this.error(L.l("unknown entity '&{0};'.  XML only recognizes the special entities &lt;, &gt;, &amp;, &apos; and &quot;", entity));
    }

    private int parseCloseTag() throws IOException, JspParseException {
        int ch = this.read();
        if (!XmlChar.isNameStart(ch)) {
            this.addText("</");
            return ch;
        }
        ch = this.readName(ch);
        String name = this._tag.toString();
        if (!this._isXml && this.getTag(name) == 0) {
            this.addText("</");
            this.addText(name);
            return ch;
        }
        if ((ch = this.skipWhitespace(ch)) != 62) {
            throw this.error(L.l("expected '>' at {0}.  The XML close tag syntax is </name>.", this.badChar(ch)));
        }
        JspNode node = this._jspBuilder.getCurrentNode();
        String nodeName = node.getTagName();
        if (!nodeName.equals(name)) {
            if (nodeName.equals("resin-c:when")) {
                throw this.error(L.l("#if expects closing #end before </{0}> (#if at {1}).  #if statements require #end before the enclosing tag closes.", (Object)name, String.valueOf(node.getStartLine())));
            }
            if (nodeName.equals("resin-c:otherwise")) {
                throw this.error(L.l("#else expects closing #end before </{0}> (#else at {1}).  #if statements require #end before the enclosing tag closes.", (Object)name, String.valueOf(node.getStartLine())));
            }
            throw this.error(L.l("expected </{0}> at </{1}>.  Closing tags must match opened tags.", (Object)nodeName, name));
        }
        this.addText();
        this.setLocation();
        this._jspBuilder.endElement(name);
        return this.read();
    }

    private void processTaglibDirective(ArrayList<QName> keys, ArrayList<String> values) throws IOException, JspParseException {
        int p = keys.indexOf(PREFIX);
        if (p < 0) {
            throw this.error(L.l("The taglib directive requires a 'prefix' attribute.  'prefix' is the XML prefix for all tags in the taglib."));
        }
        String prefix = values.get(p);
        if (this._prefixes.contains(prefix) && this._parseState.getQName(prefix) == null) {
            throw this.error(L.l("The taglib prefix '{0}' must be defined before it is used.", prefix));
        }
        if (this._localPrefixes.contains(prefix)) {
            throw this.error(L.l("<{0}> cannot occur after an action that uses the same prefix: {1}.", (Object)JSP_DIRECTIVE_TAGLIB.getName(), prefix));
        }
        String uri = null;
        p = keys.indexOf(URI);
        if (p >= 0) {
            uri = values.get(p);
        }
        String tagdir = null;
        p = keys.indexOf(TAGDIR);
        if (p >= 0) {
            tagdir = values.get(p);
        }
        if (uri != null) {
            this.processTaglib(prefix, uri);
        } else if (tagdir != null) {
            this.processTaglibDir(prefix, tagdir);
        }
    }

    private void processTaglib(String prefix, String uri) throws JspParseException {
        Taglib taglib = null;
        int colon = uri.indexOf(58);
        int slash = uri.indexOf(47);
        String location = null;
        location = colon > 0 && colon < slash ? uri : (slash == 0 ? uri : this._uriPwd + uri);
        try {
            taglib = this._tagManager.addTaglib(prefix, uri, location);
            String tldURI = "urn:jsptld:" + uri;
            this._parseState.pushNamespace(prefix, tldURI);
            this._namespaces = new Namespace(this._namespaces, prefix, tldURI);
            return;
        }
        catch (JspParseException e) {
            throw this.error((Exception)((Object)e));
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            if (colon > 0 && colon < slash) {
                throw this.error(L.l("Unknown taglib '{0}'.  Taglibs specified with an absolute URI must either be:\n1) specified in the web.xml\n2) defined in a jar's .tld in META-INF\n3) defined in a .tld in WEB-INF\n4) predefined by Resin", uri));
            }
            return;
        }
    }

    private void processTaglibDir(String prefix, String tagDir) throws JspParseException {
        Taglib taglib = null;
        try {
            taglib = this._tagManager.addTaglibDir(prefix, tagDir);
            String tagURI = "urn:jsptagdir:" + tagDir;
            this._parseState.pushNamespace(prefix, tagURI);
            this._namespaces = new Namespace(this._namespaces, prefix, tagURI);
            return;
        }
        catch (JspParseException e) {
            throw this.error((Exception)((Object)e));
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return;
        }
    }

    private void processIncludeDirective(ArrayList keys, ArrayList values) throws IOException, JspParseException {
        int p = keys.indexOf("file");
        if (p < 0) {
            throw this.error(L.l("The include directive requires a 'file' attribute."));
        }
        String file = (String)values.get(p);
        this.pushInclude(file);
    }

    public void pushInclude(String value) throws IOException, JspParseException {
        this.pushInclude(value, false);
    }

    public void pushInclude(String value, boolean allowDuplicate) throws IOException, JspParseException {
        if (value.equals("")) {
            throw this.error("include directive needs 'file' attribute. Use either <%@ include file='myfile.jsp' %> or <jsp:directive.include file='myfile.jsp'/>");
        }
        Path include = value.length() > 0 && value.charAt(0) == '/' ? this._parseState.resolvePath(value) : this._parseState.resolvePath(this._uriPwd + value);
        String newUrl = this._uriPwd;
        newUrl = value.startsWith("/") ? value : this._uriPwd + value;
        include.setUserPath(newUrl);
        int p = newUrl.lastIndexOf(47);
        String newUrlPwd = newUrl.substring(0, p + 1);
        if (this._jspPath != null && this._jspPath.equals(include) && !allowDuplicate) {
            throw this.error(L.l("circular include of '{0}' forbidden.  A JSP file may not include itself.", include));
        }
        for (int i = 0; i < this._includes.size(); ++i) {
            Include inc = this._includes.get(i);
            if (inc._stream == null || inc._stream.getPath() == null || !inc._stream.getPath().equals(include) || allowDuplicate) continue;
            throw this.error(L.l("circular include of '{0}'.  A JSP file may not include itself.", include));
        }
        try {
            this.addInclude(include.openRead(), newUrlPwd);
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
            if (include.exists()) {
                throw this.error(L.l("can't open include of '{0}'.  '{1}' exists but it's not readable.", (Object)value, include.getNativePath()));
            }
            throw this.error(L.l("can't open include of '{0}'.  '{1}' does not exist.", (Object)value, include.getNativePath()));
        }
    }

    private void addInclude(ReadStream stream, String newUrlPwd) throws IOException, JspParseException {
        this.addText();
        this.readLf();
        Include inc = null;
        if (this._stream != null) {
            inc = new Include(this._localPrefixes, this._stream, this._line, this._uriPwd, this._parseState.isLocalScriptingInvalid());
            this._parseState.setLocalScriptingInvalid(false);
            this._includes.add(inc);
            this._localPrefixes = new HashSet<String>();
        }
        this._parseState.addDepend(stream.getPath());
        try {
            String encoding = this._stream.getEncoding();
            if (encoding != null) {
                stream.setEncoding(encoding);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this._stream = stream;
        this._filename = stream.getUserPath();
        this._jspPath = stream.getPath();
        this._lineStart = this._line = 1;
        this._uriPwd = newUrlPwd;
        this._parseState.setUriPwd(this._uriPwd);
    }

    private int skipWhitespace(int ch) throws IOException, JspParseException {
        while (XmlChar.isWhitespace(ch)) {
            ch = this.read();
        }
        return ch;
    }

    private int skipWhitespaceToEndOfLine(int ch) throws IOException, JspParseException {
        while (XmlChar.isWhitespace(ch)) {
            if (ch == 10) {
                return this.read();
            }
            if (ch == 13) {
                ch = this.read();
                if (ch == 10) {
                    return this.read();
                }
                return ch;
            }
            ch = this.read();
        }
        return ch;
    }

    private void addText(char ch) {
        this._text.append(ch);
    }

    private void addText(String s) {
        this._text.append(s);
    }

    private void addText() throws JspParseException {
        if (this._text.length() > 0) {
            this.createText();
        }
        this._startText = this._charCount;
        this._lineStart = this._line;
    }

    private void createText() throws JspParseException {
        String string = this._text.toString();
        this.setLocation(this._jspPath, this._filename, this._lineStart);
        if (!this._parseState.isTrimWhitespace() || !this.isWhitespace(string)) {
            this._jspBuilder.text(string, this._filename, this._lineStart, this._line);
        }
        this._lineStart = this._line;
        this._text.clear();
        this._startText = this._charCount;
    }

    private boolean isWhitespace(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private int getTag(String name) throws JspParseException {
        int p = name.indexOf(58);
        if (p < 0) {
            return 0;
        }
        String prefix = name.substring(0, p);
        String local = name.substring(p + 1);
        this._prefixes.add(prefix);
        this._localPrefixes.add(prefix);
        String url = Namespace.find(this._namespaces, prefix);
        if (url != null) {
            return 1;
        }
        return 0;
    }

    private void unread(int ch) {
        this._peek = ch;
    }

    private void readLf() throws IOException, JspParseException {
        int ch;
        if (this._seenCr && (ch = this.read()) != 10) {
            this._peek = ch;
        }
    }

    private int read() throws IOException, JspParseException {
        if (this._peek >= 0) {
            int ch = this._peek;
            this._peek = -1;
            return ch;
        }
        try {
            int ch = this._stream.readChar();
            if (ch >= 0) {
                ++this._charCount;
                if (ch == 13) {
                    ++this._line;
                    this._charCount = 0;
                    this._seenCr = true;
                } else if (ch == 10 && this._seenCr) {
                    this._seenCr = false;
                    this._charCount = 0;
                } else if (ch == 10) {
                    ++this._line;
                    this._charCount = 0;
                } else {
                    this._seenCr = false;
                }
                return ch;
            }
        }
        catch (IOException e) {
            throw this.error(e.toString());
        }
        this._stream.close();
        this._seenCr = false;
        if (this._includes.size() > 0) {
            this.setLocation(this._jspPath, this._filename, this._line);
            Include include = this._includes.get(this._includes.size() - 1);
            this._includes.remove(this._includes.size() - 1);
            this._stream = include._stream;
            this._filename = this._stream.getUserPath();
            this._jspPath = this._stream.getPath();
            this._lineStart = this._line = include._line;
            this._uriPwd = include._uriPwd;
            this._localPrefixes = include._localPrefixes;
            this._parseState.setUriPwd(this._uriPwd);
            this._parseState.setLocalScriptingInvalid(include._oldLocalScriptingDisabled);
            this.setLocation(this._jspPath, this._filename, this._line);
            return this.read();
        }
        return -1;
    }

    void clear(Path appDir, String errorPage) {
    }

    public JspParseException error(Exception e) {
        String message = e.getMessage();
        if (e instanceof JspParseException) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (e instanceof JspLineParseException) {
            return (JspLineParseException)((Object)e);
        }
        if (e instanceof LineCompileException) {
            return new JspLineParseException(e);
        }
        if (this._lineMap == null) {
            return new JspLineParseException(this._filename + ":" + this._line + ": " + message, e);
        }
        LineMap.Line line = this._lineMap.getLine(this._line);
        return new JspLineParseException(line.getSourceFilename() + ":" + line.getSourceLine(this._line) + ": " + message, e);
    }

    public JspParseException error(String message) {
        JspGenerator gen = this._jspBuilder.getGenerator();
        if (this._lineMap == null) {
            if (gen != null) {
                return new JspLineParseException(this._filename + ":" + this._line + ": " + message + gen.getSourceLines(this._jspPath, this._line));
            }
            return new JspLineParseException(this._filename + ":" + this._line + ": " + message);
        }
        LineMap.Line line = this._lineMap.getLine(this._line);
        return new JspLineParseException(line.getSourceFilename() + ":" + line.getSourceLine(this._line) + ": " + message);
    }

    public JspParseException error(String message, Throwable e) {
        if (this._lineMap == null) {
            return new JspLineParseException(this._filename + ":" + this._line + ": " + message, e);
        }
        LineMap.Line line = this._lineMap.getLine(this._line);
        return new JspLineParseException(line.getSourceFilename() + ":" + line.getSourceLine(this._line) + ": " + message, e);
    }

    private void setLocation() {
        this.setLocation(this._jspPath, this._filename, this._line);
    }

    private void setLocation(Path jspPath, String filename, int line) {
        if (this._lineMap == null) {
            this._jspBuilder.setLocation(jspPath, filename, line);
        } else {
            LineMap.Line srcLine = this._lineMap.getLine(line);
            if (srcLine != null) {
                this._jspBuilder.setLocation(jspPath, srcLine.getSourceFilename(), srcLine.getSourceLine(line));
            }
        }
    }

    private String badChar(int ch) {
        if (ch < 0) {
            return "end of file";
        }
        if (ch == 10 || ch == 13) {
            return "end of line";
        }
        if (ch >= 32 && ch <= 127) {
            return "'" + (char)ch + "'";
        }
        return "'" + (char)ch + "' (\\u" + this.hex(ch) + ")";
    }

    private String hex(int value) {
        CharBuffer cb = new CharBuffer();
        for (int b = 3; b >= 0; --b) {
            int v = value >> 4 * b & 0xF;
            if (v < 10) {
                cb.append((char)(v + 48));
                continue;
            }
            cb.append((char)(v - 10 + 97));
        }
        return cb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Include {
        ReadStream _stream;
        int _line;
        String _uriPwd;
        Set<String> _localPrefixes;
        boolean _oldLocalScriptingDisabled;

        Include(Set<String> prefixes, ReadStream stream, int line, String uriPwd, boolean oldLocalScriptingDisabled) {
            this._stream = stream;
            this._line = line;
            this._uriPwd = uriPwd;
            this._localPrefixes = prefixes;
            this._oldLocalScriptingDisabled = oldLocalScriptingDisabled;
        }
    }
}

