/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jstl.el.SqlQueryTag;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.sql.DataSource;

public class SqlTransactionTag
extends TagSupport
implements TryCatchFinally {
    private static final Logger log = Logger.getLogger(SqlTransactionTag.class.getName());
    private static final L10N L = new L10N(SqlTransactionTag.class);
    private Expr _dataSource;
    private Expr _isolation;
    private Connection _conn;
    private int _oldIsolation;

    public void setDataSource(Expr dataSource) {
        this._dataSource = dataSource;
    }

    public void setIsolation(Expr isolation) {
        this._isolation = isolation;
    }

    public int doStartTag() throws JspException {
        if (this.pageContext.getAttribute("caucho.jstl.sql.conn") != null) {
            throw new JspTagException(L.l("nexted sql:transaction are forbidden"));
        }
        ELContext env = this.pageContext.getELContext();
        try {
            DataSource ds = this._dataSource != null ? SqlQueryTag.getDataSource(this.pageContext, this._dataSource.evalObject(env)) : SqlQueryTag.getDataSource(this.pageContext, null);
            int isolationCode = -1;
            if (this._isolation != null) {
                String isolation = this._isolation.evalString(env);
                if (isolation.equals("read_committed")) {
                    isolationCode = 2;
                } else if (isolation.equals("read_uncommitted")) {
                    isolationCode = 1;
                } else if (isolation.equals("repeatable_read")) {
                    isolationCode = 4;
                } else if (isolation.equals("serializable")) {
                    isolationCode = 8;
                } else {
                    throw new JspTagException(L.l("unknown sql:transaction isolation ~{0}'", isolation));
                }
            }
            this._conn = ds.getConnection();
            this._oldIsolation = this._conn.getTransactionIsolation();
            this._conn.setAutoCommit(false);
            if (this._isolation != null && isolationCode != this._oldIsolation) {
                this._conn.setTransactionIsolation(isolationCode);
            }
            this.pageContext.setAttribute("caucho.jstl.sql.conn", (Object)this._conn);
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public void doCatch(Throwable t) throws Throwable {
        if (this._conn != null) {
            this._conn.rollback();
        }
        throw t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinally() {
        block10: {
            try {
                this.pageContext.removeAttribute("caucho.jstl.sql.conn");
                if (this._conn == null) break block10;
                Connection conn = this._conn;
                this._conn = null;
                try {
                    conn.commit();
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    try {
                        conn.setTransactionIsolation(this._oldIsolation);
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    conn.setTransactionIsolation(this._oldIsolation);
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }
}

