/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jstl.ResultImpl;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.sql.SQLExecutionTag;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.sql.DataSource;

public class SqlQueryTag
extends BodyTagSupport
implements SQLExecutionTag {
    private static final Logger log = Logger.getLogger(SqlQueryTag.class.getName());
    private static final L10N L = new L10N(SqlQueryTag.class);
    private String _sql;
    private String _var;
    private String _scope;
    private Object _dataSource;
    private int _maxRows = -1;
    private boolean _hasMaxRows;
    private int _startRow = -1;
    private ArrayList<Object> _params;

    public void setSql(String sql) {
        this._sql = sql;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setDataSource(Object dataSource) throws JspException {
        this._dataSource = dataSource;
        if (this.pageContext.getAttribute("caucho.jstl.sql.conn") != null) {
            throw new JspException(L.l("sql:query cannot set data-source inside sql:transaction"));
        }
    }

    public void setMaxRows(int maxRows) throws JspException {
        this._maxRows = maxRows;
        this._hasMaxRows = true;
    }

    public void setStartRow(int startRow) {
        this._startRow = startRow;
    }

    public void addSQLParameter(Object value) {
        if (this._params == null) {
            this._params = new ArrayList();
        }
        this._params.add(value);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        ResultSet rs;
        Statement stmt;
        Connection conn = null;
        boolean isTransaction = false;
        String sql = null;
        sql = this._sql != null ? this._sql : this.bodyContent.getString();
        conn = (Connection)this.pageContext.getAttribute("caucho.jstl.sql.conn");
        if (conn != null) {
            isTransaction = true;
        }
        if (!isTransaction) {
            conn = SqlQueryTag.getConnection(this.pageContext, this._dataSource);
        }
        Object value = null;
        ArrayList<Object> params = this._params;
        this._params = null;
        int paramCount = this.countParameters(sql);
        if (params == null && paramCount != 0 || params != null && paramCount != params.size()) {
            throw new SQLException(L.l("sql:param does not match expected parameters\nin '{0}'", sql));
        }
        int maxRows = -1;
        if (this._hasMaxRows) {
            maxRows = this._maxRows;
        } else {
            Object maxRowsValue = Config.find((PageContext)this.pageContext, (String)"javax.servlet.jsp.jstl.sql.maxRows");
            try {
                if (maxRowsValue instanceof Number) {
                    maxRows = ((Number)maxRowsValue).intValue();
                } else if (maxRowsValue != null) {
                    maxRows = Integer.valueOf(String.valueOf(maxRowsValue));
                }
            }
            catch (NumberFormatException e) {
                throw new JspException(e.getMessage());
            }
        }
        if (maxRows < -1) {
            throw new JspException(L.l("sql:query maxRows '{0}' must not be less than -1.", maxRows));
        }
        if (params == null) {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
        } else {
            PreparedStatement pstmt = conn.prepareStatement(sql);
            stmt = pstmt;
            for (int i = 0; i < params.size(); ++i) {
                Object paramValue = params.get(i);
                pstmt.setObject(i + 1, paramValue);
            }
            rs = pstmt.executeQuery();
        }
        int startRow = this._startRow;
        while (startRow-- > 0 && rs.next()) {
        }
        ResultImpl result = new ResultImpl(rs, maxRows);
        rs.close();
        stmt.close();
        CoreSetTag.setValue(this.pageContext, this._var, this._scope, result);
        Object var14_19 = null;
        if (conn == null) return 6;
        try {
            conn.close();
            return 6;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return 6;
        {
            catch (JspException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JspException(L.l("sql:query '{0}' failed:\n{1}", (Object)sql, e.getMessage()), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            throw throwable;
        }
    }

    private int countParameters(String sql) {
        if (sql == null) {
            return 0;
        }
        int len = sql.length();
        boolean inQuote = false;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = sql.charAt(i);
            if (ch == '\'') {
                inQuote = !inQuote;
                continue;
            }
            if (ch == '\\') {
                ++i;
                continue;
            }
            if (ch != '?') continue;
            ++count;
        }
        return count;
    }

    public static DataSource getDataSource(PageContext pageContext, Object ds) throws JspException {
        if (ds == null) {
            ds = Config.find((PageContext)pageContext, (String)"javax.servlet.jsp.jstl.sql.dataSource");
        }
        if (ds instanceof DataSource) {
            return (DataSource)ds;
        }
        if (!(ds instanceof String)) {
            throw new JspException(L.l("'{0}' is an invalid DataSource.", ds));
        }
        String key = (String)ds;
        try {
            String jndiName = key.startsWith("java:comp/") ? key : "java:comp/env/" + key;
            Object value = new InitialContext().lookup(jndiName);
            if (value instanceof DataSource) {
                return (DataSource)value;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        DataSource dataSource = SqlQueryTag.getDataSource(key);
        if (dataSource != null) {
            return dataSource;
        }
        throw new JspException(L.l("'{0}' is an invalid DataSource.", ds));
    }

    public static Connection getConnection(PageContext pageContext, Object ds) throws JspException {
        try {
            if (ds == null) {
                ds = Config.find((PageContext)pageContext, (String)"javax.servlet.jsp.jstl.sql.dataSource");
            }
            if (ds instanceof DataSource) {
                return ((DataSource)ds).getConnection();
            }
            if (!(ds instanceof String)) {
                throw new JspException(L.l("'{0}' is an invalid DataSource.", ds));
            }
            String key = (String)ds;
            try {
                String jndiName = key.startsWith("java:comp/") ? key : "java:comp/env/" + key;
                Object value = new InitialContext().lookup(jndiName);
                if (value instanceof DataSource) {
                    return ((DataSource)value).getConnection();
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            return SqlQueryTag.getDriverConnection(key);
        }
        catch (SQLException e) {
            throw new JspException(L.l("'{0}' is an invalid DataSource.\n{1}", ds, e.getMessage()), (Throwable)e);
        }
    }

    private static DataSource getDataSource(String key) {
        String[] split = key.split(",");
        String url = split[0];
        String user = split.length >= 3 ? split[2] : null;
        String password = split.length >= 4 ? split[3] : null;
        try {
            String className = null;
            if (split.length >= 2) {
                className = split[1];
            }
            if (className != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName(className, false, loader);
                Driver driver = (Driver)cl.newInstance();
                Properties info = new Properties();
                if (user != null) {
                    info.put("user", user);
                }
                if (password != null) {
                    info.put("password", password);
                }
                return new DriverDataSource(driver, url, info);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return null;
    }

    private static Connection getDriverConnection(String key) throws SQLException {
        String[] split = key.split(",");
        String url = split[0];
        String user = split.length >= 3 ? split[2] : null;
        String password = split.length >= 4 ? split[3] : null;
        try {
            String className = null;
            if (split.length >= 2) {
                className = split[1];
            }
            if (className != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName(className, false, loader);
                Driver driver = (Driver)cl.newInstance();
                Properties info = new Properties();
                if (user != null) {
                    info.put("user", user);
                }
                if (password != null) {
                    info.put("password", password);
                }
                return driver.connect(url, info);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (user != null && password != null) {
            return DriverManager.getConnection(url, user, password);
        }
        return DriverManager.getConnection(url);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DriverDataSource
    implements DataSource {
        private Driver _driver;
        private String _url;
        private Properties _info;

        DriverDataSource(Driver driver, String url, Properties info) {
            this._driver = driver;
            this._url = url;
            this._info = info;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this._driver.connect(this._url, this._info);
        }

        @Override
        public Connection getConnection(String user, String password) throws SQLException {
            return this.getConnection();
        }

        @Override
        public PrintWriter getLogWriter() {
            return null;
        }

        @Override
        public void setLogWriter(PrintWriter out) {
        }

        @Override
        public int getLoginTimeout() {
            return 0;
        }

        @Override
        public void setLoginTimeout(int timeout) {
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

